/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.FileRulesModel;
import fr.gouv.vitam.common.model.administration.RuleMeasurementEnum;
import fr.gouv.vitam.common.model.administration.RuleType;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.identity.ServerIdentityConfiguration;
import fr.gouv.vitamui.commons.rest.dto.RuleDto;
import fr.gouv.vitamui.referential.common.service.VitamRuleService;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServerIdentityConfiguration.class})
public class VitamRuleServiceTest {
    private AdminExternalClient adminExternalClient;
    private AccessExternalClient accessExternalClient;
    private VitamRuleService vitamRuleService;
    private ObjectMapper objectMapper;

    @Before
    public void setUp() {
        this.adminExternalClient = (AdminExternalClient)EasyMock.mock(AdminExternalClient.class);
        this.accessExternalClient = (AccessExternalClient)EasyMock.mock(AccessExternalClient.class);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.vitamRuleService = new VitamRuleService(this.adminExternalClient, this.objectMapper, this.accessExternalClient);
        PowerMock.suppress((Constructor)PowerMock.constructor(ServerIdentityConfiguration.class));
        PowerMock.mockStatic(ServerIdentityConfiguration.class);
        ServerIdentityConfiguration serverIdentityConfigurationMock = (ServerIdentityConfiguration)PowerMock.createMock(ServerIdentityConfiguration.class);
        EasyMock.expect((Object)ServerIdentityConfiguration.getInstance()).andReturn((Object)serverIdentityConfigurationMock).anyTimes();
        EasyMock.expect((Object)serverIdentityConfigurationMock.getLoggerMessagePrepend()).andReturn((Object)"LOG TESTS VitamRuleServiceTest - ").anyTimes();
        PowerMock.replay((Object[])new Object[]{ServerIdentityConfiguration.class});
        PowerMock.replay((Object[])new Object[]{serverIdentityConfigurationMock});
    }

    @Test
    public void findRules_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode select = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findRules(vitamContext, (JsonNode)select)).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findRules_should_return_ok_when_vitamclient_ok$0(vitamContext, (JsonNode)select)).doesNotThrowAnyException();
    }

    @Test
    public void findRules_should_throw_BadRequestException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode select = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findRules(vitamContext, (JsonNode)select)).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findRules_should_throw_BadRequestException_when_vitamclient_400$1(vitamContext, (JsonNode)select)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findRules_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode select = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findRules(vitamContext, (JsonNode)select)).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findRules_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$2(vitamContext, (JsonNode)select)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void findRuleById_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        EasyMock.expect((Object)this.adminExternalClient.findRuleById(vitamContext, id)).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.findRuleById(vitamContext, id)).doesNotThrowAnyException();
    }

    @Test
    public void findRuleById_should_throw_BadRequestException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        EasyMock.expect((Object)this.adminExternalClient.findRuleById(vitamContext, id)).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.findRuleById(vitamContext, id)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findRuleById_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String id = "id_0";
        EasyMock.expect((Object)this.adminExternalClient.findRuleById(vitamContext, id)).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.findRuleById(vitamContext, id)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void export_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setEvId("1");
        EasyMock.expect((Object)this.accessExternalClient.selectOperations((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().addResult((Object)logbookOperation).setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.accessExternalClient});
        EasyMock.expect((Object)this.adminExternalClient.downloadRulesCsvAsStream((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class))).andReturn((Object)Response.status((int)200).build());
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.export(vitamContext)).doesNotThrowAnyException();
    }

    @Test
    public void export_should_throw_VitamClientException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setEvId("1");
        EasyMock.expect((Object)this.accessExternalClient.selectOperations((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.accessExternalClient});
        EasyMock.expect((Object)this.adminExternalClient.downloadRulesCsvAsStream((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class))).andReturn((Object)Response.status((int)400).build());
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.export(vitamContext)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void export_should_throw_VitamClientException_when_vitamclient_throw_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setEvId("1");
        EasyMock.expect((Object)this.accessExternalClient.selectOperations((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andThrow((Throwable)new VitamClientException("Exception thrown by vitam"));
        EasyMock.replay((Object[])new Object[]{this.accessExternalClient});
        EasyMock.expect((Object)this.adminExternalClient.downloadRulesCsvAsStream((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class))).andThrow((Throwable)new VitamClientException("Exception thrown by vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.export(vitamContext)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void patchRule_should_return_ok_when_findRules_ok() throws VitamClientException, InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        FileRulesModel patchRule = new FileRulesModel();
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.expect((Object)this.adminExternalClient.createRules((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(InputStream.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.patchRule(vitamContext, id, patchRule)).doesNotThrowAnyException();
    }

    @Test
    public void patchRule_should_throw_BadRequestException_when_findRules_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        FileRulesModel patchRule = new FileRulesModel();
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.patchRule(vitamContext, id, patchRule)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void patchRule_should_throw_VitamClientException_when_vitamclient_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        FileRulesModel patchRule = new FileRulesModel();
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andThrow((Throwable)new VitamClientException("Exception thrown by vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.patchRule(vitamContext, id, patchRule)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void deleteRule_should_return_ok_when_findRules_ok() throws VitamClientException, InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.expect((Object)this.adminExternalClient.createRules((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(InputStream.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.deleteRule(vitamContext, id)).doesNotThrowAnyException();
    }

    @Test
    public void deleteRule_should_throw_BadRequestException_when_findRules_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.deleteRule(vitamContext, id)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void deleteRule_should_throw_VitamClientException_when_findRules_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andThrow((Throwable)new VitamClientException("Exception throw by vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.deleteRule(vitamContext, id)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void create_should_return_ok_when_findRules_ok() throws VitamClientException, InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel newRule = new FileRulesModel();
        newRule.setRuleType(RuleType.AppraisalRule);
        newRule.setRuleMeasurement(RuleMeasurementEnum.YEAR);
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.expect((Object)this.adminExternalClient.createRules((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(InputStream.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.createRule(vitamContext, newRule)).doesNotThrowAnyException();
    }

    @Test
    public void create_should_throw_BadRequestException_when_findRules_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel newRule = new FileRulesModel();
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.createRule(vitamContext, newRule)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void create_should_throw_VitamClientException_when_findRules_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel newRule = new FileRulesModel();
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andThrow((Throwable)new VitamClientException("Exception thrown by vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.createRule(vitamContext, newRule)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void checkRule_should_return_exception_when_vitam_response_is_null() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        RuleDto ruleDto = new RuleDto();
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamRuleService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).hasMessage("The body is not found");
        Assertions.assertThatCode(() -> this.vitamRuleService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void checkRule_should_not_throw_ConflictException_when_requested_ruleId_and_ruleType_already_exist_in_vitam() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel existingRule = new FileRulesModel();
        existingRule.setId("id_0");
        existingRule.setRuleId("APP-00001");
        existingRule.setRuleType(RuleType.AppraisalRule);
        FileRulesModel secondExistingRule = new FileRulesModel();
        secondExistingRule.setId("id_1");
        secondExistingRule.setRuleId("ACC-00001");
        secondExistingRule.setRuleType(RuleType.AccessRule);
        RuleDto ruleDto = new RuleDto();
        ruleDto.setId("id_0");
        ruleDto.setRuleId("APP-00001");
        ruleDto.setRuleType("AppraisalRule");
        RequestResponseOK mockResponse = new RequestResponseOK();
        mockResponse.setHttpCode(200);
        mockResponse.addResult((Object)existingRule);
        mockResponse.addResult((Object)secondExistingRule);
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)mockResponse);
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThat((List)mockResponse.getResults()).hasSize(2);
        Assertions.assertThatCode(() -> this.vitamRuleService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).doesNotThrowAnyException();
    }

    @Test
    public void checkRule_should_throw_ConflictException_when_requested_rule_does_not_exists_in_vitam() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel existingRule = new FileRulesModel();
        existingRule.setId("id_0");
        existingRule.setRuleId("APP-00001");
        existingRule.setRuleType(RuleType.AppraisalRule);
        RuleDto ruleDto = new RuleDto();
        ruleDto.setId("id_0");
        ruleDto.setRuleId("APP-00002");
        ruleDto.setRuleType("AppraisalRule");
        RequestResponseOK mockResponse = new RequestResponseOK();
        mockResponse.setHttpCode(200);
        mockResponse.addResult((Object)existingRule);
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)mockResponse);
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThat((List)mockResponse.getResults()).hasSize(1);
        Assertions.assertThatCode(() -> this.vitamRuleService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).isInstanceOf(ConflictException.class);
    }

    @Test
    public void checkRule_should_not_throw_ConflictException_when_requested_ruleId_already_exist_in_vitam() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel existingRule = new FileRulesModel();
        existingRule.setId("id_0");
        existingRule.setRuleId("APP-00001");
        existingRule.setRuleType(RuleType.AppraisalRule);
        FileRulesModel secondExistingRule = new FileRulesModel();
        secondExistingRule.setId("id_1");
        secondExistingRule.setRuleId("ACC-00001");
        secondExistingRule.setRuleType(RuleType.AccessRule);
        FileRulesModel storageExistingRule = new FileRulesModel();
        secondExistingRule.setId("id_2");
        secondExistingRule.setRuleId("STO-00001");
        secondExistingRule.setRuleType(RuleType.StorageRule);
        RuleDto ruleDto = new RuleDto();
        ruleDto.setId("id_0");
        ruleDto.setRuleId("APP-00001");
        RequestResponseOK mockResponse = new RequestResponseOK();
        mockResponse.setHttpCode(200);
        mockResponse.addResult((Object)existingRule);
        mockResponse.addResult((Object)secondExistingRule);
        mockResponse.addResult((Object)storageExistingRule);
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)mockResponse);
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThat((List)mockResponse.getResults()).hasSize(3);
        Assertions.assertThatCode(() -> this.vitamRuleService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).doesNotThrowAnyException();
    }

    @Test
    public void checkRule_should_throw_BadRequestException_when_requested_rule_is_null() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        FileRulesModel existingRule = new FileRulesModel();
        existingRule.setId("id_0");
        existingRule.setRuleId("APP-00001");
        existingRule.setRuleType(RuleType.AppraisalRule);
        FileRulesModel secondExistingRule = new FileRulesModel();
        secondExistingRule.setId("id_1");
        secondExistingRule.setRuleId("ACC-00001");
        secondExistingRule.setRuleType(RuleType.AccessRule);
        FileRulesModel storageExistingRule = new FileRulesModel();
        secondExistingRule.setId("id_2");
        secondExistingRule.setRuleId("STO-00001");
        secondExistingRule.setRuleType(RuleType.StorageRule);
        RuleDto ruleDto = new RuleDto();
        RequestResponseOK mockResponse = new RequestResponseOK();
        mockResponse.setHttpCode(200);
        mockResponse.addResult((Object)existingRule);
        mockResponse.addResult((Object)secondExistingRule);
        mockResponse.addResult((Object)storageExistingRule);
        EasyMock.expect((Object)this.adminExternalClient.findRules((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)mockResponse);
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThat((List)mockResponse.getResults()).hasSize(3);
        Assertions.assertThatCode(() -> this.vitamRuleService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).isInstanceOf(BadRequestException.class);
        Assertions.assertThatCode(() -> this.vitamRuleService.checkExistenceOfRuleInVitam(ruleDto, vitamContext)).hasMessage("The body is not found");
    }

    private /* synthetic */ void lambda$findRules_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException$2(VitamContext vitamContext, JsonNode select) throws Throwable {
        this.vitamRuleService.findRules(vitamContext, select);
    }

    private /* synthetic */ void lambda$findRules_should_throw_BadRequestException_when_vitamclient_400$1(VitamContext vitamContext, JsonNode select) throws Throwable {
        this.vitamRuleService.findRules(vitamContext, select);
    }

    private /* synthetic */ void lambda$findRules_should_return_ok_when_vitamclient_ok$0(VitamContext vitamContext, JsonNode select) throws Throwable {
        this.vitamRuleService.findRules(vitamContext, select);
    }
}

