/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.io.CharStreams;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.AgenciesModel;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitamui.commons.api.domain.AgencyModelDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.identity.ServerIdentityConfiguration;
import fr.gouv.vitamui.commons.vitam.api.administration.AgencyService;
import fr.gouv.vitamui.referential.common.service.VitamAgencyService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServerIdentityConfiguration.class})
public class VitamAgencyServiceTest {
    private AdminExternalClient adminExternalClient;
    private AccessExternalClient accessExternalClient;
    private AgencyService agencyService;
    private ObjectMapper objectMapper;
    private VitamAgencyService vitamAgencyService;

    @Before
    public void setUp() {
        this.adminExternalClient = (AdminExternalClient)EasyMock.mock(AdminExternalClient.class);
        this.accessExternalClient = (AccessExternalClient)EasyMock.mock(AccessExternalClient.class);
        this.agencyService = (AgencyService)EasyMock.mock(AgencyService.class);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.vitamAgencyService = new VitamAgencyService(this.adminExternalClient, this.agencyService, this.objectMapper, this.accessExternalClient);
        PowerMock.suppress((Constructor)PowerMock.constructor(ServerIdentityConfiguration.class));
        PowerMock.mockStatic(ServerIdentityConfiguration.class);
        ServerIdentityConfiguration serverIdentityConfigurationMock = (ServerIdentityConfiguration)PowerMock.createMock(ServerIdentityConfiguration.class);
        EasyMock.expect((Object)ServerIdentityConfiguration.getInstance()).andReturn((Object)serverIdentityConfigurationMock).anyTimes();
        EasyMock.expect((Object)serverIdentityConfigurationMock.getLoggerMessagePrepend()).andReturn((Object)"LOG TESTS VitamAgencyServiceTest - ").anyTimes();
        PowerMock.replay((Object[])new Object[]{ServerIdentityConfiguration.class});
        PowerMock.replay((Object[])new Object[]{serverIdentityConfigurationMock});
    }

    @Test
    public void export_should_return_ok_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setEvId("1");
        EasyMock.expect((Object)this.accessExternalClient.selectOperations((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().addResult((Object)logbookOperation).setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.accessExternalClient});
        EasyMock.expect((Object)this.adminExternalClient.downloadAgenciesCsvAsStream((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class))).andReturn((Object)Response.status((int)200).build());
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamAgencyService.export(vitamContext)).doesNotThrowAnyException();
    }

    @Test
    public void export_should_throw_VitamClientException_when_vitamclient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setEvId("1");
        EasyMock.expect((Object)this.accessExternalClient.selectOperations((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.accessExternalClient});
        EasyMock.expect((Object)this.adminExternalClient.downloadAgenciesCsvAsStream((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class))).andReturn((Object)Response.status((int)400).build());
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamAgencyService.export(vitamContext)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void export_should_throw_VitamClientException_when_vitamclient_throw_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        LogbookOperation logbookOperation = new LogbookOperation();
        logbookOperation.setEvId("1");
        EasyMock.expect((Object)this.accessExternalClient.selectOperations((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andThrow((Throwable)new VitamClientException("Exception thrown by vitam"));
        EasyMock.replay((Object[])new Object[]{this.accessExternalClient});
        EasyMock.expect((Object)this.adminExternalClient.downloadAgenciesCsvAsStream((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class))).andThrow((Throwable)new VitamClientException("Exception thrown by vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamAgencyService.export(vitamContext)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void patchAgency_should_return_ok_when_vitamclient_ok() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        AgencyModelDto patchAgency = new AgencyModelDto();
        EasyMock.expect((Object)this.agencyService.findAgencies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(ObjectNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.expect((Object)this.adminExternalClient.createAgencies((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(InputStream.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.agencyService, this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamAgencyService.patchAgency(vitamContext, id, patchAgency)).doesNotThrowAnyException();
    }

    @Test
    public void patchAgency_should_return_400_when_vitamclient_400() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        AgencyModelDto patchAgency = new AgencyModelDto();
        EasyMock.expect((Object)this.agencyService.findAgencies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(ObjectNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.expect((Object)this.adminExternalClient.createAgencies((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(InputStream.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.agencyService, this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamAgencyService.deleteAgency(vitamContext, id)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void patchAgency_should_throw_VitamClientException_when_vitamclient_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        AgencyModelDto patchAgency = new AgencyModelDto();
        EasyMock.expect((Object)this.agencyService.findAgencies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(ObjectNode.class))).andThrow((Throwable)new VitamClientException("Exception thrown by vitam"));
        EasyMock.replay((Object[])new Object[]{this.agencyService});
        Assertions.assertThatCode(() -> this.vitamAgencyService.patchAgency(vitamContext, id, patchAgency)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void patchAgency_should_return_ok_with_additional_properties() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        AgencyModelDto patchAgency = new AgencyModelDto();
        patchAgency.setId("agency_01");
        patchAgency.setName("AlexAgency");
        patchAgency.setDescription("AlexAgency super description");
        AgenciesModel agenciesModel = new AgenciesModel();
        agenciesModel.setId(patchAgency.getId());
        agenciesModel.setName(patchAgency.getName());
        EasyMock.expect((Object)this.agencyService.findAgencies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200).addResult((Object)agenciesModel));
        StringBuilder actualCsvContent = new StringBuilder();
        Capture isCapture = Capture.newInstance();
        EasyMock.expect((Object)this.adminExternalClient.createAgencies((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.capture((Capture)isCapture), (String)EasyMock.eq((Object)"Agencies.json"))).andAnswer(() -> {
            actualCsvContent.append(CharStreams.toString((Readable)new InputStreamReader((InputStream)isCapture.getValue(), StandardCharsets.UTF_8)));
            return new RequestResponseOK().setHttpCode(200);
        });
        EasyMock.replay((Object[])new Object[]{this.agencyService, this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamAgencyService.patchAgency(vitamContext, patchAgency.getId(), patchAgency)).doesNotThrowAnyException();
        EasyMock.verify((Object[])new Object[]{this.adminExternalClient});
        String expectedCsvContent = PropertiesUtils.getResourceAsString((String)"agency/agency_with_additional_properties.csv");
        Assertions.assertThat((String)expectedCsvContent).isEqualTo(actualCsvContent.toString());
    }

    @Test
    public void patchAgency_should_return_ok_with_additionnal_properties_and_existing() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        AgencyModelDto patchAgency = new AgencyModelDto();
        patchAgency.setId("agency_01");
        patchAgency.setName("AlexAgency");
        patchAgency.setDescription("AlexAgency super description");
        EasyMock.expect((Object)this.agencyService.findAgencies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200).addAllResults(List.of(new AgenciesModel(null, patchAgency.getName(), null, 4).setId(patchAgency.getId()), new AgenciesModel(null, "agency_15", null, 4).setId("agency_15"))));
        StringBuilder actualCsvContent = new StringBuilder();
        Capture isCapture = Capture.newInstance();
        EasyMock.expect((Object)this.adminExternalClient.createAgencies((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.capture((Capture)isCapture), (String)EasyMock.eq((Object)"Agencies.json"))).andAnswer(() -> {
            actualCsvContent.append(CharStreams.toString((Readable)new InputStreamReader((InputStream)isCapture.getValue(), StandardCharsets.UTF_8)));
            return new RequestResponseOK().setHttpCode(200);
        });
        EasyMock.replay((Object[])new Object[]{this.agencyService, this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamAgencyService.patchAgency(vitamContext, patchAgency.getId(), patchAgency)).doesNotThrowAnyException();
        EasyMock.verify((Object[])new Object[]{this.adminExternalClient});
        String expectedCsvContent = PropertiesUtils.getResourceAsString((String)"agency/agency_with_additional_properties_and_others.csv");
        Assertions.assertThat((String)expectedCsvContent).isEqualTo(actualCsvContent.toString());
    }

    @Test
    public void deleteAgency_should_return_ok_when_vitamclient_ok() throws VitamClientException, AccessExternalClientException, IOException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        EasyMock.expect((Object)this.agencyService.findAgencies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(ObjectNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.expect((Object)this.adminExternalClient.createAgencies((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(InputStream.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.agencyService});
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamAgencyService.deleteAgency(vitamContext, id)).doesNotThrowAnyException();
    }

    @Test
    public void deleteAgency_should_return_400_when_vitamclient_400() throws VitamClientException, AccessExternalClientException, InvalidParseOperationException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        EasyMock.expect((Object)this.agencyService.findAgencies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(ObjectNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.expect((Object)this.adminExternalClient.createAgencies((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(InputStream.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.agencyService});
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamAgencyService.deleteAgency(vitamContext, id)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void deleteAgency_should_throw_VitamClientException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String id = "id_0";
        EasyMock.expect((Object)this.agencyService.findAgencies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(ObjectNode.class))).andThrow((Throwable)new VitamClientException("Exception throw by vitam"));
        EasyMock.replay((Object[])new Object[]{this.agencyService});
        Assertions.assertThatCode(() -> this.vitamAgencyService.deleteAgency(vitamContext, id)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void create_should_return_ok_when_vitamclient_ok() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        AgencyModelDto newAgency = new AgencyModelDto();
        EasyMock.expect((Object)this.agencyService.findAgencies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(ObjectNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.expect((Object)this.adminExternalClient.createAgencies((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(InputStream.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.agencyService, this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamAgencyService.create(vitamContext, newAgency)).doesNotThrowAnyException();
    }

    @Test
    public void create_should_return_ok_when_vitamclient_400() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        AgencyModelDto newAgency = new AgencyModelDto();
        EasyMock.expect((Object)this.agencyService.findAgencies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(ObjectNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.expect((Object)this.adminExternalClient.createAgencies((VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(InputStream.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.agencyService, this.adminExternalClient});
        Assertions.assertThatCode(() -> this.vitamAgencyService.create(vitamContext, newAgency)).doesNotThrowAnyException();
    }

    @Test
    public void create_should_throw_VitamClientException_when_vitamclient_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        AgencyModelDto newAgency = new AgencyModelDto();
        EasyMock.expect((Object)this.agencyService.findAgencies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(ObjectNode.class))).andThrow((Throwable)new VitamClientException("Exception thrown by vitam"));
        EasyMock.replay((Object[])new Object[]{this.agencyService});
        Assertions.assertThatCode(() -> this.vitamAgencyService.create(vitamContext, newAgency)).isInstanceOf(VitamClientException.class);
    }
}

