/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.identity.ServerIdentityConfiguration;
import fr.gouv.vitamui.referential.common.service.OntologyService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServerIdentityConfiguration.class})
public class OntologyServiceTest {
    private AdminExternalClient adminExternalClient;
    private OntologyService ontologyService;

    @Before
    public void setUp() {
        this.adminExternalClient = (AdminExternalClient)EasyMock.mock(AdminExternalClient.class);
        this.ontologyService = new OntologyService(this.adminExternalClient);
        PowerMock.suppress((Constructor)PowerMock.constructor(ServerIdentityConfiguration.class));
        PowerMock.mockStatic(ServerIdentityConfiguration.class);
        ServerIdentityConfiguration serverIdentityConfigurationMock = (ServerIdentityConfiguration)PowerMock.createMock(ServerIdentityConfiguration.class);
        EasyMock.expect((Object)ServerIdentityConfiguration.getInstance()).andReturn((Object)serverIdentityConfigurationMock).anyTimes();
        EasyMock.expect((Object)serverIdentityConfigurationMock.getLoggerMessagePrepend()).andReturn((Object)"LOG TESTS OntologyServiceTest - ").anyTimes();
        PowerMock.replay((Object[])new Object[]{ServerIdentityConfiguration.class});
        PowerMock.replay((Object[])new Object[]{serverIdentityConfigurationMock});
    }

    @Test
    public void findOntologyById_should_return_ontologies_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String identifier = "0";
        EasyMock.expect((Object)this.adminExternalClient.findOntologyById((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.ontologyService.findOntologyById(vitamContext, identifier)).doesNotThrowAnyException();
    }

    @Test
    public void findOntologyById_should_return_vitamClientException_when_vitamClient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String identifier = "1";
        EasyMock.expect((Object)this.adminExternalClient.findOntologyById((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.ontologyService.findOntologyById(vitamContext, identifier)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findOntologyById_should_return_vitamClientException_when_vitamClient_throws_vitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String identifier = "1";
        EasyMock.expect((Object)this.adminExternalClient.findOntologyById((VitamContext)EasyMock.isA(VitamContext.class), (String)EasyMock.isA(String.class))).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.ontologyService.findOntologyById(vitamContext, identifier)).isInstanceOf(VitamClientException.class);
    }

    @Test
    public void findOntologies_should_return_ontologies_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findOntologies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findOntologies_should_return_ontologies_when_vitamclient_ok$3(vitamContext, (JsonNode)jsonNode)).doesNotThrowAnyException();
    }

    @Test
    public void findOntologies_should_return_vitamClientException_when_vitamClient_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findOntologies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findOntologies_should_return_vitamClientException_when_vitamClient_400$4(vitamContext, (JsonNode)jsonNode)).isInstanceOf(BadRequestException.class);
    }

    @Test
    public void findOntologies_should_return_vitamClientException_when_vitamClient_throws_vitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(2));
        ObjectNode jsonNode = JsonHandler.createObjectNode();
        EasyMock.expect((Object)this.adminExternalClient.findOntologies((VitamContext)EasyMock.isA(VitamContext.class), (JsonNode)EasyMock.isA(JsonNode.class))).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.lambda$findOntologies_should_return_vitamClientException_when_vitamClient_throws_vitamClientException$5(vitamContext, (JsonNode)jsonNode)).isInstanceOf(VitamClientException.class);
    }

    @Ignore
    @Test
    public void importOntologies_should_return_ok_when_vitamclient_ok() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ArrayList<OntologyModel> ontologies = new ArrayList<OntologyModel>();
        OntologyModel ontologyModel = new OntologyModel();
        ontologyModel.setIdentifier("identifier");
        ontologyModel.setId("1");
        ontologyModel.setTenant(Integer.valueOf(0));
        ontologies.add(ontologyModel);
        EasyMock.expect((Object)this.adminExternalClient.importOntologies(((Boolean)EasyMock.isA(Boolean.class)).booleanValue(), (VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(ByteArrayInputStream.class))).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.ontologyService.importOntologies(vitamContext, ontologies)).doesNotThrowAnyException();
    }

    @Ignore
    @Test
    public void importOntologies_should_return_ok_when_vitamclient_400() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ArrayList ontologies = new ArrayList();
        EasyMock.expect((Object)this.adminExternalClient.importOntologies(((Boolean)EasyMock.isA(Boolean.class)).booleanValue(), (VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(ByteArrayInputStream.class))).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.ontologyService.importOntologies(vitamContext, ontologies)).doesNotThrowAnyException();
    }

    @Ignore
    @Test
    public void importOntologies_should_throw_InvalidParseOperationException_when_vitamclient_throws_InvalidParseOperationException() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ArrayList ontologies = new ArrayList();
        EasyMock.expect((Object)this.adminExternalClient.importOntologies(((Boolean)EasyMock.isA(Boolean.class)).booleanValue(), (VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(ByteArrayInputStream.class))).andThrow((Throwable)new InvalidParseOperationException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.ontologyService.importOntologies(vitamContext, ontologies)).isInstanceOf(InvalidParseOperationException.class);
    }

    @Ignore
    @Test
    public void importOntologies_should_throw_AccessExternalClientException_when_vitamclient_throws_AccessExternalClientException() throws InvalidParseOperationException, AccessExternalClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        ArrayList ontologies = new ArrayList();
        EasyMock.expect((Object)this.adminExternalClient.importOntologies(((Boolean)EasyMock.isA(Boolean.class)).booleanValue(), (VitamContext)EasyMock.isA(VitamContext.class), (InputStream)EasyMock.isA(ByteArrayInputStream.class))).andThrow((Throwable)new AccessExternalClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.ontologyService.importOntologies(vitamContext, ontologies)).isInstanceOf(AccessExternalClientException.class);
    }

    private /* synthetic */ void lambda$findOntologies_should_return_vitamClientException_when_vitamClient_throws_vitamClientException$5(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.ontologyService.findOntologies(vitamContext, jsonNode);
    }

    private /* synthetic */ void lambda$findOntologies_should_return_vitamClientException_when_vitamClient_400$4(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.ontologyService.findOntologies(vitamContext, jsonNode);
    }

    private /* synthetic */ void lambda$findOntologies_should_return_ontologies_when_vitamclient_ok$3(VitamContext vitamContext, JsonNode jsonNode) throws Throwable {
        this.ontologyService.findOntologies(vitamContext, jsonNode);
    }
}

