/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.common.service;

import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.referential.common.service.IngestContractService;
import org.assertj.core.api.Assertions;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class IngestContractServiceTest {
    private AdminExternalClient adminExternalClient;
    private IngestContractService ingestContractService;

    @Before
    public void setUp() {
        this.adminExternalClient = (AdminExternalClient)EasyMock.mock(AdminExternalClient.class);
        this.ingestContractService = new IngestContractService(this.adminExternalClient);
    }

    @Test
    public void findIngestContract_should_return_ingestContracts_when_vitamclient_ok() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(0));
        String contractId = "IC-0";
        EasyMock.expect((Object)this.adminExternalClient.findIngestContractById(vitamContext, contractId)).andReturn((Object)new RequestResponseOK().setHttpCode(200));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatCode(() -> this.ingestContractService.findIngestContractById(vitamContext, contractId)).doesNotThrowAnyException();
    }

    @Test
    public void findIngestContract_should_throw_VitamClienException_when_vitamclient_returns_400() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String contractId = "IC-1";
        EasyMock.expect((Object)this.adminExternalClient.findIngestContractById(vitamContext, contractId)).andReturn((Object)new RequestResponseOK().setHttpCode(400));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatThrownBy(() -> this.ingestContractService.findIngestContractById(vitamContext, contractId)).isInstanceOf(InternalServerException.class);
    }

    @Test
    public void findIngestContract_should_throw_VitamClienException_when_vitamclient_throws_VitamClientException() throws VitamClientException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(1));
        String contractId = "IC-2";
        EasyMock.expect((Object)this.adminExternalClient.findIngestContractById(vitamContext, contractId)).andThrow((Throwable)new VitamClientException("Exception thrown by Vitam"));
        EasyMock.replay((Object[])new Object[]{this.adminExternalClient});
        Assertions.assertThatThrownBy(() -> this.ingestContractService.findIngestContractById(vitamContext, contractId)).isInstanceOf(VitamClientException.class);
    }
}

