/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.server.service;

import fr.gouv.vitam.collect.common.dto.TransactionDto;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.collect.internal.server.service.converters.TransactionConverter;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.RequestTimeOutException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.collect.CollectService;
import java.io.InputStream;
import javax.ws.rs.core.Response;

public class TransactionInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(TransactionInternalService.class);
    private final CollectService collectService;
    public static final String UNABLE_TO_UPDATE_TRANSACTION = "Unable to update transaction";
    public static final String UNABLE_TO_PROCESS_RESPONSE = "Unable to process response";
    public static final String UNABLE_TO_PROCESS_UNIT_UPDATE = "Unable to process units update operation";
    public static final String ERROR_400 = "ERROR_400";
    public static final String REQUEST_TIMEOUT_EXCEPTION_MESSAGE = "the server has decided to close the connection rather than continue waiting";

    public TransactionInternalService(CollectService collectService) {
        this.collectService = collectService;
    }

    public void validateTransaction(String idTransaction, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.validateTransaction(vitamContext, idTransaction);
            if (requestResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new VitamClientException("Error occurs when validating transaction!");
            }
        }
        catch (VitamClientException e) {
            throw new VitamClientException("Unable to validate transaction : ", (Throwable)e);
        }
    }

    public void sendTransaction(String idTransaction, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.sendTransaction(vitamContext, idTransaction);
            if (requestResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new VitamClientException("Error occurs when sending transaction!");
            }
        }
        catch (VitamClientException e) {
            throw new VitamClientException("Unable to send transaction : ", (Throwable)e);
        }
    }

    public void abortTransaction(String idTransaction, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.abortTransaction(vitamContext, idTransaction);
            if (requestResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new VitamClientException("Error occurs when aborting transaction!");
            }
        }
        catch (VitamClientException e) {
            throw new VitamClientException("Unable to abort transaction : ", (Throwable)e);
        }
    }

    public void reopenTransaction(String idTransaction, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.reopenTransaction(vitamContext, idTransaction);
            if (requestResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new VitamClientException("Error occurs when reopening transaction!");
            }
        }
        catch (VitamClientException e) {
            throw new VitamClientException("Unable to reopen transaction : ", (Throwable)e);
        }
    }

    public CollectTransactionDto getTransactionById(String transactionId, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.getTransactionById(vitamContext, transactionId);
            if (!requestResponse.isOk()) {
                throw new VitamClientException("Error occurs when getting transaction!");
            }
            return TransactionConverter.toVitamUiDto((TransactionDto)JsonHandler.getFromString((String)((RequestResponseOK)requestResponse).getFirstResult().toString(), TransactionDto.class));
        }
        catch (InvalidParseOperationException | VitamClientException e) {
            throw new VitamClientException("Unable to find transaction : ", e);
        }
    }

    public CollectTransactionDto updateTransaction(CollectTransactionDto collectTransactionDto, VitamContext vitamContext) {
        LOGGER.debug("CollectTransactionDto: ", (Object)collectTransactionDto);
        try {
            TransactionDto transactionDto = TransactionConverter.toVitamDto(collectTransactionDto);
            RequestResponse requestResponse = this.collectService.updateTransaction(vitamContext, transactionDto);
            if (!requestResponse.isOk()) {
                throw new VitamClientException("Error occurs when updating transaction!");
            }
            TransactionDto responseTransactionDto = (TransactionDto)JsonHandler.getFromString((String)((RequestResponseOK)requestResponse).getFirstResult().toString(), TransactionDto.class);
            return TransactionConverter.toVitamUiDto(responseTransactionDto);
        }
        catch (VitamClientException e) {
            LOGGER.debug("Unable to update transaction: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_UPDATE_TRANSACTION, (Throwable)e);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.debug("Unable to process response: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_PROCESS_RESPONSE, (Throwable)e);
        }
    }

    public String updateArchiveUnitsFromFile(InputStream inputStream, String transactionId, VitamContext vitamContext) throws RequestTimeOutException {
        LOGGER.debug("[Internal] call update Archive Units From File for transaction Id {}  ", (Object)transactionId);
        String result = this.collectService.updateCollectArchiveUnits(vitamContext, transactionId, inputStream);
        if (result.equals(ERROR_400)) {
            LOGGER.debug(UNABLE_TO_PROCESS_UNIT_UPDATE);
            throw new RequestTimeOutException(REQUEST_TIMEOUT_EXCEPTION_MESSAGE, REQUEST_TIMEOUT_EXCEPTION_MESSAGE);
        }
        return result;
    }
}

