/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.server.service;

import fr.gouv.vitam.collect.external.client.CollectExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.collect.common.dto.OperationIdDto;
import fr.gouv.vitamui.collect.common.dto.UpdateArchiveUnitDto;
import fr.gouv.vitamui.collect.common.dto.converter.UpdateArchiveUnitDtoToUpdateMultiQueryConverter;
import fr.gouv.vitamui.collect.common.exception.ArchiveUnitUpdateException;
import fr.gouv.vitamui.collect.common.model.OperationId;
import fr.gouv.vitamui.collect.common.service.ArchiveUnitService;
import fr.gouv.vitamui.collect.internal.server.service.ExternalParametersService;
import fr.gouv.vitamui.commons.api.converter.JsonPatchDtoToUpdateMultiQueryConverter;
import fr.gouv.vitamui.commons.api.converter.UpdateMultiQueriesToBulkCommandDto;
import fr.gouv.vitamui.commons.api.dtos.BulkCommandDto;
import fr.gouv.vitamui.commons.api.dtos.JsonPatchDto;
import fr.gouv.vitamui.commons.api.dtos.MultiJsonPatchDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArchiveUnitServiceImpl
implements ArchiveUnitService {
    private static final VitamUILogger log = VitamUILoggerFactory.getInstance(ArchiveUnitServiceImpl.class);
    private final CollectExternalClient collectExternalClient;
    private final UpdateArchiveUnitDtoToUpdateMultiQueryConverter updateArchiveUnitDtoToUpdateMultiQueryConverter;
    private final ExternalParametersService externalParametersService;
    private final JsonPatchDtoToUpdateMultiQueryConverter jsonPatchDtoToUpdateMultiQueryConverter;
    private final UpdateMultiQueriesToBulkCommandDto updateMultiQueriesToBulkCommandDto;

    @Autowired
    public ArchiveUnitServiceImpl(CollectExternalClient collectExternalClient, UpdateArchiveUnitDtoToUpdateMultiQueryConverter updateArchiveUnitDtoToUpdateMultiQueryConverter, ExternalParametersService externalParametersService, JsonPatchDtoToUpdateMultiQueryConverter jsonPatchDtoToUpdateMultiQueryConverter, UpdateMultiQueriesToBulkCommandDto updateMultiQueriesToBulkCommandDto) {
        this.collectExternalClient = collectExternalClient;
        this.updateArchiveUnitDtoToUpdateMultiQueryConverter = updateArchiveUnitDtoToUpdateMultiQueryConverter;
        this.externalParametersService = externalParametersService;
        this.jsonPatchDtoToUpdateMultiQueryConverter = jsonPatchDtoToUpdateMultiQueryConverter;
        this.updateMultiQueriesToBulkCommandDto = updateMultiQueriesToBulkCommandDto;
    }

    public OperationIdDto update(String transactionId, Set<UpdateArchiveUnitDto> updateArchiveUnitDtoSet) {
        Set<UpdateMultiQuery> updateMultiQueries = updateArchiveUnitDtoSet.stream().map(arg_0 -> ((UpdateArchiveUnitDtoToUpdateMultiQueryConverter)this.updateArchiveUnitDtoToUpdateMultiQueryConverter).convert(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (updateArchiveUnitDtoSet.size() != updateMultiQueries.size()) {
            throw new ArchiveUnitUpdateException("Fail to convert some archive unit updates payload to dsl queries");
        }
        return this.send(transactionId, updateMultiQueries);
    }

    public OperationIdDto update(String transactionId, JsonPatchDto jsonPatchDto) {
        UpdateMultiQuery updateMultiQuery = this.jsonPatchDtoToUpdateMultiQueryConverter.convert(jsonPatchDto);
        if (updateMultiQuery == null) {
            throw new ArchiveUnitUpdateException("Fail to convert json patch payload to dsl query");
        }
        Set<UpdateMultiQuery> updateMultiQueries = Set.of(updateMultiQuery);
        return this.send(transactionId, updateMultiQueries);
    }

    public OperationIdDto update(String transactionId, MultiJsonPatchDto multiJsonPatchDto) {
        Set<UpdateMultiQuery> updateMultiQueries = multiJsonPatchDto.stream().map(arg_0 -> ((JsonPatchDtoToUpdateMultiQueryConverter)this.jsonPatchDtoToUpdateMultiQueryConverter).convert(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (multiJsonPatchDto.size() != updateMultiQueries.size()) {
            throw new ArchiveUnitUpdateException("Fail to convert some json patch payloads to dsl queries");
        }
        return this.send(transactionId, updateMultiQueries);
    }

    private OperationIdDto send(String transactionId, Set<UpdateMultiQuery> updateMultiQueries) {
        VitamContext context = this.externalParametersService.buildVitamContextFromExternalParam();
        BulkCommandDto bulkCommandDto = this.updateMultiQueriesToBulkCommandDto.convert(updateMultiQueries);
        try {
            RequestResponseOK response = this.collectExternalClient.bulkAtomicUpdateUnits(context, transactionId, JsonHandler.toJsonNode((Object)bulkCommandDto));
            OperationId operationId = new OperationId(response.getHeaderString("X-Request-Id"));
            OperationIdDto operationIdDto = new OperationIdDto().setOperationId(operationId);
            log.info("Operation started: {}", (Object)operationIdDto);
            return operationIdDto;
        }
        catch (InvalidParseOperationException | VitamClientException e) {
            log.error("{}", e);
            throw new ArchiveUnitUpdateException(e);
        }
    }
}

