/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.collect.internal.server.service.SearchCriteriaHistoryInternalService;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaHistoryDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import io.swagger.annotations.Api;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/searchcriteriahistory"})
@Api(tags={"searchcriteriahistory"}, value="Search Criteria History")
public class SearchCriteriaHistoryInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(SearchCriteriaHistoryInternalController.class);
    private SearchCriteriaHistoryInternalService searchCriteriaHistoryInternalService;

    @Autowired
    public SearchCriteriaHistoryInternalController(SearchCriteriaHistoryInternalService searchCriteriaHistoryInternalService) {
        this.searchCriteriaHistoryInternalService = searchCriteriaHistoryInternalService;
    }

    @GetMapping(value={"/me"})
    public List<SearchCriteriaHistoryDto> getSearchCriteriaHistoryDtos() {
        LOGGER.debug("getSearchCriteriaHistoryDtos");
        return this.searchCriteriaHistoryInternalService.getSearchCriteriaHistoryDtos();
    }

    @PostMapping
    public SearchCriteriaHistoryDto create(@Valid @RequestBody SearchCriteriaHistoryDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"the Search Criteria is mandatory : ", (Object[])new Object[]{dto});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create SearchCriteriaHistory {}", (Object)dto);
        return (SearchCriteriaHistoryDto)this.searchCriteriaHistoryInternalService.create((IdDto)dto);
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Delete SearchCriteriaHistory with id :{}", (Object)id);
        this.searchCriteriaHistoryInternalService.delete(id);
    }

    @PutMapping(value={"/{id}"})
    public SearchCriteriaHistoryDto update(@RequestBody SearchCriteriaHistoryDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (Object[])new Object[]{dto});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Update SearchCriteriaHistory with id :{}", (Object)dto.getId());
        return (SearchCriteriaHistoryDto)this.searchCriteriaHistoryInternalService.update((IdDto)dto);
    }

    @Generated
    public SearchCriteriaHistoryInternalService getSearchCriteriaHistoryInternalService() {
        return this.searchCriteriaHistoryInternalService;
    }

    @Generated
    public void setSearchCriteriaHistoryInternalService(SearchCriteriaHistoryInternalService searchCriteriaHistoryInternalService) {
        this.searchCriteriaHistoryInternalService = searchCriteriaHistoryInternalService;
    }
}

