/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.server.rest;

import fr.gouv.vitamui.collect.common.dto.OperationIdDto;
import fr.gouv.vitamui.collect.common.dto.UpdateArchiveUnitDto;
import fr.gouv.vitamui.collect.common.service.ArchiveUnitService;
import fr.gouv.vitamui.commons.api.dtos.JsonPatch;
import fr.gouv.vitamui.commons.api.dtos.JsonPatchDto;
import fr.gouv.vitamui.commons.api.dtos.MultiJsonPatchDto;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/archive-units/{transactionId}"})
public class ArchiveUnitController {
    final ArchiveUnitService archiveUnitService;

    public ArchiveUnitController(ArchiveUnitService archiveUnitService) {
        this.archiveUnitService = archiveUnitService;
    }

    @PatchMapping
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates several archive units asynchronously by passing partial changes to apply to an archive unit")
    public ResponseEntity<OperationIdDto> update(@PathVariable(value="transactionId") String transactionId, @RequestBody @Validated Set<UpdateArchiveUnitDto> updateArchiveUnitDtoSet) {
        return ResponseEntity.ok((Object)this.archiveUnitService.update(transactionId, updateArchiveUnitDtoSet));
    }

    @PatchMapping(value={"/{archiveUnitId}"})
    @Consumes(value={"application/json-patch+json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates one archive unit asynchronously by passing a list of operation to do on an archive unit")
    public ResponseEntity<OperationIdDto> update(@PathVariable(value="transactionId") String transactionId, @RequestBody @Validated JsonPatch jsonPatch, @RequestParam String archiveUnitId) {
        JsonPatchDto jsonPatchDto = new JsonPatchDto().setId(archiveUnitId).setJsonPatch(jsonPatch);
        return this.update(transactionId, jsonPatchDto);
    }

    @PatchMapping(value={"/update/single"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates one archive unit asynchronously by passing a list of operation to do on this one")
    public ResponseEntity<OperationIdDto> update(@PathVariable(value="transactionId") String transactionId, @RequestBody @Validated JsonPatchDto jsonPatchDto) {
        return ResponseEntity.ok((Object)this.archiveUnitService.update(transactionId, jsonPatchDto));
    }

    @PatchMapping(value={"/update/multiple"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates several archive units asynchronously by passing a list of operation to do on these ones")
    public ResponseEntity<OperationIdDto> update(@PathVariable(value="transactionId") String transactionId, @RequestBody @Validated MultiJsonPatchDto multiJsonPatchDto) {
        return ResponseEntity.ok((Object)this.archiveUnitService.update(transactionId, multiJsonPatchDto));
    }
}

