/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.server.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.collect.internal.server.exception.VitamErrorDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.dto.VitamUIError;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class ControllerExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ControllerExceptionHandler.class);
    private ObjectMapper objectMapper;

    @Autowired
    public ControllerExceptionHandler() {
    }

    @ExceptionHandler(value={VitamClientException.class})
    ResponseEntity<VitamUIError> handleVitamClientException(VitamClientException exception) {
        VitamErrorDto vitamErrorDto;
        LOGGER.warn("A VitamClientException not handled have been captured");
        if (exception.getMessage() == null) {
            String message = "A VitamClientException not handled by controllers does not have message";
            return ResponseEntity.internalServerError().body((Object)this.convertToVitamUIError(this.createDefaultErrorMessage("A VitamClientException not handled by controllers does not have message")));
        }
        if (exception.getMessage().equals("")) {
            String message = "A VitamClientException not handled by controllers have empty message";
            return ResponseEntity.internalServerError().body((Object)this.convertToVitamUIError(this.createDefaultErrorMessage("A VitamClientException not handled by controllers have empty message")));
        }
        try {
            vitamErrorDto = (VitamErrorDto)this.objectMapper.readValue(exception.getMessage(), VitamErrorDto.class);
        }
        catch (IOException e) {
            String message = "Fail to read error message from VitamClientException";
            e.printStackTrace();
            return ResponseEntity.internalServerError().body((Object)this.convertToVitamUIError(this.createDefaultErrorMessage("Fail to read error message from VitamClientException")));
        }
        if (vitamErrorDto == null) {
            String message = "The message read from VitamClientException is null";
            return ResponseEntity.internalServerError().body((Object)this.convertToVitamUIError(this.createDefaultErrorMessage("The message read from VitamClientException is null")));
        }
        VitamUIError error = this.convertToVitamUIError(vitamErrorDto);
        VitamUIError refinedError = this.refine(error);
        LOGGER.debug("Refined error: {}", (Object)refinedError);
        return ResponseEntity.status((HttpStatus)HttpStatus.valueOf((int)refinedError.getStatus())).body((Object)refinedError);
    }

    private VitamErrorDto createDefaultErrorMessage(String message) {
        VitamErrorDto vitamErrorDto = new VitamErrorDto();
        vitamErrorDto.setHttpCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
        vitamErrorDto.setMessage(message);
        return vitamErrorDto;
    }

    private VitamUIError convertToVitamUIError(VitamErrorDto vitamErrorDto) {
        VitamUIError vitamUIError = new VitamUIError();
        vitamUIError.setStatus(Integer.valueOf(vitamErrorDto.getHttpCode()));
        vitamUIError.setMessage(vitamErrorDto.getMessage());
        vitamUIError.setTimestamp(LocalDateUtil.now().toString());
        vitamUIError.setException(vitamErrorDto.toString());
        vitamUIError.setError(vitamErrorDto.toString());
        vitamUIError.setArgs(null);
        return vitamUIError;
    }

    private VitamUIError refine(VitamUIError error) {
        if (this.isAboutTrackTotalHits(error)) {
            error.setStatus(Integer.valueOf(HttpStatus.EXPECTATION_FAILED.value()));
            return error;
        }
        return error;
    }

    private boolean isAboutTrackTotalHits(VitamUIError vitamUIError) {
        String expectation = "track_total_hits is not authorized";
        return vitamUIError.getError() != null && vitamUIError.getError().contains("track_total_hits is not authorized");
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

