/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.client;

import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseCrudRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import java.util.List;
import java.util.Optional;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class SubrogationExternalRestClient
extends BaseCrudRestClient<SubrogationDto, ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(SubrogationExternalRestClient.class);

    public SubrogationExternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public SubrogationDto accept(ExternalHttpContext context, String id) {
        LOGGER.debug("accept subrogation id={}", (Object)id);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)this.getUrl());
        uriBuilder.path("/surrogate/accept");
        uriBuilder.path("/{id}");
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.PATCH, request, this.getDtoClass());
        this.checkResponse(response, new Integer[0]);
        return (SubrogationDto)response.getBody();
    }

    public void decline(ExternalHttpContext context, String id) {
        LOGGER.debug("decline subrogation id={}", (Object)id);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)this.getUrl());
        uriBuilder.path("/surrogate/decline");
        uriBuilder.path("/{id}");
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.DELETE, request, Void.class);
    }

    public SubrogationDto getMySubrogationAsSurrogate(ExternalHttpContext context) {
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)this.getUrl());
        uriBuilder.path("/me/surrogate");
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, this.getDtoClass(), new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (SubrogationDto)response.getBody();
    }

    public SubrogationDto getMySubrogationAsSuperuser(ExternalHttpContext context) {
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        URIBuilder uriBuilder = this.getUriBuilderFromPath("/me/superuser");
        ResponseEntity response = this.restTemplate.exchange(this.buildUriBuilder(uriBuilder), HttpMethod.GET, request, this.getDtoClass());
        this.checkResponse(response, new Integer[0]);
        return (SubrogationDto)response.getBody();
    }

    public PaginatedValuesDto<UserDto> getGenericUsers(ExternalHttpContext context, Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        LOGGER.debug("search page={}, size={}, criteria={}, orderBy={}, direction={}", new Object[]{page, size, criteria, orderBy, direction});
        URIBuilder builder = this.getUriBuilderFromPath("/users/generic");
        builder.addParameter("page", page.toString());
        builder.addParameter("size", size.toString());
        criteria.ifPresent(o -> builder.addParameter("criteria", o));
        orderBy.ifPresent(o -> builder.addParameter("orderBy", o));
        direction.ifPresent(o -> builder.addParameter("direction", o.toString()));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.buildUriBuilder(builder), HttpMethod.GET, request, this.getUserDtoPaginatedClass());
        this.checkResponse(response, new Integer[0]);
        return (PaginatedValuesDto)response.getBody();
    }

    public GroupDto getGroupById(ExternalHttpContext context, String id) {
        LOGGER.debug("Get {}", (Object)id);
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        URIBuilder builder = this.getUriBuilderFromPath("/groups/" + id + "/");
        ResponseEntity response = this.restTemplate.exchange(this.buildUriBuilder(builder), HttpMethod.GET, request, GroupDto.class);
        this.checkResponse(response, new Integer[0]);
        return (GroupDto)response.getBody();
    }

    public String getPathUrl() {
        return "/iam/v1/subrogations";
    }

    protected Class<SubrogationDto> getDtoClass() {
        return SubrogationDto.class;
    }

    protected ParameterizedTypeReference<List<SubrogationDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<SubrogationDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<UserDto>> getUserDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<UserDto>>(){};
    }
}

