/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.client;

import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import java.util.List;
import java.util.Optional;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class GroupExternalRestClient
extends BasePaginatingAndSortingRestClient<GroupDto, ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(BasePaginatingAndSortingRestClient.class);

    public GroupExternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public String getPathUrl() {
        return "/iam/v1/groups";
    }

    protected Class<GroupDto> getDtoClass() {
        return GroupDto.class;
    }

    protected ParameterizedTypeReference<List<GroupDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<GroupDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<GroupDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<GroupDto>>(){};
    }

    private ParameterizedTypeReference<List<String>> getStringListClass() {
        return new ParameterizedTypeReference<List<String>>(){};
    }

    public List<GroupDto> getAll(ExternalHttpContext context, Optional<String> embedded) {
        LOGGER.debug("Get ALL embedded = {}", embedded);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)this.getUrl());
        if (embedded.isPresent()) {
            uriBuilder.queryParam("embedded", new Object[]{embedded.get()});
        }
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, this.getDtoListClass(), new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (List)response.getBody();
    }

    public List<String> getLevels(ExternalHttpContext context, Optional<String> criteria) {
        LOGGER.debug("GetLevels criteria={}", criteria);
        URIBuilder builder = this.getUriBuilderFromPath("/levels");
        criteria.ifPresent(o -> builder.addParameter("criteria", o));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.buildUriBuilder(builder), HttpMethod.GET, request, this.getStringListClass());
        this.checkResponse(response, new Integer[0]);
        return (List)response.getBody();
    }
}

