/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.client;

import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.common.dto.cas.LoginRequestDto;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class CasExternalRestClient
extends BaseRestClient<ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(CasExternalRestClient.class);

    public CasExternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public UserDto login(ExternalHttpContext context, String username, String loginCustomerId, String password, String surrogateEmail, String surrogateCustomerId, String ip) {
        LoginRequestDto loginRequest = new LoginRequestDto();
        loginRequest.setLoginEmail(username);
        loginRequest.setLoginCustomerId(loginCustomerId);
        loginRequest.setPassword(password);
        loginRequest.setSurrogateEmail(surrogateEmail);
        loginRequest.setSurrogateCustomerId(surrogateCustomerId);
        loginRequest.setIp(ip);
        LOGGER.debug("loginRequest: {}", (Object)loginRequest);
        HttpEntity request = new HttpEntity((Object)loginRequest, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/login", HttpMethod.POST, request, UserDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (UserDto)response.getBody();
    }

    public void changePassword(ExternalHttpContext context, String username, String customerId, String password) {
        LOGGER.debug("changePassword for username: {}", (Object)username);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        headers.put((Object)"username", Collections.singletonList(username));
        headers.put((Object)"password", Collections.singletonList(password));
        headers.put((Object)"customerId", Collections.singletonList(customerId));
        HttpEntity request = new HttpEntity(headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/password/change", HttpMethod.POST, request, Boolean.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
    }

    public UserDto getUserByEmailAndCustomerId(ExternalHttpContext context, String email, String customerId, Optional<String> embedded) {
        List<UserDto> users = this.getUsersByEmail(context, email, embedded);
        return users.stream().filter(user -> user.getCustomerId().equals(customerId)).findFirst().orElse(null);
    }

    public List<UserDto> getUsersByEmail(ExternalHttpContext context, String email, Optional<String> embedded) {
        LOGGER.debug("getUserByEmail: {} embedded: {}", (Object)email, embedded);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/users"));
        uriBuilder.queryParam("email", new Object[]{email});
        embedded.ifPresent(s -> uriBuilder.queryParam("embedded", new Object[]{s}));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<List<AuthUserDto>>(){}, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        List authUsersDto = (List)response.getBody();
        return authUsersDto.stream().map(user -> user.getProfileGroup() != null ? user : user.newBasicUserDto()).collect(Collectors.toList());
    }

    public UserDto getUser(ExternalHttpContext context, String loginEmail, String loginCustomerId, String idp, Optional<String> userIdentifier, Optional<String> embedded) {
        LOGGER.debug("getUser - email : {}, customerId : {}, idp : {}, userIdentifier : {}, embedded options : {}", new Object[]{loginEmail, loginCustomerId, idp, userIdentifier, embedded});
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/users/provisioning"));
        uriBuilder.queryParam("loginEmail", new Object[]{loginEmail});
        uriBuilder.queryParam("loginCustomerId", new Object[]{loginCustomerId});
        uriBuilder.queryParam("idp", new Object[]{idp});
        userIdentifier.ifPresent(s -> uriBuilder.queryParam("userIdentifier", new Object[]{s}));
        embedded.ifPresent(s -> uriBuilder.queryParam("embedded", new Object[]{s}));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, AuthUserDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        AuthUserDto authUserDto = (AuthUserDto)response.getBody();
        if (authUserDto.getProfileGroup() != null) {
            return authUserDto;
        }
        return authUserDto.newBasicUserDto();
    }

    public UserDto getUserById(ExternalHttpContext context, String id) {
        LOGGER.debug("getUserById: {}", (Object)id);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/users"));
        uriBuilder.queryParam("id", new Object[]{id});
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, UserDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (UserDto)response.getBody();
    }

    public List<SubrogationDto> getSubrogationsBySuperUserEmailAndCustomerId(ExternalHttpContext context, String superUserEmail, String superUserCustomerId) {
        LOGGER.debug("getMySubrogationAsSuperuser {} / {}", (Object)superUserEmail, (Object)superUserCustomerId);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/subrogations"));
        uriBuilder.queryParam("superUserEmail", new Object[]{superUserEmail});
        uriBuilder.queryParam("superUserCustomerId", new Object[]{superUserCustomerId});
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, this.getSubrogationDtoListClass(), new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (List)response.getBody();
    }

    public List<SubrogationDto> getSubrogationsBySuperUserId(ExternalHttpContext context, String superUserId) {
        LOGGER.debug("getSubrogationsBySuperUserId {}", (Object)superUserId);
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/subrogations"));
        uriBuilder.queryParam("superUserId", new Object[]{superUserId});
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, this.getSubrogationDtoListClass(), new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (List)response.getBody();
    }

    public List<CustomerDto> getCustomersByIds(ExternalHttpContext context, List<String> customerIds) {
        LOGGER.debug("getCustomersByIds: {}", customerIds);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/customers"));
        uriBuilder.queryParam("customerIds", customerIds);
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<List<CustomerDto>>(){}, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (List)response.getBody();
    }

    public void logout(ExternalHttpContext context, String authToken, String superUser, String superUserCustomerId) {
        LOGGER.debug("logout for authToken={} and superUser={}", (Object)authToken, (Object)superUser);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        URIBuilder uriBuilder = this.getUriBuilderFromPath("/logout");
        uriBuilder.addParameter("authToken", authToken);
        uriBuilder.addParameter("superUser", superUser);
        uriBuilder.addParameter("superUserCustomerId", superUserCustomerId);
        URI uri = this.buildUriBuilder(uriBuilder);
        LOGGER.debug("uri {}", (Object)uri.toString());
        HttpEntity request = new HttpEntity(headers);
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, request, Void.class);
        this.checkResponse(response, new Integer[0]);
    }

    protected ParameterizedTypeReference<List<SubrogationDto>> getSubrogationDtoListClass() {
        return new ParameterizedTypeReference<List<SubrogationDto>>(){};
    }

    public String getPathUrl() {
        return "/iam/v1/cas";
    }
}

