/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.archive.internal.client;

import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationDto;
import java.io.InputStream;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ArchiveSearchStreamingInternalRestClient
extends BasePaginatingAndSortingRestClient<LogbookOperationDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchiveSearchStreamingInternalRestClient.class);

    public ArchiveSearchStreamingInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public String getPathUrl() {
        return "/archives-search";
    }

    protected Class<LogbookOperationDto> getDtoClass() {
        return LogbookOperationDto.class;
    }

    protected ParameterizedTypeReference<List<LogbookOperationDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<LogbookOperationDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<LogbookOperationDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<LogbookOperationDto>>(){};
    }

    public ResponseEntity<Resource> downloadObjectFromUnit(String id, String usage, Integer version, InternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/downloadobjectfromunit/{id}?usage=" + usage + "&version=" + version));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, Resource.class);
        ResponseEntity result = ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)((Resource)response.getBody()));
        return result;
    }

    public String transferAcknowledgment(InternalHttpContext context, String originalFileName, InputStream inputStream) {
        LOGGER.debug("Calling upload atr file using streaming process");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/transfer-acknowledgment"));
        HttpHeaders headersList = new HttpHeaders();
        headersList.addAll(this.buildHeaders((AbstractHttpContext)context));
        headersList.add((Object)"X-Original-Filename", (Object)originalFileName);
        HttpHeaders headersParams = new HttpHeaders();
        headersParams.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headersParams.addAll((MultiValueMap)headersList);
        HttpEntity request = new HttpEntity((Object)new InputStreamResource(inputStream), (MultiValueMap)headersParams);
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.POST, request, String.class, new Object[0]);
        LOGGER.debug("The transfer acknowledgment operation id : {} ", (Object)response.toString());
        return (String)response.getBody();
    }
}

