/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.user.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.UserInfoDto;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.logbook.dto.EventDiffDto;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.mongo.service.VitamUICrudService;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.iam.internal.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.internal.server.user.converter.UserInfoConverter;
import fr.gouv.vitamui.iam.internal.server.user.dao.UserInfoRepository;
import fr.gouv.vitamui.iam.internal.server.user.domain.UserInfo;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class UserInfoInternalService
extends VitamUICrudService<UserInfoDto, UserInfo> {
    private UserInfoRepository userInfoRepository;
    private InternalSecurityService internalSecurityService;
    private final UserInfoConverter userInfoConverter;
    private final IamLogbookService iamLogbookService;
    private LogbookService logbookService;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UserInfoInternalService.class);

    @Autowired
    public UserInfoInternalService(SequenceGeneratorService sequenceGeneratorService, UserInfoRepository userInfoRepository, InternalSecurityService internalSecurityService, UserInfoConverter userInfoConverter, IamLogbookService iamLogbookService, LogbookService logbookService) {
        super(sequenceGeneratorService);
        this.userInfoRepository = userInfoRepository;
        this.internalSecurityService = internalSecurityService;
        this.userInfoConverter = userInfoConverter;
        this.iamLogbookService = iamLogbookService;
        this.logbookService = logbookService;
    }

    public UserInfoDto getMe() {
        AuthUserDto user = this.internalSecurityService.getUser();
        String userInfoId = user.getUserInfoId();
        if (StringUtils.isBlank((CharSequence)userInfoId)) {
            throw new ApplicationServerException("user must have user information id ", user.getId());
        }
        Optional userInfoOptional = this.userInfoRepository.findById((Object)userInfoId);
        UserInfo userInfo = (UserInfo)userInfoOptional.orElseThrow(() -> new ApplicationServerException("user info not found ", userInfoId));
        return this.userInfoConverter.convertEntityToDto(userInfo);
    }

    @Transactional
    public UserInfoDto patch(Map<String, Object> partialDto) {
        LOGGER.info("Patch {} with {}", (Object)this.getObjectName(), partialDto);
        return (UserInfoDto)super.patch(partialDto);
    }

    protected void processPatch(UserInfo userInfo, Map<String, Object> partialDto) {
        ArrayList<EventDiffDto> logbooks = new ArrayList<EventDiffDto>();
        block8: for (Map.Entry<String, Object> entry : partialDto.entrySet()) {
            switch (entry.getKey()) {
                case "id": {
                    continue block8;
                }
                case "language": {
                    logbooks.add(new EventDiffDto("Langue", (Object)userInfo.getLanguage(), entry.getValue()));
                    userInfo.setLanguage(CastUtils.toString((Object)entry.getValue()));
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unable to patch group " + userInfo.getId() + ": key " + entry.getKey() + " is not allowed");
        }
        this.iamLogbookService.updateUserInfoEvent(userInfo, logbooks);
    }

    @Transactional
    public UserInfoDto create(UserInfoDto userInfoDto) {
        UserInfoDto createdUserInfoDto = (UserInfoDto)super.create((IdDto)userInfoDto);
        this.iamLogbookService.createUserInfoEvent(createdUserInfoDto);
        return createdUserInfoDto;
    }

    protected Class<UserInfo> getEntityClass() {
        return UserInfo.class;
    }

    protected UserInfoRepository getRepository() {
        return this.userInfoRepository;
    }

    protected Converter<UserInfoDto, UserInfo> getConverter() {
        return this.userInfoConverter;
    }

    public JsonNode findHistoryById(String id) throws VitamClientException {
        LOGGER.debug("findHistoryById for id " + id);
        Integer tenantIdentifier = this.internalSecurityService.getTenantIdentifier();
        VitamContext vitamContext = new VitamContext(tenantIdentifier).setAccessContract(this.internalSecurityService.getTenant(tenantIdentifier).getAccessContractLogbookIdentifier()).setApplicationSessionId(this.internalSecurityService.getApplicationId());
        Optional userInfo = this.getRepository().findById((Object)id);
        userInfo.orElseThrow(() -> new NotFoundException(String.format("No user information found with id : %s", id)));
        return this.logbookService.findEventsByIdentifierAndCollectionNames(((UserInfo)userInfo.get()).getIdentifier(), "userInfos", vitamContext).toJsonNode();
    }

    protected void beforeCreate(UserInfoDto dto) {
        String message = "Unable to create user info " + dto.getId();
        super.checkIdentifier(dto.getIdentifier(), message);
        dto.setIdentifier(this.getNextSequenceId("userInfosIdentifier"));
    }

    private UserInfo find(String id, String message) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)(message + ": no id"));
        return (UserInfo)this.getRepository().findById((Object)id).orElseThrow(() -> new IllegalArgumentException(message + ": no user info found for id " + id));
    }

    @Generated
    public UserInfoRepository getUserInfoRepository() {
        return this.userInfoRepository;
    }

    @Generated
    public InternalSecurityService getInternalSecurityService() {
        return this.internalSecurityService;
    }

    @Generated
    public UserInfoConverter getUserInfoConverter() {
        return this.userInfoConverter;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }

    @Generated
    public LogbookService getLogbookService() {
        return this.logbookService;
    }

    @Generated
    public void setUserInfoRepository(UserInfoRepository userInfoRepository) {
        this.userInfoRepository = userInfoRepository;
    }

    @Generated
    public void setInternalSecurityService(InternalSecurityService internalSecurityService) {
        this.internalSecurityService = internalSecurityService;
    }

    @Generated
    public void setLogbookService(LogbookService logbookService) {
        this.logbookService = logbookService;
    }
}

