/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.user.service;

import fr.gouv.vitamui.commons.api.domain.LanguageDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.domain.UserInfoDto;
import fr.gouv.vitamui.commons.api.enums.UserStatusEnum;
import fr.gouv.vitamui.commons.api.enums.UserTypeEnum;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.RestClientFactory;
import fr.gouv.vitamui.iam.common.utils.IdentityProviderHelper;
import fr.gouv.vitamui.iam.internal.server.idp.service.IdentityProviderInternalService;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInfoInternalService;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class UserEmailInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UserEmailInternalService.class);
    @Value(value="${cas.reset.password.url}")
    @NotNull
    private String casResetPasswordUrl;
    @Autowired
    private IdentityProviderHelper identityProviderHelper;
    @Autowired
    private UserInfoInternalService userInfoInternalService;
    @Autowired
    private IdentityProviderInternalService internalIdentityProviderService;
    private final RestClientFactory restClientFactory;

    public UserEmailInternalService(RestClientFactory restClientFactory) {
        this.restClientFactory = restClientFactory;
    }

    public void sendCreationEmail(UserDto userDto) {
        List providers;
        if (userDto != null && userDto.getStatus() == UserStatusEnum.ENABLED && userDto.getType() == UserTypeEnum.NOMINATIVE && this.identityProviderHelper.identifierMatchProviderPattern(providers = this.internalIdentityProviderService.getAll(Optional.empty(), Optional.empty()), userDto.getEmail(), userDto.getCustomerId())) {
            LOGGER.debug("Sending mail after creating  user: {}", (Object)userDto.getEmail());
            UserInfoDto userInfoDto = (UserInfoDto)this.userInfoInternalService.getOne(userDto.getUserInfoId());
            this.restClientFactory.getRestTemplate().getForEntity(this.restClientFactory.getBaseUrl() + this.casResetPasswordUrl, Boolean.class, new Object[]{userDto.getEmail(), userDto.getFirstname(), userDto.getLastname(), LanguageDto.valueOf((String)userInfoDto.getLanguage()).getLanguage(), userDto.getCustomerId()});
        }
    }

    @Generated
    public String getCasResetPasswordUrl() {
        return this.casResetPasswordUrl;
    }

    @Generated
    public IdentityProviderHelper getIdentityProviderHelper() {
        return this.identityProviderHelper;
    }

    @Generated
    public UserInfoInternalService getUserInfoInternalService() {
        return this.userInfoInternalService;
    }

    @Generated
    public IdentityProviderInternalService getInternalIdentityProviderService() {
        return this.internalIdentityProviderService;
    }

    @Generated
    public RestClientFactory getRestClientFactory() {
        return this.restClientFactory;
    }

    @Generated
    public void setIdentityProviderHelper(IdentityProviderHelper identityProviderHelper) {
        this.identityProviderHelper = identityProviderHelper;
    }

    @Generated
    public void setUserInfoInternalService(UserInfoInternalService userInfoInternalService) {
        this.userInfoInternalService = userInfoInternalService;
    }

    @Generated
    public void setInternalIdentityProviderService(IdentityProviderInternalService internalIdentityProviderService) {
        this.internalIdentityProviderService = internalIdentityProviderService;
    }

    @Generated
    public void setCasResetPasswordUrl(String casResetPasswordUrl) {
        this.casResetPasswordUrl = casResetPasswordUrl;
    }
}

