/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.tenant.converter;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.logbook.util.LogbookUtils;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.internal.server.owner.dao.OwnerRepository;
import fr.gouv.vitamui.iam.internal.server.tenant.domain.Tenant;
import java.util.LinkedHashMap;
import java.util.Optional;

public class TenantConverter
implements Converter<TenantDto, Tenant> {
    public static final String NAME_KEY = "Nom";
    public static final String PROOF_KEY = "\u00c9l\u00e9ments de preuve";
    public static final String ENABLED_KEY = "Activ\u00e9";
    public static final String OWNER_ID_KEY = "Identifiant du propri\u00e9taire";
    public static final String INGEST_CONTRACT_HOLDING_IDENTIFIER_KEY = "Identifiant du contrat d'entr\u00e9e pour l'arbre";
    public static final String ITEM_INGEST_CONTRACT_IDENTIFIER_KEY = "Identifiant du contrat d'entr\u00e9e pour les bordereaux";
    public static final String ACCESS_CONTRACT_HOLDING_IDENTIFIER_KEY = "Identifiant du contrat d'acc\u00e8s pour l'arbre";
    public static final String ACCESS_CONTRACT_LOGBOOK_IDENTIFIER_KEY = "Identifiant du contrat d'acc\u00e8s pour le logbook";
    private final OwnerRepository ownerRepository;

    public TenantConverter(OwnerRepository ownerRepository) {
        this.ownerRepository = ownerRepository;
    }

    public String convertToLogbook(TenantDto tenant) {
        LinkedHashMap<String, String> logbookData = new LinkedHashMap<String, String>();
        logbookData.put(NAME_KEY, LogbookUtils.getValue((Object)tenant.getName()));
        logbookData.put(PROOF_KEY, LogbookUtils.getValue((Object)tenant.isProof()));
        logbookData.put(ENABLED_KEY, LogbookUtils.getValue((Object)tenant.getEnabled()));
        Optional owner = this.ownerRepository.findById((Object)tenant.getOwnerId());
        owner.ifPresent(o -> logbookData.put(OWNER_ID_KEY, o.getIdentifier()));
        logbookData.put(ACCESS_CONTRACT_HOLDING_IDENTIFIER_KEY, LogbookUtils.getValue((Object)tenant.getAccessContractHoldingIdentifier()));
        logbookData.put(ACCESS_CONTRACT_LOGBOOK_IDENTIFIER_KEY, LogbookUtils.getValue((Object)tenant.getAccessContractLogbookIdentifier()));
        logbookData.put(INGEST_CONTRACT_HOLDING_IDENTIFIER_KEY, LogbookUtils.getValue((Object)tenant.getIngestContractHoldingIdentifier()));
        logbookData.put(ITEM_INGEST_CONTRACT_IDENTIFIER_KEY, LogbookUtils.getValue((Object)tenant.getItemIngestContractIdentifier()));
        return ApiUtils.toJson(logbookData);
    }

    public Tenant convertDtoToEntity(TenantDto dto) {
        return (Tenant)VitamUIUtils.copyProperties((Object)dto, (Object)new Tenant());
    }

    public TenantDto convertEntityToDto(Tenant tenant) {
        return (TenantDto)VitamUIUtils.copyProperties((Object)tenant, (Object)new TenantDto());
    }
}

