/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.security;

import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.internal.server.subrogation.dao.SubrogationRepository;
import fr.gouv.vitamui.iam.internal.server.subrogation.domain.Subrogation;
import fr.gouv.vitamui.iam.internal.server.token.dao.TokenRepository;
import fr.gouv.vitamui.iam.internal.server.token.domain.Token;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInternalService;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;

public class IamAuthentificationService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IamAuthentificationService.class);
    public static final String INTERNAL_CAS_USER_NAME = "casuser";
    private final TokenRepository tokenRepository;
    private final UserInternalService internalUserService;
    private final SubrogationRepository subrogationRepository;
    @Value(value="${token.max-ttl:480}")
    @NotNull
    private Integer tokenMaxTtl;
    @Value(value="${token.additional.ttl}")
    @NotNull
    private Integer tokenAdditionalTtl;
    @Value(value="${cas.secret.token}")
    @NotNull
    private String casSecretToken;

    public IamAuthentificationService(UserInternalService internalUserService, TokenRepository tokenRepository, SubrogationRepository subrogationRepository) {
        this.internalUserService = internalUserService;
        this.tokenRepository = tokenRepository;
        this.subrogationRepository = subrogationRepository;
    }

    public AuthUserDto getUserFromHttpContext(InternalHttpContext httpContext) {
        String userToken = httpContext.getUserToken();
        if (userToken == null) {
            throw new BadCredentialsException("Usertoken not found in header");
        }
        return this.getUserByToken(userToken);
    }

    private Token getToken(String userToken) {
        if (this.casSecretToken.equals(userToken)) {
            LOGGER.debug("Granted access to CAS token");
            Token token = new Token();
            token.setRefId(INTERNAL_CAS_USER_NAME);
            return token;
        }
        LOGGER.debug("Checking access for user token: '{}'", (Object)userToken);
        Token token = (Token)this.tokenRepository.findById((Object)userToken).orElseThrow(() -> new BadCredentialsException("No user found for usertoken: " + userToken));
        LOGGER.debug("Found valid token: {}", (Object)token);
        if (!token.isSurrogation()) {
            Date tokenMaxExpirationDate = DateUtils.addMinutes((Date)token.getCreatedDate(), (int)this.tokenMaxTtl);
            Date currentTokenExpirationDate = token.getUpdatedDate();
            Date newTokenExpirationDate = DateUtils.addMinutes((Date)new Date(), (int)this.tokenAdditionalTtl);
            if (currentTokenExpirationDate.before(new Date())) {
                throw new BadCredentialsException("Expired token  usertoken: " + userToken);
            }
            if (currentTokenExpirationDate.before(newTokenExpirationDate) && newTokenExpirationDate.before(tokenMaxExpirationDate)) {
                token.setUpdatedDate(newTokenExpirationDate);
                this.tokenRepository.save((Object)token);
            }
        }
        return token;
    }

    private AuthUserDto getUserByToken(String userToken) {
        Token token = this.getToken(userToken);
        UserDto userDto = this.internalUserService.findUserById(token.getRefId());
        AuthUserDto authUserDto = this.internalUserService.loadGroupAndProfiles(userDto);
        if (token.isSurrogation()) {
            String surrogateEmail = userDto.getEmail();
            Subrogation subrogation = this.subrogationRepository.findOneBySurrogateAndSurrogateCustomerId(surrogateEmail, userDto.getCustomerId());
            String superUserEmail = subrogation.getSuperUser();
            authUserDto.setSuperUser(superUserEmail);
            authUserDto.setSuperUserCustomerId(subrogation.getSuperUserCustomerId());
            UserDto superUserDto = this.internalUserService.findUserByEmailAndCustomerId(superUserEmail, subrogation.getSuperUserCustomerId());
            authUserDto.setSuperUserIdentifier(superUserDto.getIdentifier());
        }
        this.internalUserService.addBasicCustomerAndProofTenantIdentifierInformation(authUserDto);
        this.internalUserService.addTenantsByAppInformation(authUserDto);
        authUserDto.setAuthToken(userToken);
        return authUserDto;
    }

    @Generated
    public TokenRepository getTokenRepository() {
        return this.tokenRepository;
    }

    @Generated
    public UserInternalService getInternalUserService() {
        return this.internalUserService;
    }

    @Generated
    public SubrogationRepository getSubrogationRepository() {
        return this.subrogationRepository;
    }

    @Generated
    public Integer getTokenMaxTtl() {
        return this.tokenMaxTtl;
    }

    @Generated
    public Integer getTokenAdditionalTtl() {
        return this.tokenAdditionalTtl;
    }

    @Generated
    public String getCasSecretToken() {
        return this.casSecretToken;
    }

    @Generated
    public void setTokenMaxTtl(Integer tokenMaxTtl) {
        this.tokenMaxTtl = tokenMaxTtl;
    }

    @Generated
    public void setTokenAdditionalTtl(Integer tokenAdditionalTtl) {
        this.tokenAdditionalTtl = tokenAdditionalTtl;
    }

    @Generated
    public void setCasSecretToken(String casSecretToken) {
        this.casSecretToken = casSecretToken;
    }
}

