/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.security;

import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.internal.server.security.IamAuthentificationService;
import fr.gouv.vitamui.iam.security.authentication.InternalAuthentication;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class IamApiAuthenticationProvider
implements AuthenticationProvider {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IamApiAuthenticationProvider.class);
    private final IamAuthentificationService iamAuthentificationService;

    public IamApiAuthenticationProvider(IamAuthentificationService iamAuthentificationService) {
        this.iamAuthentificationService = iamAuthentificationService;
    }

    public Authentication authenticate(Authentication authentication) {
        if (this.supports(authentication.getClass())) {
            PreAuthenticatedAuthenticationToken token = (PreAuthenticatedAuthenticationToken)authentication;
            InternalHttpContext httpContext = (InternalHttpContext)token.getPrincipal();
            LOGGER.debug("HttpContext: {}", (Object)httpContext);
            if (httpContext != null) {
                AuthUserDto userProfile = this.iamAuthentificationService.getUserFromHttpContext(httpContext);
                return new InternalAuthentication(userProfile, httpContext);
            }
        }
        throw new BadCredentialsException("Unable to authenticate REST call");
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(PreAuthenticatedAuthenticationToken.class);
    }
}

