/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.internal.server.user.service.ConnectionHistoryService;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInternalService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/users"})
@Api(tags={"users"}, value="Users Management", description="Users Management")
public class UserInternalController
implements CrudController<UserDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UserInternalController.class);
    private final UserInternalService internalUserService;
    private final ConnectionHistoryService connectionHistoryService;

    @GetMapping(value={"/export"})
    public ResponseEntity<Resource> exportUsers(@RequestParam(required=false) Optional<String> criteria) {
        LOGGER.debug("Export all users to xlsx file");
        return ResponseEntity.ok().contentType(MediaType.valueOf((String)"application/octet-stream")).body((Object)this.internalUserService.exportUsers(criteria));
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<? extends UserDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        SanityChecker.checkSecureParameter((String[])new String[]{String.valueOf(size), String.valueOf(page)});
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.internalUserService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @GetMapping(value={"/{id}"})
    public UserDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get {} criteria={}", (Object)id, criteria);
        return (UserDto)this.internalUserService.getOne(id, criteria);
    }

    @GetMapping(value={"/me"})
    public AuthUserDto getMe() {
        LOGGER.debug("getMe {}");
        return this.internalUserService.getMe();
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("check exist criteria={}", (Object)criteria);
        boolean exist = this.internalUserService.checkExist(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PostMapping
    public UserDto create(@Valid @RequestBody UserDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create {}", (Object)dto);
        return this.internalUserService.create(dto);
    }

    @PutMapping(value={"/{id}"})
    public UserDto update(@PathVariable(value="id") String id, @Valid @RequestBody UserDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        return this.internalUserService.update(dto);
    }

    @PatchMapping(value={"/{id}"})
    public UserDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.internalUserService.patch(partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for users with id :{}", (Object)id);
        return this.internalUserService.findHistoryById(id);
    }

    @GetMapping(value={"/levels"})
    public List<String> getLevels(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get levels with criteria={}", criteria);
        return this.internalUserService.getLevels(criteria);
    }

    @PostMapping(value={"/analytics"})
    public UserDto patchAnalytics(@RequestBody Map<String, Object> partialDto) {
        LOGGER.debug("Patch analytics with {}", partialDto);
        return this.internalUserService.patchAnalytics(partialDto);
    }

    @GetMapping(value={"/connection-history/export"})
    public ResponseEntity<Resource> exportUserConnectionHistory(Optional<String> criteria) {
        LOGGER.debug("Export all user history connection to xlsx file");
        return ResponseEntity.ok().contentType(MediaType.valueOf((String)"application/octet-stream")).body((Object)this.connectionHistoryService.exportConnectionHistory(criteria));
    }

    @Generated
    public UserInternalController(UserInternalService internalUserService, ConnectionHistoryService connectionHistoryService) {
        this.internalUserService = internalUserService;
        this.connectionHistoryService = connectionHistoryService;
    }

    @Generated
    public UserInternalService getInternalUserService() {
        return this.internalUserService;
    }

    @Generated
    public ConnectionHistoryService getConnectionHistoryService() {
        return this.connectionHistoryService;
    }
}

