/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.exception.NotImplementedException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.internal.server.subrogation.service.SubrogationInternalService;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInternalService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/subrogations"})
@Api(tags={"subrogations"}, value="Subrogation Management", description="Subrogation Management")
public class SubrogationInternalController
implements CrudController<SubrogationDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(SubrogationInternalController.class);
    @Autowired
    private SubrogationInternalService internalSubrogationService;
    @Autowired
    private UserInternalService internalUserService;

    @GetMapping
    public List<SubrogationDto> getAll(@RequestParam Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        return this.internalSubrogationService.getAll(criteria);
    }

    @RequestMapping(path={"/{id}"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@PathVariable(value="id") String id) {
        throw new NotImplementedException("checkExist not supported");
    }

    @GetMapping(value={"/{id}"})
    public SubrogationDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Get {} criteria={}", (Object)id, criteria);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.sanitizeCriteria(criteria);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return (SubrogationDto)this.internalSubrogationService.getOne(id, criteria);
    }

    @PostMapping
    public SubrogationDto create(@Valid @RequestBody SubrogationDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Create {}", (Object)dto);
        SanityChecker.sanitizeCriteria((Object)dto);
        return (SubrogationDto)this.internalSubrogationService.create((IdDto)dto);
    }

    @PutMapping(value={"/{id}"})
    public SubrogationDto update(@PathVariable(value="id") String id, @Valid @RequestBody SubrogationDto dto) {
        throw new NotImplementedException("Update not supported");
    }

    @PatchMapping(value={"/surrogate/accept/{id}"})
    public SubrogationDto accept(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Accepte subrogation id : {}", (Object)id);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return this.internalSubrogationService.accept(id);
    }

    @DeleteMapping(value={"/surrogate/decline/{id}"})
    public void decline(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Decline subrogation id : {}", (Object)id);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        this.internalSubrogationService.decline(id);
    }

    @GetMapping(value={"/me/surrogate"})
    public SubrogationDto getMySubrogationAsSurrogate() {
        return this.internalSubrogationService.getMySubrogationAsSurrogate();
    }

    @GetMapping(value={"/me/superuser"})
    public SubrogationDto getMySubrogationAsSuperuser() {
        return this.internalSubrogationService.getMySubrogationAsSuperuser();
    }

    @GetMapping(path={"/users"}, params={"page", "size"})
    public PaginatedValuesDto<UserDto> getUsers(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        SanityChecker.sanitizeCriteria(criteria);
        SanityChecker.checkSecureParameter((String[])new String[]{String.valueOf(page), String.valueOf(size)});
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        return this.internalSubrogationService.getUsers(page, size, criteria, orderBy, direction);
    }

    @GetMapping(path={"/groups/{id}"})
    public GroupDto getGroupById(@PathVariable(value="id") String id, @RequestParam Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Get group {}", (Object)id);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        return this.internalSubrogationService.getGroupById(id, embedded);
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        this.internalSubrogationService.delete(id);
    }

    @Generated
    public SubrogationInternalService getInternalSubrogationService() {
        return this.internalSubrogationService;
    }

    @Generated
    public UserInternalService getInternalUserService() {
        return this.internalUserService;
    }

    @Generated
    public void setInternalSubrogationService(SubrogationInternalService internalSubrogationService) {
        this.internalSubrogationService = internalSubrogationService;
    }

    @Generated
    public void setInternalUserService(UserInternalService internalUserService) {
        this.internalUserService = internalUserService;
    }
}

