/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.internal.server.group.service.GroupExportService;
import fr.gouv.vitamui.iam.internal.server.group.service.GroupInternalService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/groups"})
@Api(tags={"groups"}, value="Profiles Groups Management", description="Profiles Groups Management")
public class GroupInternalController
implements CrudController<GroupDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(GroupInternalController.class);
    private GroupInternalService internalGroupService;

    @Autowired
    public GroupInternalController(GroupInternalService internalGroupService) {
        this.internalGroupService = internalGroupService;
    }

    @GetMapping
    public List<GroupDto> getAll(Optional<String> criteria, @RequestParam Optional<String> embedded) {
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("get all criteria={}, embedded={}", criteria, embedded);
        return this.internalGroupService.getAll(criteria, embedded);
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<GroupDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction, @RequestParam(required=false) Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        SanityChecker.sanitizeCriteria(criteria);
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        SanityChecker.checkSecureParameter((String[])new String[]{String.valueOf(size), String.valueOf(page)});
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}, embedded = {}", new Object[]{page, size, orderBy, direction, embedded});
        return this.internalGroupService.getAllPaginated(page, size, criteria, orderBy, direction, embedded);
    }

    @GetMapping(value={"/{id}"})
    public GroupDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> criteria, @RequestParam Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.sanitizeCriteria(criteria);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get {} criteria={} embedded={}", new Object[]{id, criteria, embedded});
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        return this.internalGroupService.getOne(id, criteria, embedded);
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("check exist criteria={}", (Object)criteria);
        boolean exist = this.internalGroupService.checkExist(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PostMapping
    public GroupDto create(@Valid @RequestBody GroupDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create {}", (Object)dto);
        return this.internalGroupService.create(dto);
    }

    @PutMapping(value={"/{id}"})
    public GroupDto update(@PathVariable(value="id") String id, @Valid @RequestBody GroupDto dto) {
        throw new UnsupportedOperationException("update not implemented");
    }

    @PatchMapping(value={"/{id}"})
    public GroupDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.internalGroupService.patch(partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for group with id :{}", (Object)id);
        return this.internalGroupService.findHistoryById(id);
    }

    @GetMapping(value={"/levels"})
    public List<String> getLevels(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get levels with criteria={}", criteria);
        return this.internalGroupService.getLevels(criteria);
    }

    @GetMapping(value={"/export"})
    public ResponseEntity<Resource> exportProfileGroups(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Export all profile groups to xlsx file with criteria={}", criteria);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=" + GroupExportService.getFilename()})).contentType(MediaType.valueOf((String)"application/octet-stream")).body((Object)this.internalGroupService.exportProfileGroups(criteria));
    }

    @Generated
    public GroupInternalService getInternalGroupService() {
        return this.internalGroupService;
    }

    @Generated
    public void setInternalGroupService(GroupInternalService internalGroupService) {
        this.internalGroupService = internalGroupService;
    }
}

