/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.logbook.service;

import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitamui.commons.api.domain.ExternalParamProfileDto;
import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.OwnerDto;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.domain.UserInfoDto;
import fr.gouv.vitamui.commons.api.enums.UserStatusEnum;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.logbook.common.EventLogable;
import fr.gouv.vitamui.commons.logbook.common.EventType;
import fr.gouv.vitamui.commons.logbook.dto.EventDiffDto;
import fr.gouv.vitamui.commons.logbook.service.EventService;
import fr.gouv.vitamui.commons.logbook.util.LogbookUtils;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.internal.server.config.Converters;
import fr.gouv.vitamui.iam.internal.server.customer.domain.Customer;
import fr.gouv.vitamui.iam.internal.server.group.domain.Group;
import fr.gouv.vitamui.iam.internal.server.idp.domain.IdentityProvider;
import fr.gouv.vitamui.iam.internal.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.internal.server.owner.domain.Owner;
import fr.gouv.vitamui.iam.internal.server.profile.domain.Profile;
import fr.gouv.vitamui.iam.internal.server.subrogation.domain.Subrogation;
import fr.gouv.vitamui.iam.internal.server.tenant.dao.TenantRepository;
import fr.gouv.vitamui.iam.internal.server.tenant.domain.Tenant;
import fr.gouv.vitamui.iam.internal.server.user.domain.ConnectionHistory;
import fr.gouv.vitamui.iam.internal.server.user.domain.User;
import fr.gouv.vitamui.iam.internal.server.user.domain.UserInfo;
import fr.gouv.vitamui.iam.internal.server.user.service.ConnectionHistoryService;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class IamLogbookService {
    private final EventService eventService;
    private final InternalSecurityService internalSecurityService;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IamLogbookService.class);
    private final Converters converters;
    private final TenantRepository tenantRepository;
    private final ConnectionHistoryService connectionHistoryService;
    @Value(value="#{new Boolean('${user.connection.tracing.enabled}')}")
    private boolean isTraceConnectionActive;

    public IamLogbookService(EventService logbookService, InternalSecurityService internalSecurityService, Converters converters, TenantRepository tenantRepository, ConnectionHistoryService connectionHistoryService) {
        this.eventService = logbookService;
        this.internalSecurityService = internalSecurityService;
        this.converters = converters;
        this.tenantRepository = tenantRepository;
        this.connectionHistoryService = connectionHistoryService;
    }

    public void createCustomerEvent(CustomerDto sourceEvent) {
        LOGGER.debug("Create Customer {}", (Object)sourceEvent.toString());
        this.create(this.getCurrentProofTenantIdentifier(), sourceEvent.getIdentifier(), "customers", EventType.EXT_VITAMUI_CREATE_CUSTOMER, this.converters.getCustomerConverter().convertToLogbook(sourceEvent));
    }

    public void subrogation(SubrogationDto sourceEvent, EventType eventType) {
        String msg = null;
        switch (1.$SwitchMap$fr$gouv$vitamui$commons$logbook$common$EventType[eventType.ordinal()]) {
            case 1: {
                msg = "Surrogate decline subrogation";
                break;
            }
            case 2: {
                msg = "SuperUser stop subrogation";
                break;
            }
            case 3: {
                msg = "SuperUser logout from subrogation";
                break;
            }
            case 4: {
                msg = "Generic's user subrogation started";
                break;
            }
            case 5: {
                msg = "User subrogation started";
                break;
            }
        }
        LOGGER.debug(msg + "{}", (Object)sourceEvent.toString());
        this.create(this.getProofTenantIdentifierByCustomerId(sourceEvent.getSuperUserCustomerId()), sourceEvent.getId(), "subrogations", eventType, this.converters.getSubrogationConverter().convertToLogbook(sourceEvent));
    }

    public void subrogation(Subrogation sourceEvent, EventType eventType) {
        this.subrogation(this.converters.getSubrogationConverter().convertEntityToDto(sourceEvent), eventType);
    }

    public void createProfileEvent(ProfileDto sourceEvent) {
        LOGGER.debug("Create Profile {}", (Object)sourceEvent.toString());
        this.create(sourceEvent.getTenantIdentifier(), sourceEvent.getIdentifier(), "profiles", EventType.EXT_VITAMUI_CREATE_PROFILE, this.converters.getProfileConverter().convertToLogbook(sourceEvent));
    }

    public void createIdpEvent(IdentityProviderDto sourceEvent) {
        LOGGER.debug("Create Provider {}", (Object)sourceEvent.toString());
        this.create(this.getCurrentProofTenantIdentifier(), sourceEvent.getIdentifier(), "providers", EventType.EXT_VITAMUI_CREATE_IDP, this.converters.getIdpConverter().convertToLogbook(sourceEvent));
    }

    public void createIdpEvent(IdentityProvider sourceEvent) {
        this.createIdpEvent(this.converters.getIdpConverter().convertEntityToDto(sourceEvent));
    }

    public void createIdpEventInitCustomer(IdentityProvider sourceEvent) {
        LOGGER.debug("Create Provider {}", (Object)sourceEvent.toString());
        this.create(this.getCurrentProofTenantIdentifier(), sourceEvent.getIdentifier(), "providers", EventType.EXT_VITAMUI_CREATE_IDP, this.converters.getIdpConverter().convertToLogbook(this.converters.getIdpConverter().convertEntityToDto(sourceEvent)));
    }

    public void createProfileEvent(Profile sourceEvent) {
        this.createProfileEvent(this.converters.getProfileConverter().convertEntityToDto(sourceEvent));
    }

    public void createUserEvent(UserDto sourceEvent) {
        LOGGER.debug("Create User {}", (Object)sourceEvent.toString());
        this.create(this.getCurrentProofTenantIdentifier(), sourceEvent.getIdentifier(), "users", EventType.EXT_VITAMUI_CREATE_USER, this.converters.getUserConverter().convertToLogbook(sourceEvent));
    }

    public void createUserInfoEvent(UserInfoDto sourceEvent) {
        LOGGER.info("Create User Info {}", (Object)sourceEvent.toString());
        this.create(this.getCurrentProofTenantIdentifier(), sourceEvent.getIdentifier(), "userInfos", EventType.EXT_VITAMUI_CREATE_USER_INFO, this.converters.getUserInfoConverter().convertToLogbook(sourceEvent));
    }

    public void createOwnerEvent(OwnerDto sourceEvent) {
        LOGGER.debug("Create Owner {}", (Object)sourceEvent.toString());
        this.create(this.getCurrentProofTenantIdentifier(), sourceEvent.getIdentifier(), "owners", EventType.EXT_VITAMUI_CREATE_OWNER, this.converters.getOwnerConverter().convertToLogbook(sourceEvent));
    }

    public void createOwnerEventInitCustomer(OwnerDto sourceEvent) {
        LOGGER.debug("Create Owner {}", (Object)sourceEvent.toString());
        this.create(this.getCurrentProofTenantIdentifier(), sourceEvent.getIdentifier(), "owners", EventType.EXT_VITAMUI_CREATE_OWNER, this.converters.getOwnerConverter().convertToLogbook(sourceEvent));
    }

    public void createGroupEvent(GroupDto sourceEvent) {
        LOGGER.debug("Create Group {}", (Object)sourceEvent.toString());
        this.create(this.getCurrentProofTenantIdentifier(), sourceEvent.getIdentifier(), "groups", EventType.EXT_VITAMUI_CREATE_GROUP, this.converters.getGroupConverter().convertToLogbook(sourceEvent));
    }

    public void createGroupEvent(Group group) {
        this.createGroupEvent(this.converters.getGroupConverter().convertEntityToDto(group));
    }

    public void createTenantEvent(TenantDto sourceEvent) {
        LOGGER.debug("Create Tenant {}", (Object)sourceEvent.toString());
        this.create(this.getCurrentProofTenantIdentifier(), String.valueOf(sourceEvent.getIdentifier()), "tenants", EventType.EXT_VITAMUI_CREATE_TENANT, this.converters.getTenantConverter().convertToLogbook(sourceEvent));
    }

    public void createTenantEventInitCustomer(Tenant sourceEvent) {
        LOGGER.debug("Create Tenant {}", (Object)sourceEvent.toString());
        this.create(this.getCurrentProofTenantIdentifier(), String.valueOf(sourceEvent.getIdentifier()), "tenants", EventType.EXT_VITAMUI_CREATE_TENANT, this.converters.getTenantConverter().convertToLogbook(this.converters.getTenantConverter().convertEntityToDto(sourceEvent)));
    }

    public void createTenantEvent(Tenant sourceEvent) {
        this.createTenantEvent(this.converters.getTenantConverter().convertEntityToDto(sourceEvent));
    }

    public void updateProfileEvent(Profile profile, Collection<EventDiffDto> logbooks) {
        LOGGER.debug("Update Profile {}", (Object)profile.toString());
        this.update(profile.getTenantIdentifier(), profile.getIdentifier(), "profiles", EventType.EXT_VITAMUI_UPDATE_PROFILE, logbooks);
    }

    public void updateGroupEvent(Group group, Collection<EventDiffDto> logbooks) {
        LOGGER.debug("Update Group {}", (Object)group.toString());
        this.update(this.getCurrentProofTenantIdentifier(), group.getIdentifier(), "groups", EventType.EXT_VITAMUI_UPDATE_GROUP, logbooks);
    }

    public void updateUserEvent(User user, Collection<EventDiffDto> logbooks) {
        LOGGER.debug("Update User {}", (Object)user.toString());
        this.update(this.getCurrentProofTenantIdentifier(), user.getIdentifier(), "users", EventType.EXT_VITAMUI_UPDATE_USER, logbooks);
    }

    public void updateUserInfoEvent(UserInfo userInfo, Collection<EventDiffDto> logbooks) {
        LOGGER.info("Update User Info {}", (Object)userInfo.toString());
        this.update(this.getCurrentProofTenantIdentifier(), userInfo.getIdentifier(), "userInfos", EventType.EXT_VITAMUI_UPDATE_USER_INFO, logbooks);
    }

    public void updateTenantEvent(Tenant tenant, Collection<EventDiffDto> logbooks) {
        LOGGER.debug("Update tenant {}", (Object)tenant.toString());
        this.update(this.getCurrentProofTenantIdentifier(), String.valueOf(tenant.getIdentifier()), "tenants", EventType.EXT_VITAMUI_UPDATE_TENANT, logbooks);
    }

    public void updateOwnerEvent(Owner owner, Collection<EventDiffDto> logbooks) {
        LOGGER.debug("Update Owner {}", (Object)owner.toString());
        this.update(this.getCurrentProofTenantIdentifier(), owner.getIdentifier(), "owners", EventType.EXT_VITAMUI_UPDATE_OWNER, logbooks);
    }

    public void updateIdpEvent(IdentityProvider idp, Collection<EventDiffDto> logbooks) {
        LOGGER.debug("Update Provider {}", (Object)idp.toString());
        this.update(this.getCurrentProofTenantIdentifier(), idp.getIdentifier(), "providers", EventType.EXT_VITAMUI_UPDATE_IDP, logbooks);
    }

    public void updateCustomerEvent(Customer customer, Collection<EventDiffDto> logbooks) {
        LOGGER.debug("Update Customer {}", (Object)customer.toString());
        this.update(this.getCurrentProofTenantIdentifier(), customer.getIdentifier(), "customers", EventType.EXT_VITAMUI_UPDATE_CUSTOMER, logbooks);
    }

    public void createPasswordEvent(User user) {
        LOGGER.debug("create password for user: {}", (Object)user.toString());
        this.create(this.getProofTenantIdentifierByCustomerId(user.getCustomerId()), user.getIdentifier(), "users", EventType.EXT_VITAMUI_PASSWORD_INIT, "");
    }

    public void updatePasswordEvent(User user) {
        LOGGER.debug("update password for user: {}", (Object)user.toString());
        this.create(this.getProofTenantIdentifierByCustomerId(user.getCustomerId()), user.getIdentifier(), "users", EventType.EXT_VITAMUI_PASSWORD_CHANGE, "");
    }

    public void revokePasswordEvent(User user, String superUser) {
        LOGGER.debug("revoke password for user: {} / superUser: {}", (Object)user, (Object)superUser);
        HashMap<String, String> logbookData = new HashMap<String, String>();
        if (superUser != null) {
            logbookData.put("Super utilisateur", superUser);
        }
        String json = ApiUtils.toJson(logbookData);
        this.create(this.getProofTenantIdentifierByCustomerId(user.getCustomerId()), user.getIdentifier(), "users", EventType.EXT_VITAMUI_PASSWORD_REVOCATION, json);
    }

    public void revokePasswordEvent(UserDto dto, String superUserIdentifier) {
        this.revokePasswordEvent(this.converters.getUserConverter().convertDtoToEntity(dto), superUserIdentifier);
    }

    public void blockUserEvent(User user, UserStatusEnum oldStatus, Duration duration) {
        LOGGER.debug("block user: {} / oldStatus: {}", (Object)user.toString(), (Object)oldStatus);
        List<EventDiffDto> updates = Arrays.asList(new EventDiffDto("Statut", (Object)oldStatus.toString(), (Object)user.getStatus().toString()));
        ObjectNode evDetData = LogbookUtils.getEvData(updates);
        evDetData.put("Dur\u00e9e du blocage", duration.toString());
        this.create(this.getProofTenantIdentifierByCustomerId(user.getCustomerId()), user.getIdentifier(), "users", EventType.EXT_VITAMUI_BLOCK_USER, evDetData.toString());
    }

    public void loginEvent(User user, String surrogateIdentifier, String ip, String errorMessage) {
        LOGGER.debug("Login statut: {} / user: {} - {} / surrogate: {} / IP: {} / errorMessage: {}", new Object[]{errorMessage != null ? StatusCode.KO : StatusCode.OK, user.getIdentifier(), user.getEmail(), surrogateIdentifier, ip, errorMessage});
        if (errorMessage == null && this.isTraceConnectionActive) {
            ConnectionHistory connectionHistory = ConnectionHistory.builder().userId(user.getIdentifier()).subrogatedUserId(surrogateIdentifier).connectionDateTime(new Date()).build();
            this.connectionHistoryService.saveUserConnection(connectionHistory);
        }
    }

    public void create(Integer tenantIdentifier, String identifier, String collectionNames, EventType eventType, String evData) {
        this.eventService.logCreate(this.internalSecurityService.getHttpContext(), this.getAccessContractLogbookIdentifier(tenantIdentifier), tenantIdentifier, identifier, collectionNames, (EventLogable)eventType, evData);
    }

    public void update(Integer tenantIdentifier, String identifier, String collectionNames, EventType eventType, Collection<EventDiffDto> evData) {
        this.eventService.logUpdate(this.internalSecurityService.getHttpContext(), this.getAccessContractLogbookIdentifier(tenantIdentifier), tenantIdentifier, identifier, collectionNames, (EventLogable)eventType, evData);
    }

    private String getAccessContractLogbookIdentifier(Integer tenantIdentifier) throws ApplicationServerException {
        Optional tenant = this.tenantRepository.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"identifier").is((Object)tenantIdentifier)));
        tenant.orElseThrow(() -> new NotFoundException("No tenant found with identifier : " + tenantIdentifier));
        return (String)StringUtils.defaultIfBlank((CharSequence)((Tenant)tenant.get()).getAccessContractLogbookIdentifier(), (CharSequence)"AC-000002");
    }

    private Integer getCurrentProofTenantIdentifier() {
        return this.internalSecurityService.getProofTenantIdentifier();
    }

    private Integer getProofTenantIdentifierByCustomerId(String customerId) {
        return this.getProofTenantByCustomerId(customerId).getIdentifier();
    }

    public Tenant getProofTenantByCustomerId(String customerId) {
        Optional optTenant = this.tenantRepository.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"customerId").is((Object)customerId).and("proof").is((Object)true)));
        optTenant.orElseThrow(() -> new NotFoundException("No proof tenant found for customerId : " + customerId));
        return (Tenant)optTenant.get();
    }

    public void createExternalParametersEvent(ExternalParametersDto sourceEvent) {
        LOGGER.info("Create ExternalParameters {}", (Object)sourceEvent.toString());
        this.create(this.getCurrentProofTenantIdentifier(), sourceEvent.getIdentifier(), "externalParameters", EventType.EXT_VITAMUI_CREATE_EXTERNAL_PARAM, this.converters.getExternalParametersConverter().convertToLogbook(sourceEvent));
    }

    public void updateExternalParametersEvent(ExternalParametersDto externalParametersDto, Collection<EventDiffDto> logbooks) {
        LOGGER.info("Update ExternalParameters {}", (Object)externalParametersDto.toString());
        this.update(this.getCurrentProofTenantIdentifier(), externalParametersDto.getIdentifier(), "externalParameters", EventType.EXT_VITAMUI_UPDATE_EXTERNAL_PARAM, logbooks);
    }

    public void createExternalParamProfileEvent(ExternalParamProfileDto externalParamProfileDto) {
        LOGGER.info("Create ExternalParameter Profile {}", (Object)externalParamProfileDto.toString());
        this.create(this.getCurrentProofTenantIdentifier(), externalParamProfileDto.getIdProfile(), "externalparamprofile", EventType.EXT_VITAMUI_CREATE_EXTERNAL_PARAM_PROFILE, this.converters.getExternalParamProfileConverter().convertToLogbook(externalParamProfileDto));
    }

    public void updateExternalParamProfileEvent(ExternalParamProfileDto externalParamProfileDto, Collection<EventDiffDto> logbooks) {
        LOGGER.info("Update Profile {}", (Object)externalParamProfileDto.toString());
        this.update(this.getCurrentProofTenantIdentifier(), externalParamProfileDto.getIdProfile(), "externalparamprofile", EventType.EXT_VITAMUI_UPDATE_EXTERNAL_PARAM_PROFILE, logbooks);
    }
}

