/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.group.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.BaseIdDocument;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.logbook.common.EventType;
import fr.gouv.vitamui.commons.logbook.dto.EventDiffDto;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.mongo.service.VitamUICrudService;
import fr.gouv.vitamui.commons.mongo.utils.MongoUtils;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookEventDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.common.utils.IamUtils;
import fr.gouv.vitamui.iam.internal.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.internal.server.customer.domain.Customer;
import fr.gouv.vitamui.iam.internal.server.group.converter.GroupConverter;
import fr.gouv.vitamui.iam.internal.server.group.dao.GroupRepository;
import fr.gouv.vitamui.iam.internal.server.group.domain.Group;
import fr.gouv.vitamui.iam.internal.server.group.service.GroupExportService;
import fr.gouv.vitamui.iam.internal.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.internal.server.profile.service.ProfileInternalService;
import fr.gouv.vitamui.iam.internal.server.tenant.dao.TenantRepository;
import fr.gouv.vitamui.iam.internal.server.tenant.domain.Tenant;
import fr.gouv.vitamui.iam.internal.server.user.dao.UserRepository;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class GroupInternalService
extends VitamUICrudService<GroupDto, Group> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(GroupInternalService.class);
    private final GroupRepository groupRepository;
    private final CustomerRepository customerRepository;
    private final ProfileInternalService internalProfileService;
    private final UserRepository userRepository;
    private final InternalSecurityService internalSecurityService;
    private final TenantRepository tenantRepository;
    private final IamLogbookService iamLogbookService;
    private final GroupConverter groupConverter;
    private LogbookService logbookService;
    private final GroupExportService groupExportService;

    @Autowired
    public GroupInternalService(SequenceGeneratorService sequenceGeneratorService, GroupRepository groupRepository, CustomerRepository customerRepository, ProfileInternalService internalProfileService, UserRepository userRepository, InternalSecurityService internalSecurityService, TenantRepository tenantRepository, IamLogbookService iamLogbookService, GroupConverter groupConverter, LogbookService logbookService, GroupExportService groupExportService) {
        super(sequenceGeneratorService);
        this.groupRepository = groupRepository;
        this.customerRepository = customerRepository;
        this.internalProfileService = internalProfileService;
        this.userRepository = userRepository;
        this.internalSecurityService = internalSecurityService;
        this.tenantRepository = tenantRepository;
        this.iamLogbookService = iamLogbookService;
        this.groupConverter = groupConverter;
        this.logbookService = logbookService;
        this.groupExportService = groupExportService;
    }

    public List<GroupDto> getAll(Optional<String> criteria, Optional<String> embedded) {
        return super.getAll(criteria, embedded);
    }

    public PaginatedValuesDto<GroupDto> getAllPaginated(Integer page, Integer size, Optional<String> criteriaJsonString, Optional<String> orderBy, Optional<DirectionDto> direction, Optional<String> embedded) {
        return super.getAllPaginated(page, size, criteriaJsonString, orderBy, direction, embedded);
    }

    public GroupDto getOne(String id, Optional<String> criteria, Optional<String> embedded) {
        return (GroupDto)super.getOne(id, criteria, embedded);
    }

    protected void beforeCreate(GroupDto dto) {
        String message = "Unable to create group " + dto.getName();
        this.checkSetReadonly(dto.isReadonly(), message);
        this.checkCustomer(dto.getCustomerId(), message);
        this.checkNameExist(null, dto.getName(), dto.getCustomerId(), message);
        this.checkUnitsExist(null, dto.getUnits(), dto.getCustomerId(), message);
        this.checkLevel(dto.getLevel(), message);
        this.checkProfiles(dto.getLevel(), dto.getCustomerId(), dto.getProfileIds(), message);
        super.checkIdentifier(dto.getIdentifier(), message);
        dto.setId(this.generateSuperId());
        dto.setIdentifier(this.getNextSequenceId("groupIdentifier"));
    }

    protected Group beforePatch(Map<String, Object> partialDto) {
        Boolean enabled;
        String name;
        List profileIds;
        Boolean readonly;
        String id = CastUtils.toString((Object)partialDto.get("id"));
        String message = "Unable to update group " + id;
        if (this.getVitamContext() != null) {
            LOGGER.debug("Patch Group EvIdAppSession : {} ", (Object)this.getVitamContext().getApplicationSessionId());
        }
        String customerId = CastUtils.toString((Object)partialDto.get("customerId"));
        Group group = this.find(id, customerId, message);
        this.checkLevel(group.getLevel(), message);
        this.checkIsReadonly(group.isReadonly(), message);
        Assert.isTrue((!this.checkMapContainsOnlyFieldsUnmodifiable(partialDto, Arrays.asList("id", "customerId", "readonly", "identifier")) ? 1 : 0) != 0, (String)message);
        String level = CastUtils.toString((Object)partialDto.get("level"));
        if (level != null) {
            this.checkLevel(level, message);
            this.checkModifyLevel(group, level, message);
        }
        if ((readonly = CastUtils.toBoolean((Object)partialDto.get("readonly"))) != null) {
            this.checkSetReadonly(readonly.booleanValue(), message);
        }
        if ((profileIds = (List)partialDto.get("profileIds")) != null) {
            this.checkProfiles(group.getLevel(), customerId, profileIds, message);
        }
        if ((name = CastUtils.toString((Object)partialDto.get("name"))) != null) {
            this.checkNameExist(group.getName(), name, customerId, message);
        }
        if ((enabled = CastUtils.toBoolean((Object)partialDto.get("enabled"))) != null) {
            this.checkEnabled(group.getId(), enabled.booleanValue(), message);
        }
        return group;
    }

    protected void processPatch(Group group, Map<String, Object> partialDto) {
        ArrayList<EventDiffDto> logbooks = new ArrayList<EventDiffDto>();
        if (this.getVitamContext() != null) {
            LOGGER.debug("Patch Group EvIdAppSession : {} ", (Object)this.getVitamContext().getApplicationSessionId());
        }
        block21: for (Map.Entry<String, Object> entry : partialDto.entrySet()) {
            switch (entry.getKey()) {
                case "id": 
                case "customerId": 
                case "readonly": 
                case "identifier": {
                    continue block21;
                }
                case "name": {
                    logbooks.add(new EventDiffDto("Nom", (Object)group.getName(), entry.getValue()));
                    group.setName(CastUtils.toString((Object)entry.getValue()));
                    continue block21;
                }
                case "description": {
                    logbooks.add(new EventDiffDto("Description", (Object)group.getDescription(), entry.getValue()));
                    group.setDescription(CastUtils.toString((Object)entry.getValue()));
                    continue block21;
                }
                case "enabled": {
                    logbooks.add(new EventDiffDto("Activ\u00e9", (Object)group.isEnabled(), entry.getValue()));
                    group.setEnabled(CastUtils.toBoolean((Object)entry.getValue()).booleanValue());
                    continue block21;
                }
                case "level": {
                    logbooks.add(new EventDiffDto("Niveau", (Object)group.getLevel(), entry.getValue()));
                    group.setLevel(CastUtils.toString((Object)entry.getValue()));
                    continue block21;
                }
                case "profileIds": {
                    List profileIds = CastUtils.toList((Object)entry.getValue());
                    logbooks.add(new EventDiffDto("Liste des profils", (Object)this.groupConverter.convertProfileIdsToLogbook((Collection)group.getProfileIds()), (Object)this.groupConverter.convertProfileIdsToLogbook((Collection)profileIds)));
                    group.setProfileIds(profileIds);
                    continue block21;
                }
                case "units": {
                    Collection unitsDto = CollectionUtils.emptyIfNull((Collection)CastUtils.toList((Object)entry.getValue()));
                    HashSet units = new HashSet(unitsDto);
                    logbooks.add(new EventDiffDto("Liste des unit\u00e9s d'appartenance", (Object)this.groupConverter.convertUnitsToLogbook(group.getUnits()), (Object)this.groupConverter.convertUnitsToLogbook(units)));
                    group.setUnits(units);
                    continue block21;
                }
            }
            throw new IllegalArgumentException("Unable to patch group " + group.getId() + ": key " + entry.getKey() + " is not allowed");
        }
        this.iamLogbookService.updateGroupEvent(group, logbooks);
    }

    @Transactional
    public GroupDto patch(Map<String, Object> partialDto) {
        GroupDto groupDto = (GroupDto)super.patch(partialDto);
        this.loadExtraInformation(groupDto, Optional.of(EmbeddedOptions.ALL.toString()));
        return groupDto;
    }

    private Group find(String id, String customerId, String message) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)(message + ": no id"));
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)customerId, (CharSequence)this.getInternalSecurityService().getCustomerId()), (String)(message + ": customerId " + customerId + " is not allowed"));
        return (Group)this.getRepository().findByIdAndCustomerId(id, customerId).orElseThrow(() -> new IllegalArgumentException(message + ": no group found for id " + id + " - customerId " + customerId));
    }

    private void checkEnabled(String groupId, boolean dtoEnable, String message) {
        if (!dtoEnable) {
            long count = this.userRepository.countByGroupId(groupId);
            Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)(message + ": the group is referenced by " + count + " users"));
        }
    }

    private void checkLevel(String level, String message) {
        Assert.isTrue((boolean)Pattern.matches("(^[A-Z0-9]+(.[A-Z0-9]+)*$)|^$", level), (String)("level : " + level + " format is not allowed"));
        Assert.isTrue((boolean)this.internalSecurityService.isLevelAllowed(level), (String)(message + ": level " + level + " is not allowed"));
    }

    private void checkModifyLevel(Group group, String dtoLevel, String message) {
        if (!StringUtils.equals((CharSequence)group.getLevel(), (CharSequence)dtoLevel)) {
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)group.getProfileIds()), (String)(message + ": the group contains " + group.getProfileIds().size() + " profiles"));
            long count = this.userRepository.countByGroupId(group.getId());
            Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)(message + ": the group is referenced by " + count + " users"));
        }
    }

    @Transactional
    public GroupDto create(GroupDto dto) {
        GroupDto group = (GroupDto)super.create((IdDto)dto);
        this.iamLogbookService.createGroupEvent(dto);
        return group;
    }

    private void checkProfiles(String groupLevel, String customerId, List<String> dtoProfiles, String message) {
        List profiles = this.internalProfileService.getMany(dtoProfiles, Optional.of(EmbeddedOptions.ALL.toString()));
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)profiles), (String)(message + ": no profiles"));
        Assert.isTrue((profiles.size() == dtoProfiles.size() ? 1 : 0) != 0, (String)(message + ": one of the profiles does not exist"));
        profiles.stream().forEach(p -> Assert.isTrue((boolean)p.isEnabled(), (String)(message + ": one of the profile is disabled")));
        profiles.stream().forEach(p -> {
            LOGGER.debug("Profile : {} - profileLevel : {}, grouplevel : {}.", new Object[]{p, p.getLevel(), groupLevel});
            Assert.isTrue((boolean)StringUtils.equals((CharSequence)p.getLevel(), (CharSequence)groupLevel), (String)(message + ": profile and group level must be equals"));
        });
        profiles.stream().forEach(p -> {
            LOGGER.debug("Veryfing profile : {}", (Object)p.getId());
            LOGGER.debug("Profile : {}", p);
            Assert.isTrue((boolean)StringUtils.equals((CharSequence)p.getCustomerId(), (CharSequence)customerId), (String)(message + ": profile and group customerId must be equals"));
        });
        profiles.stream().forEach(p -> {
            Tenant tenant = this.tenantRepository.findByIdentifier(p.getTenantIdentifier());
            Assert.notNull((Object)tenant, (String)(message + ": the following tenant does not exist in database: " + p.getTenantIdentifier()));
            Assert.isTrue((boolean)StringUtils.equals((CharSequence)tenant.getCustomerId(), (CharSequence)customerId), (String)(message + ": tenant and group customerId must be equals"));
        });
        for (int i = 0; i < profiles.size() - 1; ++i) {
            for (int j = i + 1; j < profiles.size(); ++j) {
                ProfileDto p1 = (ProfileDto)profiles.get(i);
                ProfileDto p2 = (ProfileDto)profiles.get(j);
                if (!StringUtils.equals((CharSequence)p1.getApplicationName(), (CharSequence)p2.getApplicationName()) || !p1.getTenantIdentifier().equals(p2.getTenantIdentifier())) continue;
                throw new IllegalArgumentException(message + ": profiles " + p1.getId() + " and " + p2.getId() + " share the same applicationName and tenant");
            }
        }
    }

    private void checkIsReadonly(boolean readonly, String message) {
        Assert.isTrue((!readonly ? 1 : 0) != 0, (String)(message + ": readonly group"));
    }

    private void checkSetReadonly(boolean readonly, String message) {
        Assert.isTrue((!readonly ? 1 : 0) != 0, (String)(message + ": readonly must be set to false"));
    }

    private void checkCustomer(String customerId, String message) {
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)customerId, (CharSequence)this.getInternalSecurityService().getCustomerId()), (String)(message + ": customerId " + customerId + " is not allowed"));
        Optional customer = this.customerRepository.findById((Object)customerId);
        Assert.isTrue((boolean)customer.isPresent(), (String)(message + ": customer " + customerId + " does not exist"));
        Assert.isTrue((boolean)((Customer)customer.get()).isEnabled(), (String)(message + ": customer must be enabled"));
    }

    private void checkNameExist(String oldName, String newName, String customerId, String message) {
        if (!StringUtils.equals((CharSequence)oldName, (CharSequence)newName)) {
            Criteria criteria = Criteria.where((String)"customerId").is((Object)customerId).and("name").is((Object)newName);
            Assert.isTrue((!this.getRepository().exists(new CriteriaDefinition[]{criteria}) ? 1 : 0) != 0, (String)(message + ": group already exists"));
        }
    }

    protected void checkUnitsExist(Set<String> oldUnits, Set<String> newUnits, String customerId, String message) {
        if (!Objects.deepEquals(oldUnits, newUnits) && CollectionUtils.isNotEmpty(newUnits)) {
            newUnits.stream().filter(unit -> !CollectionUtils.emptyIfNull((Collection)oldUnits).contains(unit)).forEach(unit -> {
                ArrayList<Criteria> criteria = new ArrayList<Criteria>();
                criteria.add(Criteria.where((String)"customerId").is((Object)customerId));
                MongoUtils.addCriteriaIgnoreCase((String)"units", Optional.of(unit), criteria);
                Assert.isTrue((!this.getRepository().exists(criteria) ? 1 : 0) != 0, (String)String.format(message + ": unit already exists", unit));
            });
        }
    }

    protected void loadExtraInformation(GroupDto dto, Optional<String> optEmbedded) {
        if (optEmbedded.isPresent()) {
            String embedded = optEmbedded.get();
            if (EmbeddedOptions.ALL.toString().equalsIgnoreCase(embedded)) {
                List profileIds = dto.getProfileIds();
                List profiles = this.internalProfileService.getMany(profileIds, IamUtils.buildOptionalEmbedded((Enum[])new Enum[]{EmbeddedOptions.ALL}));
                profiles.sort(Comparator.comparing(ProfileDto::getApplicationName).thenComparing((p1, p2) -> p1.getTenantName().compareTo(p2.getTenantName())).thenComparing(ProfileDto::getName));
                dto.setProfiles(profiles);
                dto.setUsersCount(Long.valueOf(this.userRepository.countByGroupId(dto.getId())));
            }
        }
    }

    public void updateProfilesById(String id, List<String> profileIds) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        Update update = Update.update((String)"profileIds", profileIds);
        Optional optionalGroup = this.groupRepository.findOne(query);
        if (optionalGroup.isPresent()) {
            Group group = (Group)optionalGroup.get();
            ArrayList<EventDiffDto> logbooks = new ArrayList<EventDiffDto>();
            logbooks.add(new EventDiffDto("Liste des profils", (Object)this.groupConverter.convertProfileIdsToLogbook((Collection)group.getProfileIds()), (Object)this.groupConverter.convertProfileIdsToLogbook(profileIds)));
            this.groupRepository.updateMulti(query, update);
            this.iamLogbookService.updateGroupEvent(group, logbooks);
        }
    }

    public List<String> getSubLevels(String level, String customerId) {
        ArrayList<Criteria> criterias = new ArrayList<Criteria>();
        criterias.add(Criteria.where((String)"customerId").in(new Object[]{customerId}));
        criterias.add(Criteria.where((String)"enabled").is((Object)true));
        if (!level.isEmpty()) {
            criterias.add(Criteria.where((String)"level").regex("^" + level + "\\..+$"));
        }
        return this.getRepository().findAll(criterias).stream().map(Group::getLevel).collect(Collectors.toList());
    }

    public Group internalConvertFromDtoToEntity(GroupDto dto) {
        return (Group)super.internalConvertFromDtoToEntity((IdDto)dto);
    }

    public GroupDto internalConvertFromEntityToDto(Group group) {
        return (GroupDto)super.internalConvertFromEntityToDto((BaseIdDocument)group);
    }

    public void addDataAccessRestrictions(Collection<CriteriaDefinition> criteria) {
        super.addDataAccessRestrictions(criteria);
    }

    public boolean checkExist(String criteriaJsonString) {
        return super.checkExist(criteriaJsonString);
    }

    protected Class<Group> getEntityClass() {
        return Group.class;
    }

    protected GroupRepository getRepository() {
        return this.groupRepository;
    }

    protected Converter<GroupDto, Group> getConverter() {
        return this.groupConverter;
    }

    public JsonNode findHistoryById(String id) throws VitamClientException {
        LOGGER.debug("findHistoryById for id" + id);
        Integer tenantIdentifier = this.internalSecurityService.getTenantIdentifier();
        VitamContext vitamContext = new VitamContext(tenantIdentifier).setAccessContract(this.internalSecurityService.getTenant(tenantIdentifier).getAccessContractLogbookIdentifier()).setApplicationSessionId(this.internalSecurityService.getApplicationId());
        Optional group = this.getRepository().findById((Object)id);
        group.orElseThrow(() -> new NotFoundException(String.format("No group found with id : %s", id)));
        return this.logbookService.findEventsByIdentifierAndCollectionNames(((Group)group.get()).getIdentifier(), "groups", vitamContext).toJsonNode();
    }

    public List<String> getLevels(Optional<String> criteriaJsonString) {
        Document document = this.groupFields(criteriaJsonString, new String[]{"level"});
        LOGGER.debug("getLevels : {}", (Object)document);
        if (document == null) {
            return new ArrayList<String>();
        }
        return (List)document.get((Object)"level");
    }

    private VitamContext getVitamContext() {
        return this.internalSecurityService.buildVitamContext(this.internalSecurityService.getTenantIdentifier());
    }

    public Resource exportProfileGroups(Optional<String> criteriaJsonString) {
        List groupsDto = this.getAll(criteriaJsonString, Optional.of("ALL"));
        List profilesDto = this.internalProfileService.getAll(criteriaJsonString, Optional.empty());
        if (CollectionUtils.isEmpty((Collection)groupsDto)) {
            throw new UnexpectedDataException("Profile groups list is empty");
        }
        return this.groupExportService.exportProfileGroups(groupsDto, profilesDto, this.loadGroupHistoryGroupedByEventType(groupsDto));
    }

    private Map<String, List<LogbookEventDto>> loadGroupHistoryGroupedByEventType(List<GroupDto> groupsDto) {
        if (CollectionUtils.isEmpty(groupsDto)) {
            return Map.of();
        }
        List groupsIds = groupsDto.stream().map(GroupDto::getIdentifier).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> types = List.of(EventType.EXT_VITAMUI_CREATE_GROUP.name(), EventType.EXT_VITAMUI_UPDATE_GROUP.name());
        RequestResponse operationRequest = this.logbookService.findEvents(groupsIds, "groups", this.getVitamContext());
        return ((LogbookOperationsResponseDto)VitamRestUtils.responseMapping((JsonNode)operationRequest.toJsonNode(), LogbookOperationsResponseDto.class)).getResults().stream().flatMap(op -> op.getEvents().stream()).filter(evt -> evt.getObIdReq().equals("groups") && types.contains(evt.getEvType()) && groupsIds.contains(evt.getObId())).collect(Collectors.groupingBy(LogbookEventDto::getEvType));
    }

    @Generated
    public GroupRepository getGroupRepository() {
        return this.groupRepository;
    }

    @Generated
    public CustomerRepository getCustomerRepository() {
        return this.customerRepository;
    }

    @Generated
    public ProfileInternalService getInternalProfileService() {
        return this.internalProfileService;
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    @Generated
    public InternalSecurityService getInternalSecurityService() {
        return this.internalSecurityService;
    }

    @Generated
    public TenantRepository getTenantRepository() {
        return this.tenantRepository;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }

    @Generated
    public GroupConverter getGroupConverter() {
        return this.groupConverter;
    }

    @Generated
    public LogbookService getLogbookService() {
        return this.logbookService;
    }

    @Generated
    public GroupExportService getGroupExportService() {
        return this.groupExportService;
    }

    @Generated
    public void setLogbookService(LogbookService logbookService) {
        this.logbookService = logbookService;
    }
}

