/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.group.dto;

import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.vitam.xls.dto.LineDto;
import fr.gouv.vitamui.commons.vitam.xls.dto.Type;
import fr.gouv.vitamui.commons.vitam.xls.dto.ValueDto;
import fr.gouv.vitamui.iam.internal.server.group.dto.ProfileGroupExport;
import fr.gouv.vitamui.iam.internal.server.group.dto.ProfileGroupExportSheet;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.mapstruct.ap.internal.util.Strings;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ProfileGroupExport
implements LineDto {
    public static final String TYPE_PROFILE_GROUP = "Groupe de profil";
    public static final String TYPE_PROFILE = "Profil";
    public static final String DATE_FR_PIPE_TIME_WITH_SECONDS = "dd/MM/yyyy '|' HH:mm:ss";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy '|' HH:mm:ss");
    private String id;
    private Integer identifier;
    private String name;
    private String type;
    private String status;
    private String description;
    private String subLevel;
    private String units;
    private Long usersCount;
    private String createdAt;
    private String lastModified;

    public static ProfileGroupExport fromGroup(GroupDto groupDto) {
        return ProfileGroupExport.builder().id(groupDto.getId()).identifier(Integer.valueOf(groupDto.getIdentifier())).name(groupDto.getName()).type("Groupe de profil").status(ProfileGroupExport.translateEnable((boolean)groupDto.isEnabled())).description(groupDto.getDescription()).subLevel(groupDto.getLevel()).units(ProfileGroupExport.join((String)"|", (Collection)groupDto.getUnits())).usersCount(Optional.ofNullable(groupDto.getUsersCount()).orElse(0L)).createdAt("").lastModified("").build();
    }

    public static ProfileGroupExport fromProfile(ProfileDto profileDto) {
        return ProfileGroupExport.builder().id(profileDto.getId()).identifier(Integer.valueOf(profileDto.getIdentifier())).name(profileDto.getName()).type("Profil").status(ProfileGroupExport.translateEnable((boolean)profileDto.isEnabled())).description(profileDto.getDescription()).subLevel(profileDto.getLevel()).usersCount(Optional.ofNullable(profileDto.getUsersCount()).orElse(0L)).units("").createdAt("").lastModified("").build();
    }

    public Map<String, ValueDto> toSheetLine() {
        return Map.of((String)ProfileGroupExportSheet.PROFILE_GROUP_SHEET_COLUMNS.get(0), ValueDto.of((Object)this.identifier, (Type)Type.DOUBLE), (String)ProfileGroupExportSheet.PROFILE_GROUP_SHEET_COLUMNS.get(1), ValueDto.of((Object)this.name, (Type)Type.STRING), (String)ProfileGroupExportSheet.PROFILE_GROUP_SHEET_COLUMNS.get(2), ValueDto.of((Object)this.type, (Type)Type.STRING), (String)ProfileGroupExportSheet.PROFILE_GROUP_SHEET_COLUMNS.get(3), ValueDto.of((Object)this.status, (Type)Type.STRING), (String)ProfileGroupExportSheet.PROFILE_GROUP_SHEET_COLUMNS.get(4), ValueDto.of((Object)this.description, (Type)Type.STRING), (String)ProfileGroupExportSheet.PROFILE_GROUP_SHEET_COLUMNS.get(5), ValueDto.of((Object)this.subLevel, (Type)Type.STRING), (String)ProfileGroupExportSheet.PROFILE_GROUP_SHEET_COLUMNS.get(6), ValueDto.of((Object)this.units, (Type)Type.STRING), (String)ProfileGroupExportSheet.PROFILE_GROUP_SHEET_COLUMNS.get(7), ValueDto.of((Object)this.usersCount, (Type)Type.DOUBLE), (String)ProfileGroupExportSheet.PROFILE_GROUP_SHEET_COLUMNS.get(8), ValueDto.of((Object)this.parseDateToFormat(this.createdAt), (Type)Type.STRING), (String)ProfileGroupExportSheet.PROFILE_GROUP_SHEET_COLUMNS.get(9), ValueDto.of((Object)this.parseDateToFormat(this.lastModified), (Type)Type.STRING));
    }

    static String join(String separator, Collection<String> collection) {
        if (collection == null) {
            return "";
        }
        return String.join((CharSequence)separator, collection);
    }

    private static String translateEnable(boolean enable) {
        return enable ? "actif" : "inactif";
    }

    private String parseDateToFormat(String date) {
        if (Strings.isEmpty((String)date)) {
            return "";
        }
        LocalDateTime frDate = LocalDateTime.parse(date).plusHours(1L);
        return frDate.format(FORMATTER);
    }

    @Generated
    public static ProfileGroupExportBuilder builder() {
        return new ProfileGroupExportBuilder();
    }

    @Generated
    public ProfileGroupExport(String id, Integer identifier, String name, String type, String status, String description, String subLevel, String units, Long usersCount, String createdAt, String lastModified) {
        this.id = id;
        this.identifier = identifier;
        this.name = name;
        this.type = type;
        this.status = status;
        this.description = description;
        this.subLevel = subLevel;
        this.units = units;
        this.usersCount = usersCount;
        this.createdAt = createdAt;
        this.lastModified = lastModified;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getSubLevel() {
        return this.subLevel;
    }

    @Generated
    public String getUnits() {
        return this.units;
    }

    @Generated
    public Long getUsersCount() {
        return this.usersCount;
    }

    @Generated
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getLastModified() {
        return this.lastModified;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIdentifier(Integer identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setSubLevel(String subLevel) {
        this.subLevel = subLevel;
    }

    @Generated
    public void setUnits(String units) {
        this.units = units;
    }

    @Generated
    public void setUsersCount(Long usersCount) {
        this.usersCount = usersCount;
    }

    @Generated
    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }
}

