/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.externalparamprofile.dao;

import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.ExternalParamProfileDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.iam.internal.server.externalparamprofile.dao.CriteriaQueryHelper;
import fr.gouv.vitamui.iam.internal.server.externalparamprofile.dao.ExternalParamProfileRepository;
import fr.gouv.vitamui.iam.internal.server.externalparamprofile.service.ExternalParamProfileInternalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.LimitOperation;
import org.springframework.data.mongodb.core.aggregation.LookupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.aggregation.SkipOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.data.mongodb.core.aggregation.UnwindOperation;
import org.springframework.data.mongodb.core.query.Criteria;

public class ExternalParamProfileRepository {
    private final MongoOperations mongoOperations;
    private static final String PARAMETERS = "parameters";
    private static final String COUNT = "count";
    private static final String DESCRIPTION = "description";
    private static final String ENABLED = "enabled";
    private static final String EXTERNAL = "external";
    private static final String EXTERNAL_IDENTIFIER = "external.identifier";
    private static final String EXTERNAL_PARAM_ID = "externalParamId";
    private static final String EXTERNAL_PARAM_IDENTIFIER = "externalParamIdentifier";
    private static final String EXTERNAL_ID = "external._id";
    private static final String EXTERNAL_PARAMETERS = "external.parameters";
    private static final String ID = "_id";
    private static final String ID_EXTERNAL_PARAM = "idExternalParam";
    private static final String ID_PROFILE = "idProfile";
    private static final String IDENTIFIER = "identifier";
    private static final String NAME = "name";
    private static final String PROFILE_ID = "profileIdentifier";

    public ExternalParamProfileRepository(MongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
    }

    public ExternalParamProfileDto findByIdProfile(String idProfile) {
        String criteria = "{\"criteria\":[{\"queryOperator\":\"AND\",\"criteria\":[{\"key\":\"_id\",\"value\":\"" + idProfile + "\",\"operator\":\"EQUALSIGNORECASE\"}]}]}";
        Aggregation aggregation = this.buildAggregation(criteria, null, null);
        ExternalParamProfileDto profileDto = (ExternalParamProfileDto)this.mongoOperations.aggregate(aggregation, "profiles", ExternalParamProfileDto.class).getUniqueMappedResult();
        if (profileDto != null) {
            ExternalParamProfileInternalService.extractFieldsFromExternalParameters((ExternalParamProfileDto)profileDto);
        }
        return profileDto;
    }

    public PaginatedValuesDto<ExternalParamProfileDto> getAllPaginated(Integer pageNumber, Integer size, String criteria, String orderBy, DirectionDto direction) {
        Aggregation aggregation = this.buildAggregation(criteria, orderBy, direction);
        List operations = aggregation.getPipeline().getOperations();
        Aggregation countAggregation = Aggregation.newAggregation((AggregationOperation[])operations.toArray(new AggregationOperation[0]));
        countAggregation.getPipeline().add((AggregationOperation)Aggregation.count().as(COUNT));
        NumberOfResults counter = (NumberOfResults)this.mongoOperations.aggregate(countAggregation, "profiles", NumberOfResults.class).getUniqueMappedResult();
        Aggregation paginateAggregation = Aggregation.newAggregation((AggregationOperation[])operations.toArray(new AggregationOperation[0]));
        SkipOperation skipOperation = Aggregation.skip((long)((long)pageNumber.intValue() * (long)size.intValue()));
        LimitOperation limitOperation = Aggregation.limit((long)size.intValue());
        paginateAggregation.getPipeline().add((AggregationOperation)skipOperation).add((AggregationOperation)limitOperation);
        List dtos = this.mongoOperations.aggregate(paginateAggregation, "profiles", ExternalParamProfileDto.class).getMappedResults();
        dtos.stream().forEach(dto -> ExternalParamProfileInternalService.extractFieldsFromExternalParameters((ExternalParamProfileDto)dto));
        int count = counter != null ? counter.getCount() : 0;
        boolean hasMore = pageNumber * size + dtos.size() < count;
        return new PaginatedValuesDto((Collection)dtos, pageNumber.intValue(), size.intValue(), hasMore);
    }

    private Aggregation buildAggregation(String criteria, String orderBy, DirectionDto direction) {
        ArrayList<Object> operations = new ArrayList<Object>();
        if (criteria != null) {
            MatchOperation matchOperation = Aggregation.match((Criteria)CriteriaQueryHelper.getCriteria((String)criteria));
            operations.add(matchOperation);
        }
        LookupOperation lookupOperation = Aggregation.lookup((String)"externalParameters", (String)EXTERNAL_PARAM_ID, (String)ID, (String)EXTERNAL);
        operations.add(lookupOperation);
        UnwindOperation externalUnwindOperation = Aggregation.unwind((String)EXTERNAL, (boolean)false);
        operations.add(externalUnwindOperation);
        ProjectionOperation projectionOperation = Aggregation.project((String[])new String[]{NAME, DESCRIPTION, ENABLED}).andExpression(IDENTIFIER, new Object[0]).as(PROFILE_ID).andExpression(ID, new Object[0]).as(ID_PROFILE).andExpression(PARAMETERS, new Object[0]).as(EXTERNAL_PARAMETERS).andInclude(Fields.from((Field[])new Field[]{Fields.field((String)PARAMETERS, (String)EXTERNAL_PARAMETERS)})).andInclude(Fields.from((Field[])new Field[]{Fields.field((String)EXTERNAL_PARAM_IDENTIFIER, (String)EXTERNAL_IDENTIFIER)})).andInclude(Fields.from((Field[])new Field[]{Fields.field((String)ID_EXTERNAL_PARAM, (String)EXTERNAL_ID)}));
        operations.add(projectionOperation);
        if (orderBy != null && direction != null) {
            SortOperation sortOperation = Aggregation.sort((Sort.Direction)Sort.Direction.valueOf((String)direction.name()), (String[])new String[]{orderBy});
            operations.add(sortOperation);
        }
        return Aggregation.newAggregation(operations);
    }
}

