/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.customer.service;

import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.LanguageDto;
import fr.gouv.vitamui.commons.api.domain.OwnerDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.domain.UserInfoDto;
import fr.gouv.vitamui.commons.api.enums.UserTypeEnum;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.enums.Application;
import fr.gouv.vitamui.iam.internal.server.common.ApiIamInternalConstants;
import fr.gouv.vitamui.iam.internal.server.common.utils.EntityFactory;
import fr.gouv.vitamui.iam.internal.server.customer.config.CustomerInitConfig;
import fr.gouv.vitamui.iam.internal.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.internal.server.externalParameters.service.ExternalParametersInternalService;
import fr.gouv.vitamui.iam.internal.server.group.dao.GroupRepository;
import fr.gouv.vitamui.iam.internal.server.group.domain.Group;
import fr.gouv.vitamui.iam.internal.server.group.service.GroupInternalService;
import fr.gouv.vitamui.iam.internal.server.idp.converter.IdentityProviderConverter;
import fr.gouv.vitamui.iam.internal.server.idp.dao.IdentityProviderRepository;
import fr.gouv.vitamui.iam.internal.server.idp.domain.IdentityProvider;
import fr.gouv.vitamui.iam.internal.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.internal.server.owner.converter.OwnerConverter;
import fr.gouv.vitamui.iam.internal.server.owner.dao.OwnerRepository;
import fr.gouv.vitamui.iam.internal.server.owner.domain.Owner;
import fr.gouv.vitamui.iam.internal.server.owner.service.OwnerInternalService;
import fr.gouv.vitamui.iam.internal.server.profile.dao.ProfileRepository;
import fr.gouv.vitamui.iam.internal.server.profile.domain.Profile;
import fr.gouv.vitamui.iam.internal.server.profile.service.ProfileInternalService;
import fr.gouv.vitamui.iam.internal.server.tenant.dao.TenantRepository;
import fr.gouv.vitamui.iam.internal.server.tenant.domain.Tenant;
import fr.gouv.vitamui.iam.internal.server.tenant.service.InitVitamTenantService;
import fr.gouv.vitamui.iam.internal.server.tenant.service.TenantInternalService;
import fr.gouv.vitamui.iam.internal.server.user.dao.UserRepository;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInfoInternalService;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInternalService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class InitCustomerService {
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private IdentityProviderRepository identityProviderRepository;
    @Autowired
    private OwnerRepository ownerRepository;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private ProfileRepository profileRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private OwnerInternalService internalOwnerService;
    @Autowired
    private TenantInternalService internalTenantService;
    @Autowired
    private UserInternalService internalUserService;
    @Autowired
    private UserInfoInternalService userInfoInternalService;
    @Autowired
    private ProfileInternalService internalProfileService;
    @Autowired
    private GroupInternalService internalGroupService;
    @Autowired
    private SequenceGeneratorService sequenceGeneratorService;
    @Autowired
    private IamLogbookService iamLogbookService;
    @Autowired
    private OwnerConverter ownerConverter;
    @Autowired
    private IdentityProviderConverter idpConverter;
    @Autowired
    private InitVitamTenantService initVitamTenantService;
    @Autowired
    private CustomerInitConfig customerInitConfig;
    @Autowired
    private ExternalParametersInternalService externalParametersInternalService;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(InitCustomerService.class);

    @Transactional
    public void initCustomer(String tenantName, CustomerDto customerDto, List<OwnerDto> owners) {
        List<OwnerDto> ownerDtos = owners;
        List createdOwnerDtos = this.createOwners(ownerDtos, customerDto.getId());
        this.createIdentityProvider(customerDto.getId(), customerDto.getDefaultEmailDomain());
        LOGGER.debug("Initializing External Parameter with Customer Identifier {} and tenant Name {}", (Object)customerDto.getIdentifier(), (Object)tenantName);
        ExternalParametersDto fullAccessContract = this.initFullAccessContractExternalParameter(customerDto.getIdentifier(), tenantName);
        Tenant proofTenantDto = this.createProofTenant(tenantName, ((OwnerDto)createdOwnerDtos.get(0)).getId(), customerDto.getId(), fullAccessContract);
        List createdAdminProfiles = this.createAdminProfiles(customerDto, proofTenantDto);
        Profile fullAccessContractProfile = this.createExternalParameterProfileForDefaultAccessContract(customerDto.getId(), proofTenantDto.getIdentifier(), fullAccessContract.getId());
        createdAdminProfiles.add(fullAccessContractProfile);
        fullAccessContract.setName("DEFAULT_EXT_PARAM_" + proofTenantDto.getIdentifier());
        LOGGER.debug("External Parameter added into DataBase {}", (Object)fullAccessContract);
        this.externalParametersInternalService.update((IdDto)fullAccessContract);
        Group createdAdminGroup = this.createAdminGroup(customerDto, createdAdminProfiles);
        this.createAdminUser(customerDto, createdAdminGroup);
        List customProfiles = this.createCustomProfiles(customerDto, proofTenantDto);
        List customGroups = this.createCustomGroups(customerDto, proofTenantDto, customProfiles);
        this.createCustomUsers(customerDto, customGroups);
    }

    private ExternalParametersDto initFullAccessContractExternalParameter(String customerIdentifier, String tenantName) {
        ExternalParametersDto fullAccessContract = new ExternalParametersDto();
        fullAccessContract.setIdentifier("DEFAULT_EXT_PARAM_" + customerIdentifier + "_" + tenantName);
        fullAccessContract.setName("Liste des param\u00e9trages externes du tenant " + customerIdentifier + "_" + tenantName);
        return fullAccessContract;
    }

    private OwnerDto saveOwner(OwnerDto dto) {
        Owner o = this.ownerConverter.convertDtoToEntity(dto);
        o.setId(this.ownerRepository.generateSuperId());
        o.setIdentifier(this.generateIdentifier("ownerIdentifier"));
        Owner ownerSaved = (Owner)this.ownerRepository.save((Object)o);
        OwnerDto ownerDto = this.ownerConverter.convertEntityToDto(ownerSaved);
        this.iamLogbookService.createOwnerEventInitCustomer(ownerDto);
        return ownerDto;
    }

    private IdentityProvider saveIdentityProvider(IdentityProvider idp) {
        idp.setId(this.identityProviderRepository.generateSuperId());
        this.iamLogbookService.createIdpEventInitCustomer(idp);
        return (IdentityProvider)this.identityProviderRepository.save((Object)idp);
    }

    private Tenant saveTenant(Tenant tenant) {
        tenant.setId(this.tenantRepository.generateSuperId());
        this.iamLogbookService.createTenantEventInitCustomer(tenant);
        return (Tenant)this.tenantRepository.save((Object)tenant);
    }

    private Profile saveProfile(Profile profile) {
        profile.setId(this.profileRepository.generateSuperId());
        this.iamLogbookService.createProfileEvent(profile);
        return (Profile)this.profileRepository.save((Object)profile);
    }

    private Group saveGroup(Group group) {
        group.setId(this.groupRepository.generateSuperId());
        this.iamLogbookService.createGroupEvent(group);
        return (Group)this.groupRepository.save((Object)group);
    }

    private UserDto saveUser(UserDto dto) {
        return this.internalUserService.create(dto);
    }

    private UserInfoDto saveUserInfo(String language) {
        UserInfoDto userInfoDto = new UserInfoDto();
        userInfoDto.setLanguage(language);
        return this.userInfoInternalService.create(userInfoDto);
    }

    private List<OwnerDto> createOwners(List<OwnerDto> ownerDtos, String customerId) {
        ArrayList<OwnerDto> owners = new ArrayList<OwnerDto>();
        for (OwnerDto ownerDto : ownerDtos) {
            ownerDto.setCustomerId(customerId);
            owners.add(this.saveOwner(ownerDto));
        }
        return owners;
    }

    private IdentityProvider createIdentityProvider(String customerId, String domain) {
        IdentityProvider idp = new IdentityProvider();
        idp.setIdentifier(this.generateIdentifier("providerIdentifier"));
        idp.setCustomerId(customerId);
        idp.setPatterns(Arrays.asList(".*@" + domain));
        idp.setName("default");
        idp.setInternal(Boolean.valueOf(true));
        idp.setEnabled(Boolean.valueOf(true));
        idp.setTechnicalName(this.idpConverter.buildTechnicalName("default") + idp.getIdentifier());
        return this.saveIdentityProvider(idp);
    }

    private Tenant createProofTenant(String tenantName, String ownerId, String customerId, ExternalParametersDto fullAccessContractDto) {
        Tenant tenant = new Tenant();
        tenant.setCustomerId(customerId);
        tenant.setName(tenantName);
        tenant.setProof(true);
        tenant.setOwnerId(ownerId);
        tenant.setEnabled(Boolean.valueOf(true));
        tenant.setReadonly(false);
        tenant.setIdentifier(this.internalTenantService.getNextSequenceId("tenantIdentifier", 1));
        Tenant createdTenant = this.initVitamTenantService.init(tenant, fullAccessContractDto);
        this.externalParametersInternalService.create(fullAccessContractDto);
        return this.saveTenant(createdTenant);
    }

    private List<Profile> createCustomProfiles(CustomerDto customerDto, Tenant proofTenant) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        if (this.customerInitConfig.getProfiles() != null) {
            this.customerInitConfig.getProfiles().forEach(p -> {
                Profile profile = EntityFactory.buildProfile((String)(p.getName() + " " + proofTenant.getIdentifier()), (String)this.generateIdentifier("profileIdentifier"), (String)p.getDescription(), (boolean)true, (String)p.getLevel(), (Integer)proofTenant.getIdentifier(), (String)p.getAppName(), (List)p.getRoles(), (String)customerDto.getId());
                profiles.add(this.saveProfile(profile));
            });
        }
        return profiles;
    }

    private Profile createExternalParameterProfileForDefaultAccessContract(String customerId, Integer tenantIdentifier, String externalParameterId) {
        Profile defaultAccessContractProfile = EntityFactory.buildProfile((String)("Profil pour la gestion des param\u00e9trages externes du tenant  " + tenantIdentifier), (String)this.generateIdentifier("profileIdentifier"), (String)("Profil pour la gestion des param\u00e9trages externes du tenant  " + tenantIdentifier), (boolean)true, (String)"", (Integer)tenantIdentifier, (String)Application.EXTERNAL_PARAMS.name(), List.of("ROLE_GET_EXTERNAL_PARAMS"), (String)customerId, (String)externalParameterId);
        return this.saveProfile(defaultAccessContractProfile);
    }

    private List<Group> createCustomGroups(CustomerDto customerDto, Tenant proofTenant, List<Profile> profilesAvailable) {
        ArrayList<Group> groups = new ArrayList<Group>();
        if (this.customerInitConfig.getProfilesGroups() != null) {
            this.customerInitConfig.getProfilesGroups().forEach(g -> {
                Group group = EntityFactory.buildGroup((String)g.getName(), (String)this.generateIdentifier("groupIdentifier"), (String)g.getDescription(), (boolean)true, (String)g.getLevel(), profilesAvailable.stream().filter(p -> g.getProfiles().contains(p.getName().substring(0, p.getName().indexOf(" " + proofTenant.getIdentifier())))).collect(Collectors.toList()), (String)customerDto.getId());
                groups.add(this.saveGroup(group));
            });
        }
        return groups;
    }

    private List<UserDto> createCustomUsers(CustomerDto customerDto, List<Group> groupsAvailable) {
        ArrayList<UserDto> users = new ArrayList<UserDto>();
        if (this.customerInitConfig.getUsers() != null) {
            Map groupsByName = groupsAvailable.stream().collect(Collectors.toMap(Group::getName, Function.identity()));
            this.customerInitConfig.getUsers().forEach(u -> {
                UserDto userDto = new UserDto();
                userDto.setOtp(false);
                userDto.setType(UserTypeEnum.GENERIC);
                userDto.setSubrogeable(true);
                userDto.setLastname(u.getLastName());
                userDto.setFirstname(u.getFirstName());
                userDto.setUserInfoId(this.saveUserInfo(this.getLanguage(customerDto)).getId());
                userDto.setGroupId(((Group)groupsByName.get(u.getProfilesGroupName())).getId());
                userDto.setLevel(u.getLevel());
                userDto.setCustomerId(customerDto.getId());
                userDto.setEmail(u.getEmailPrefix() + "@" + customerDto.getDefaultEmailDomain().replace(".*", ""));
                users.add(this.saveUser(userDto));
            });
        }
        return users;
    }

    private List<Profile> createAdminProfiles(CustomerDto customerDto, Tenant proofTenant) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        Profile userProfile = EntityFactory.buildProfile((String)("Profil pour la gestion des utilisateurs " + proofTenant.getIdentifier()), (String)this.generateIdentifier("profileIdentifier"), (String)"Profil de l'application de gestion des utilisateurs", (boolean)true, (String)"", (Integer)proofTenant.getIdentifier(), (String)"USERS_APP", (List)ApiIamInternalConstants.getUsersRoles(), (String)customerDto.getId());
        profiles.add(this.saveProfile(userProfile));
        Profile groupProfile = EntityFactory.buildProfile((String)("Profil pour la gestion des groupes d'utilisateurs " + proofTenant.getIdentifier()), (String)this.generateIdentifier("profileIdentifier"), (String)"Profil de l'application de gestion des groupes", (boolean)true, (String)"", (Integer)proofTenant.getIdentifier(), (String)"GROUPS_APP", (List)ApiIamInternalConstants.getGroupsRoles(), (String)customerDto.getId());
        profiles.add(this.saveProfile(groupProfile));
        Profile profileUserProfileDto = EntityFactory.buildProfile((String)("Profil pour la gestion des profils d'utilisateurs " + proofTenant.getIdentifier()), (String)this.generateIdentifier("profileIdentifier"), (String)"Profil de l'application de gestion des profils utilisateurs", (boolean)true, (String)"", (Integer)proofTenant.getIdentifier(), (String)"PROFILES_APP", (List)ApiIamInternalConstants.getProfilesRoles(), (String)customerDto.getId());
        profiles.add(this.saveProfile(profileUserProfileDto));
        Profile accountProfile = EntityFactory.buildProfile((String)("Profil pour la gestion de mon compte " + proofTenant.getIdentifier()), (String)this.generateIdentifier("profileIdentifier"), (String)"Profil de l'application Mon Compte", (boolean)true, (String)"", (Integer)proofTenant.getIdentifier(), (String)"ACCOUNTS_APP", (List)ApiIamInternalConstants.getAccountRoles(), (String)customerDto.getId());
        profiles.add(this.saveProfile(accountProfile));
        if (this.customerInitConfig.getAdminProfiles() != null) {
            this.customerInitConfig.getAdminProfiles().forEach(p -> {
                Profile profile = EntityFactory.buildProfile((String)(p.getName() + " " + proofTenant.getIdentifier()), (String)this.generateIdentifier("profileIdentifier"), (String)p.getDescription(), (boolean)true, (String)p.getLevel(), (Integer)proofTenant.getIdentifier(), (String)p.getAppName(), (List)p.getRoles(), (String)customerDto.getId());
                profiles.add(this.saveProfile(profile));
            });
        }
        List tenantProfiles = this.internalTenantService.getDefaultProfiles(proofTenant.getCustomerId(), proofTenant.getIdentifier());
        for (Profile p2 : tenantProfiles) {
            profiles.add(this.saveProfile(p2));
        }
        return profiles;
    }

    private Group createAdminGroup(CustomerDto customerDto, List<Profile> profiles) {
        ArrayList<Profile> filteredProfiles = new ArrayList<Profile>(profiles.stream().collect(Collectors.groupingBy(profile -> Pair.of((Object)profile.getApplicationName(), (Object)profile.getTenantIdentifier()), Collectors.collectingAndThen(Collectors.toList(), values -> (Profile)values.get(0)))).values());
        Group group = EntityFactory.buildGroup((String)this.getAdminClientRootName(customerDto), (String)this.generateIdentifier("groupIdentifier"), (String)"ADMIN_CLIENT_ROOT", (boolean)true, (String)"", filteredProfiles, (String)customerDto.getId());
        return this.saveGroup(group);
    }

    private UserDto createAdminUser(CustomerDto customerDto, Group group) {
        UserDto userDto = new UserDto();
        userDto.setOtp(false);
        userDto.setType(UserTypeEnum.GENERIC);
        userDto.setSubrogeable(true);
        userDto.setLastname("ADMIN");
        userDto.setFirstname("Admin");
        userDto.setUserInfoId(this.saveUserInfo(this.getLanguage(customerDto)).getId());
        userDto.setGroupId(group.getId());
        userDto.setLevel("");
        userDto.setCustomerId(customerDto.getId());
        userDto.setEmail("admin@" + customerDto.getDefaultEmailDomain().replace(".*", ""));
        return this.saveUser(userDto);
    }

    private String getLanguage(CustomerDto customerDto) {
        return (customerDto.getLanguage() == null ? LanguageDto.FRENCH : customerDto.getLanguage()).toString();
    }

    public String getAdminClientRootName(CustomerDto customerDto) {
        return "ADMIN_CLIENT_ROOT " + customerDto.getCode();
    }

    protected String generateIdentifier(String sequenceName) {
        return String.valueOf(this.sequenceGeneratorService.getNextSequenceId(sequenceName, 1));
    }

    @Generated
    public CustomerRepository getCustomerRepository() {
        return this.customerRepository;
    }

    @Generated
    public IdentityProviderRepository getIdentityProviderRepository() {
        return this.identityProviderRepository;
    }

    @Generated
    public OwnerRepository getOwnerRepository() {
        return this.ownerRepository;
    }

    @Generated
    public TenantRepository getTenantRepository() {
        return this.tenantRepository;
    }

    @Generated
    public GroupRepository getGroupRepository() {
        return this.groupRepository;
    }

    @Generated
    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    @Generated
    public OwnerInternalService getInternalOwnerService() {
        return this.internalOwnerService;
    }

    @Generated
    public TenantInternalService getInternalTenantService() {
        return this.internalTenantService;
    }

    @Generated
    public UserInternalService getInternalUserService() {
        return this.internalUserService;
    }

    @Generated
    public UserInfoInternalService getUserInfoInternalService() {
        return this.userInfoInternalService;
    }

    @Generated
    public ProfileInternalService getInternalProfileService() {
        return this.internalProfileService;
    }

    @Generated
    public GroupInternalService getInternalGroupService() {
        return this.internalGroupService;
    }

    @Generated
    public SequenceGeneratorService getSequenceGeneratorService() {
        return this.sequenceGeneratorService;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }

    @Generated
    public OwnerConverter getOwnerConverter() {
        return this.ownerConverter;
    }

    @Generated
    public IdentityProviderConverter getIdpConverter() {
        return this.idpConverter;
    }

    @Generated
    public InitVitamTenantService getInitVitamTenantService() {
        return this.initVitamTenantService;
    }

    @Generated
    public CustomerInitConfig getCustomerInitConfig() {
        return this.customerInitConfig;
    }

    @Generated
    public ExternalParametersInternalService getExternalParametersInternalService() {
        return this.externalParametersInternalService;
    }

    @Generated
    public void setCustomerRepository(CustomerRepository customerRepository) {
        this.customerRepository = customerRepository;
    }

    @Generated
    public void setIdentityProviderRepository(IdentityProviderRepository identityProviderRepository) {
        this.identityProviderRepository = identityProviderRepository;
    }

    @Generated
    public void setOwnerRepository(OwnerRepository ownerRepository) {
        this.ownerRepository = ownerRepository;
    }

    @Generated
    public void setTenantRepository(TenantRepository tenantRepository) {
        this.tenantRepository = tenantRepository;
    }

    @Generated
    public void setGroupRepository(GroupRepository groupRepository) {
        this.groupRepository = groupRepository;
    }

    @Generated
    public void setProfileRepository(ProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
    }

    @Generated
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Generated
    public void setInternalOwnerService(OwnerInternalService internalOwnerService) {
        this.internalOwnerService = internalOwnerService;
    }

    @Generated
    public void setInternalTenantService(TenantInternalService internalTenantService) {
        this.internalTenantService = internalTenantService;
    }

    @Generated
    public void setInternalUserService(UserInternalService internalUserService) {
        this.internalUserService = internalUserService;
    }

    @Generated
    public void setUserInfoInternalService(UserInfoInternalService userInfoInternalService) {
        this.userInfoInternalService = userInfoInternalService;
    }

    @Generated
    public void setInternalProfileService(ProfileInternalService internalProfileService) {
        this.internalProfileService = internalProfileService;
    }

    @Generated
    public void setInternalGroupService(GroupInternalService internalGroupService) {
        this.internalGroupService = internalGroupService;
    }

    @Generated
    public void setSequenceGeneratorService(SequenceGeneratorService sequenceGeneratorService) {
        this.sequenceGeneratorService = sequenceGeneratorService;
    }

    @Generated
    public void setIamLogbookService(IamLogbookService iamLogbookService) {
        this.iamLogbookService = iamLogbookService;
    }

    @Generated
    public void setOwnerConverter(OwnerConverter ownerConverter) {
        this.ownerConverter = ownerConverter;
    }

    @Generated
    public void setIdpConverter(IdentityProviderConverter idpConverter) {
        this.idpConverter = idpConverter;
    }

    @Generated
    public void setInitVitamTenantService(InitVitamTenantService initVitamTenantService) {
        this.initVitamTenantService = initVitamTenantService;
    }

    @Generated
    public void setCustomerInitConfig(CustomerInitConfig customerInitConfig) {
        this.customerInitConfig = customerInitConfig;
    }

    @Generated
    public void setExternalParametersInternalService(ExternalParametersInternalService externalParametersInternalService) {
        this.externalParametersInternalService = externalParametersInternalService;
    }
}

