/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.customer.converter;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.AddressDto;
import fr.gouv.vitamui.commons.api.domain.LanguageDto;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.logbook.util.LogbookUtils;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.internal.server.common.converter.AddressConverter;
import fr.gouv.vitamui.iam.internal.server.common.domain.Address;
import fr.gouv.vitamui.iam.internal.server.customer.domain.Customer;
import fr.gouv.vitamui.iam.internal.server.customer.domain.GraphicIdentity;
import fr.gouv.vitamui.iam.internal.server.owner.converter.OwnerConverter;
import fr.gouv.vitamui.iam.internal.server.owner.dao.OwnerRepository;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class CustomerConverter
implements Converter<CustomerDto, Customer> {
    private final OwnerRepository ownerRepository;
    private final OwnerConverter ownerConverter;
    private final AddressConverter addressConverter;
    public static final String CODE_KEY = "Code client";
    public static final String NAME_KEY = "Nom";
    public static final String ENABLED_KEY = "Activ\u00e9";
    public static final String COMPANY_NAME_KEY = "Raison sociale";
    public static final String PORTAL_TITLE = "Titre du portail";
    public static final String PORTAL_MESSAGE = "Message du portail";
    public static final String LANGUAGE_KEY = "Langue";
    public static final String PASSWORD_RECOVATION_KEY = "Dur\u00e9e de r\u00e9vocation de mot de passe (en mois)";
    public static final String OTP_KEY = "OTP";
    public static final String EMAIL_DOMAINS_KEY = "Domaines";
    public static final String INTERNAL_CODE_KEY = "Code interne";
    public static final String DEFAULT_EMAIL_DOMAIN_KEY = "Domaine par d\u00e9faut";
    public static final String SUBROGEABLE_KEY = "Subrogeable";
    public static final String CUSTOM_GRAPHIC_IDENTITY_KEY = "Identit\u00e9 graphique personnalis\u00e9e";
    public static final String GDPR_ALERT_DELAY_KEY = "GDPR D\u00e9lai d'alerte";
    public static final String GDPR_ALERT_KEY = "GDPR Alerte";

    public CustomerConverter(AddressConverter addressConverter, OwnerRepository ownerRepository, OwnerConverter ownerConverter) {
        this.ownerRepository = ownerRepository;
        this.ownerConverter = ownerConverter;
        this.addressConverter = addressConverter;
    }

    public String convertToLogbook(CustomerDto customer) {
        LinkedHashMap<String, String> logbookData = new LinkedHashMap<String, String>();
        logbookData.put(CODE_KEY, LogbookUtils.getValue((Object)customer.getCode()));
        logbookData.put(NAME_KEY, LogbookUtils.getValue((Object)customer.getName()));
        logbookData.put(GDPR_ALERT_DELAY_KEY, LogbookUtils.getValue((Object)customer.getGdprAlertDelay()));
        logbookData.put(GDPR_ALERT_KEY, LogbookUtils.getValue((Object)customer.isGdprAlert()));
        logbookData.put(ENABLED_KEY, LogbookUtils.getValue((Object)customer.isEnabled()));
        logbookData.put(COMPANY_NAME_KEY, LogbookUtils.getValue((Object)customer.getCompanyName()));
        AddressDto address = customer.getAddress() != null ? customer.getAddress() : new AddressDto();
        this.addressConverter.addAddress(address, logbookData);
        logbookData.put(LANGUAGE_KEY, LogbookUtils.getValue((Object)customer.getLanguage()));
        logbookData.put(PASSWORD_RECOVATION_KEY, LogbookUtils.getValue((Object)customer.getPasswordRevocationDelay()));
        logbookData.put(OTP_KEY, LogbookUtils.getValue((Object)customer.getOtp()));
        logbookData.put(EMAIL_DOMAINS_KEY, customer.getEmailDomains().toString());
        logbookData.put(DEFAULT_EMAIL_DOMAIN_KEY, LogbookUtils.getValue((Object)customer.getDefaultEmailDomain()));
        logbookData.put(SUBROGEABLE_KEY, LogbookUtils.getValue((Object)customer.isSubrogeable()));
        logbookData.put(INTERNAL_CODE_KEY, LogbookUtils.getValue((Object)customer.getInternalCode()));
        logbookData.put(CUSTOM_GRAPHIC_IDENTITY_KEY, LogbookUtils.getValue((Object)customer.isHasCustomGraphicIdentity()));
        logbookData.put(PORTAL_TITLE, LogbookUtils.getValue((Object)customer.getPortalMessages()));
        logbookData.put(PORTAL_MESSAGE, LogbookUtils.getValue((Object)customer.getPortalTitles()));
        return ApiUtils.toJson(logbookData);
    }

    public Customer convertDtoToEntity(CustomerDto dto) {
        Customer customer = (Customer)VitamUIUtils.copyProperties((Object)dto, (Object)new Customer());
        if (dto.getOtp() != null) {
            customer.setOtp(dto.getOtp());
        }
        if (dto.getLanguage() != null) {
            customer.setLanguage(dto.getLanguage().toString());
        }
        if (dto.getAddress() != null) {
            customer.setAddress((Address)VitamUIUtils.copyProperties((Object)dto.getAddress(), (Object)new Address()));
        }
        customer.setGraphicIdentity(new GraphicIdentity());
        customer.getGraphicIdentity().setHasCustomGraphicIdentity(dto.isHasCustomGraphicIdentity());
        customer.getGraphicIdentity().setThemeColors(dto.getThemeColors());
        return customer;
    }

    public CustomerDto convertEntityToDto(Customer customer) {
        List owners;
        CustomerDto dto = (CustomerDto)VitamUIUtils.copyProperties((Object)customer, (Object)new CustomerDto());
        if (customer.getOtp() != null) {
            dto.setOtp(customer.getOtp());
        }
        if (customer.getLanguage() != null) {
            dto.setLanguage(LanguageDto.valueOf((String)customer.getLanguage()));
        }
        if (customer.getAddress() != null) {
            dto.setAddress((AddressDto)VitamUIUtils.copyProperties((Object)customer.getAddress(), (Object)new AddressDto()));
        }
        if (customer.getGraphicIdentity() != null) {
            GraphicIdentity graphicalIdentity = customer.getGraphicIdentity();
            dto.setHasCustomGraphicIdentity(graphicalIdentity.isHasCustomGraphicIdentity());
            dto.setThemeColors(graphicalIdentity.getThemeColors());
        }
        if (CollectionUtils.isNotEmpty((Collection)(owners = this.ownerRepository.findAll(Query.query((CriteriaDefinition)Criteria.where((String)"customerId").is((Object)dto.getId())))))) {
            dto.setOwners(owners.stream().map(o -> this.ownerConverter.convertEntityToDto(o)).collect(Collectors.toList()));
        }
        return dto;
    }
}

