/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.config;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import fr.gouv.vitamui.commons.mongo.repository.impl.VitamUIRepositoryImpl;
import javax.annotation.PostConstruct;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"fr.gouv.vitamui.commons.mongo.repository", "fr.gouv.vitamui.commons.mongo.dao", "fr.gouv.vitamui.iam.internal.server"}, repositoryBaseClass=VitamUIRepositoryImpl.class)
public class MongoDbConfig {
    @Autowired
    private MongoDatabaseFactory mongoDbFactory;

    @PostConstruct
    public void afterPropertiesSet() {
        this.setUpTenantIndexOnCustomerId();
    }

    private void setUpTenantIndexOnCustomerId() {
        MongoDatabase db = this.mongoDbFactory.getMongoDatabase();
        MongoCollection tenantsCollection = db.getCollection("tenants");
        Document doc = new Document();
        doc.append("customerId", (Object)-1);
        IndexOptions options = new IndexOptions();
        options.background(true);
        options.name("idx_tenant_customerId");
        tenantsCollection.createIndex((Bson)doc, options);
    }
}

