/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.config;

import fr.gouv.vitamui.commons.api.application.AbstractContextConfiguration;
import fr.gouv.vitamui.commons.api.identity.ServerIdentityConfiguration;
import fr.gouv.vitamui.commons.mongo.config.MongoConfig;
import fr.gouv.vitamui.commons.mongo.dao.CustomSequenceRepository;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.commons.rest.client.BaseRestClientFactory;
import fr.gouv.vitamui.commons.rest.client.RestClientFactory;
import fr.gouv.vitamui.commons.rest.client.configuration.RestClientConfiguration;
import fr.gouv.vitamui.commons.rest.configuration.SwaggerConfiguration;
import fr.gouv.vitamui.commons.security.client.config.password.PasswordConfiguration;
import fr.gouv.vitamui.commons.security.client.password.PasswordValidator;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.administration.AccessContractService;
import fr.gouv.vitamui.commons.vitam.api.administration.IngestContractService;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAccessConfig;
import fr.gouv.vitamui.commons.vitam.api.config.VitamAdministrationConfig;
import fr.gouv.vitamui.iam.common.utils.IdentityProviderHelper;
import fr.gouv.vitamui.iam.common.utils.Pac4jClientBuilder;
import fr.gouv.vitamui.iam.internal.server.application.converter.ApplicationConverter;
import fr.gouv.vitamui.iam.internal.server.application.dao.ApplicationRepository;
import fr.gouv.vitamui.iam.internal.server.application.service.ApplicationInternalService;
import fr.gouv.vitamui.iam.internal.server.application.service.ExternalIdentifierConfiguration;
import fr.gouv.vitamui.iam.internal.server.cas.service.CasInternalService;
import fr.gouv.vitamui.iam.internal.server.common.service.AddressService;
import fr.gouv.vitamui.iam.internal.server.config.ConverterConfig;
import fr.gouv.vitamui.iam.internal.server.customer.config.CustomerInitConfig;
import fr.gouv.vitamui.iam.internal.server.customer.converter.CustomerConverter;
import fr.gouv.vitamui.iam.internal.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.internal.server.customer.service.CustomerInternalService;
import fr.gouv.vitamui.iam.internal.server.customer.service.InitCustomerService;
import fr.gouv.vitamui.iam.internal.server.externalParameters.converter.ExternalParametersConverter;
import fr.gouv.vitamui.iam.internal.server.externalParameters.dao.ExternalParametersRepository;
import fr.gouv.vitamui.iam.internal.server.externalParameters.service.ExternalParametersInternalService;
import fr.gouv.vitamui.iam.internal.server.externalparamprofile.dao.ExternalParamProfileRepository;
import fr.gouv.vitamui.iam.internal.server.externalparamprofile.service.ExternalParamProfileInternalService;
import fr.gouv.vitamui.iam.internal.server.group.converter.GroupConverter;
import fr.gouv.vitamui.iam.internal.server.group.dao.GroupRepository;
import fr.gouv.vitamui.iam.internal.server.group.service.GroupExportService;
import fr.gouv.vitamui.iam.internal.server.group.service.GroupInternalService;
import fr.gouv.vitamui.iam.internal.server.idp.converter.IdentityProviderConverter;
import fr.gouv.vitamui.iam.internal.server.idp.dao.IdentityProviderRepository;
import fr.gouv.vitamui.iam.internal.server.idp.service.IdentityProviderInternalService;
import fr.gouv.vitamui.iam.internal.server.idp.service.SpMetadataGenerator;
import fr.gouv.vitamui.iam.internal.server.logbook.config.LogbookConfiguration;
import fr.gouv.vitamui.iam.internal.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.internal.server.owner.converter.OwnerConverter;
import fr.gouv.vitamui.iam.internal.server.owner.dao.OwnerRepository;
import fr.gouv.vitamui.iam.internal.server.owner.service.OwnerInternalService;
import fr.gouv.vitamui.iam.internal.server.profile.converter.ProfileConverter;
import fr.gouv.vitamui.iam.internal.server.profile.dao.ProfileRepository;
import fr.gouv.vitamui.iam.internal.server.profile.service.ProfileInternalService;
import fr.gouv.vitamui.iam.internal.server.provisioning.config.ProvisioningClientConfiguration;
import fr.gouv.vitamui.iam.internal.server.provisioning.service.ProvisioningInternalService;
import fr.gouv.vitamui.iam.internal.server.security.IamApiAuthenticationProvider;
import fr.gouv.vitamui.iam.internal.server.security.IamAuthentificationService;
import fr.gouv.vitamui.iam.internal.server.subrogation.converter.SubrogationConverter;
import fr.gouv.vitamui.iam.internal.server.subrogation.dao.SubrogationRepository;
import fr.gouv.vitamui.iam.internal.server.subrogation.service.SubrogationInternalService;
import fr.gouv.vitamui.iam.internal.server.tenant.converter.TenantConverter;
import fr.gouv.vitamui.iam.internal.server.tenant.dao.TenantRepository;
import fr.gouv.vitamui.iam.internal.server.tenant.service.InitVitamTenantService;
import fr.gouv.vitamui.iam.internal.server.tenant.service.TenantInternalService;
import fr.gouv.vitamui.iam.internal.server.token.dao.TokenRepository;
import fr.gouv.vitamui.iam.internal.server.user.converter.UserConverter;
import fr.gouv.vitamui.iam.internal.server.user.converter.UserInfoConverter;
import fr.gouv.vitamui.iam.internal.server.user.dao.UserInfoRepository;
import fr.gouv.vitamui.iam.internal.server.user.dao.UserRepository;
import fr.gouv.vitamui.iam.internal.server.user.service.ConnectionHistoryService;
import fr.gouv.vitamui.iam.internal.server.user.service.UserEmailInternalService;
import fr.gouv.vitamui.iam.internal.server.user.service.UserExportService;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInfoInternalService;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInternalService;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.security.client.ContextRestClient;
import fr.gouv.vitamui.security.client.SecurityRestClientFactory;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.multipart.support.MultipartFilter;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@Import(value={RestExceptionHandler.class, MongoConfig.class, SwaggerConfiguration.class, ConverterConfig.class, LogbookConfiguration.class, VitamAccessConfig.class, VitamAdministrationConfig.class})
@EnableConfigurationProperties(value={PasswordConfiguration.class})
public class ApiIamServerConfig
extends AbstractContextConfiguration {
    @Autowired
    private ServerIdentityConfiguration serverIdentityConfiguration;
    @Autowired
    private PasswordConfiguration passwordConfiguration;

    @Bean
    public MultipartResolver multipartResolver() {
        return new CommonsMultipartResolver();
    }

    @Bean
    public PasswordValidator passwordValidator() {
        return new PasswordValidator();
    }

    @Bean
    public FilterRegistrationBean multipartFilterRegistrationBean() {
        MultipartFilter multipartFilter = new MultipartFilter();
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)multipartFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.addInitParameter("multipartResolverBeanName", "commonsMultipartResolver");
        return filterRegistrationBean;
    }

    @Bean
    @ConfigurationProperties(value="cas-client")
    public RestClientConfiguration casClientProperties() {
        return new RestClientConfiguration();
    }

    @Bean
    @ConfigurationProperties(value="provisioning-client")
    public ProvisioningClientConfiguration provisioningClientProperties() {
        return new ProvisioningClientConfiguration();
    }

    @Bean
    @ConfigurationProperties(value="security")
    public RestClientConfiguration securityClientProperties() {
        return new RestClientConfiguration();
    }

    @Bean
    public SecurityRestClientFactory securityRestClientFactory(RestTemplateBuilder restTemplateBuilder, RestClientConfiguration securityClientProperties) {
        return new SecurityRestClientFactory(securityClientProperties, restTemplateBuilder);
    }

    @Bean
    public ContextRestClient contextCrudRestClient(SecurityRestClientFactory securityRestClientFactory) {
        return securityRestClientFactory.getContextRestClient();
    }

    @Bean
    public IamAuthentificationService iamAuthentificationService(UserInternalService internalUserService, TokenRepository tokenRepository, SubrogationRepository subrogationRepository) {
        return new IamAuthentificationService(internalUserService, tokenRepository, subrogationRepository);
    }

    @Bean
    public IamApiAuthenticationProvider apiAuthenticationProvider(IamAuthentificationService iamAuthentificationService) {
        return new IamApiAuthenticationProvider(iamAuthentificationService);
    }

    @Bean
    public Pac4jClientBuilder pac4jClientBuilder() {
        return new Pac4jClientBuilder();
    }

    @Bean
    public SpMetadataGenerator spMetadataGenerator() {
        return new SpMetadataGenerator();
    }

    @Bean
    public SequenceGeneratorService sequenceGeneratorService(CustomSequenceRepository sequenceRepository) {
        return new SequenceGeneratorService(sequenceRepository);
    }

    @Bean
    public IdentityProviderInternalService identityProviderCrudService(SequenceGeneratorService sequenceGeneratorService, IdentityProviderRepository identityProviderRepository, SpMetadataGenerator spMetadataGenerator, CustomerRepository customerRepository, IamLogbookService iamLogbookService, IdentityProviderConverter idpConverter) {
        return new IdentityProviderInternalService(sequenceGeneratorService, identityProviderRepository, spMetadataGenerator, customerRepository, iamLogbookService, idpConverter);
    }

    @Bean
    public CustomerInternalService customerCrudService(SequenceGeneratorService sequenceGeneratorService, CustomerRepository customerRepository, OwnerInternalService internalOwnerService, UserInternalService userInternalService, InternalSecurityService internalSecurityService, AddressService addressService, InitCustomerService initCustomerService, IamLogbookService iamLogbookService, CustomerConverter customerConverter, LogbookService logbookService) {
        return new CustomerInternalService(sequenceGeneratorService, customerRepository, internalOwnerService, userInternalService, internalSecurityService, addressService, initCustomerService, iamLogbookService, customerConverter, logbookService);
    }

    @Bean
    public InitCustomerService initCustomerCrudService() {
        return new InitCustomerService();
    }

    @Bean
    public OwnerInternalService ownerCrudService(SequenceGeneratorService sequenceGeneratorService, OwnerRepository ownerRepository, CustomerRepository customerRepository, AddressService addressService, IamLogbookService iamLogbookService, InternalSecurityService internalSecurityService, OwnerConverter ownerConverter, LogbookService logbookService, TenantRepository tenantRepository) {
        return new OwnerInternalService(sequenceGeneratorService, ownerRepository, customerRepository, addressService, iamLogbookService, internalSecurityService, ownerConverter, logbookService, tenantRepository);
    }

    @Bean
    public InitVitamTenantService initVitamTenantService(AccessContractService accessContractService, IngestContractService ingestContractService, InternalSecurityService internalSecurityService, TenantConverter tenantConverter) {
        return new InitVitamTenantService(accessContractService, ingestContractService, internalSecurityService, tenantConverter);
    }

    @Bean
    public TenantInternalService tenantCrudService(SequenceGeneratorService sequenceGeneratorService, TenantRepository tenantRepository, CustomerRepository customerRepository, OwnerRepository ownerRepository, GroupRepository groupRepository, ProfileRepository profileRepository, UserRepository userRepository, GroupInternalService internalGroupService, UserInternalService internalUserService, OwnerInternalService internalOwnerService, ProfileInternalService internalProfileService, InternalSecurityService internalSecurityService, IamLogbookService iamLogbookService, TenantConverter tenantConverter, AccessContractService accessContractService, InitVitamTenantService initVitamTenantService, LogbookService logbookService, CustomerInitConfig customerInitConfig, ExternalParametersRepository externalParametersRepository, ExternalParametersInternalService externalParametersInternalService) {
        return new TenantInternalService(sequenceGeneratorService, tenantRepository, customerRepository, ownerRepository, groupRepository, profileRepository, userRepository, internalGroupService, internalUserService, internalOwnerService, internalProfileService, internalSecurityService, iamLogbookService, tenantConverter, initVitamTenantService, logbookService, customerInitConfig, externalParametersRepository, externalParametersInternalService);
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public UserInternalService userService(SequenceGeneratorService sequenceGeneratorService, UserRepository userRepository, ProfileInternalService profileInternalService, UserEmailInternalService userEmailInternalService, TenantRepository tenantRepository, InternalSecurityService internalSecurityService, CustomerRepository customerRepository, ProfileRepository profilRepository, GroupInternalService groupInternalService, GroupRepository groupRepository, IamLogbookService iamLogbookService, UserConverter userConverter, MongoTransactionManager mongoTransactionManager, LogbookService logbookService, AddressService addressService, ApplicationInternalService applicationInternalService, PasswordConfiguration passwordConfiguration, UserExportService userExportService, UserInfoInternalService userInfoInternalService, ConnectionHistoryService connectionHistoryService) {
        return new UserInternalService(sequenceGeneratorService, userRepository, groupInternalService, profileInternalService, userEmailInternalService, tenantRepository, internalSecurityService, customerRepository, profilRepository, groupRepository, iamLogbookService, userConverter, mongoTransactionManager, logbookService, addressService, applicationInternalService, passwordConfiguration, userExportService, userInfoInternalService, connectionHistoryService);
    }

    @Bean
    public UserInfoInternalService userInfoInternalService(SequenceGeneratorService sequenceGeneratorService, UserInfoRepository userInfoRepository, InternalSecurityService internalSecurityService, UserInfoConverter userInfoConverter, IamLogbookService iamLogbookService, LogbookService logbookService) {
        return new UserInfoInternalService(sequenceGeneratorService, userInfoRepository, internalSecurityService, userInfoConverter, iamLogbookService, logbookService);
    }

    @Bean
    public GroupInternalService groupInternalService(SequenceGeneratorService sequenceGeneratorService, GroupRepository groupRepository, CustomerRepository customerRepository, ProfileInternalService internalProfileService, UserRepository userRepository, InternalSecurityService internalSecurityService, TenantRepository tenantRepository, IamLogbookService iamLogbookService, GroupConverter groupConverter, LogbookService logbookService, GroupExportService groupExportService) {
        return new GroupInternalService(sequenceGeneratorService, groupRepository, customerRepository, internalProfileService, userRepository, internalSecurityService, tenantRepository, iamLogbookService, groupConverter, logbookService, groupExportService);
    }

    @Bean
    public ProfileInternalService profileCrudService(SequenceGeneratorService sequenceGeneratorService, ProfileRepository profileRepository, CustomerRepository customerRepository, GroupRepository groupRepository, TenantRepository tenantRepository, UserRepository userRepository, InternalSecurityService internalSecurityService, IamLogbookService iamLogbookService, ProfileConverter profileConverter, LogbookService logbookService) {
        return new ProfileInternalService(sequenceGeneratorService, profileRepository, customerRepository, groupRepository, tenantRepository, userRepository, internalSecurityService, iamLogbookService, profileConverter, logbookService);
    }

    @Bean
    public ApplicationInternalService applicationInternalService(SequenceGeneratorService sequenceGeneratorService, ApplicationRepository applicationRepository, ApplicationConverter applicationConverter, InternalSecurityService internalSecurityService, ExternalIdentifierConfiguration enabledApplicationConfiguration) {
        return new ApplicationInternalService(sequenceGeneratorService, applicationRepository, applicationConverter, internalSecurityService, enabledApplicationConfiguration);
    }

    @Bean
    public UserEmailInternalService userEmailService(RestTemplateBuilder restTemplateBuilder, RestClientConfiguration casClientProperties) {
        BaseRestClientFactory factory = new BaseRestClientFactory(casClientProperties, restTemplateBuilder);
        return new UserEmailInternalService((RestClientFactory)factory);
    }

    @Bean
    public ProvisioningInternalService provisioningService(WebClient.Builder webClientBuilder, ProvisioningClientConfiguration provisioningClientConfiguration, InternalSecurityService internalSecurityService) {
        return new ProvisioningInternalService(webClientBuilder, provisioningClientConfiguration, internalSecurityService);
    }

    @Bean
    public IdentityProviderHelper identityProviderHelper() {
        return new IdentityProviderHelper();
    }

    @Bean
    public InternalSecurityService securityService() {
        return new InternalSecurityService();
    }

    @Bean
    public SubrogationInternalService subrogationCrudService(SequenceGeneratorService sequenceGeneratorService, SubrogationRepository subrogationRepository, UserRepository userRepository, UserInternalService userInternalService, GroupInternalService groupInternalService, GroupRepository groupRepository, ProfileRepository profilRepository, InternalSecurityService internalSecurityService, CustomerRepository customerRepository, SubrogationConverter subrogationConverter, IamLogbookService iamLogbookService) {
        return new SubrogationInternalService(sequenceGeneratorService, subrogationRepository, userRepository, userInternalService, groupInternalService, groupRepository, profilRepository, internalSecurityService, customerRepository, subrogationConverter, iamLogbookService);
    }

    @Bean
    public CasInternalService casService() {
        return new CasInternalService();
    }

    @Bean
    public AddressService addressService() {
        return new AddressService();
    }

    @Bean
    public ExternalParametersInternalService externalParametersInternalService(CustomSequenceRepository sequenceRepository, ExternalParametersRepository externalParametersRepository, ExternalParametersConverter externalParametersConverter, InternalSecurityService internalSecurityService, IamLogbookService iamLogbookService) {
        return new ExternalParametersInternalService(sequenceRepository, externalParametersRepository, externalParametersConverter, internalSecurityService, iamLogbookService);
    }

    @Bean
    public ExternalParamProfileInternalService externalParamProfileInternalService(ExternalParametersInternalService externalParametersInternalService, ProfileInternalService profileInternalService, InternalSecurityService internalSecurityService, IamLogbookService iamLogbookService, ExternalParamProfileRepository externalParamProfileRepository, LogbookService logbookService, ProfileConverter profileConverter) {
        return new ExternalParamProfileInternalService(externalParametersInternalService, profileInternalService, internalSecurityService, iamLogbookService, externalParamProfileRepository, logbookService, profileConverter);
    }

    @Bean
    ExternalParamProfileRepository externalParamProfileRepository(MongoOperations mongoOperations) {
        return new ExternalParamProfileRepository(mongoOperations);
    }
}

