/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.common.service;

import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.logbook.dto.EventDiffDto;
import fr.gouv.vitamui.iam.internal.server.common.domain.Address;
import java.util.Collection;
import java.util.Map;

public class AddressService {
    public void processPatch(Address address, Map<String, Object> partialDto, Collection<EventDiffDto> logbooks, boolean anonymized) {
        block12: for (Map.Entry<String, Object> entry : partialDto.entrySet()) {
            String newValue = anonymized ? "-" : CastUtils.toString((Object)entry.getValue());
            switch (entry.getKey()) {
                case "street": {
                    String oldValue = anonymized ? "-" : address.getStreet();
                    logbooks.add(new EventDiffDto("Nom de la rue", (Object)oldValue, (Object)newValue));
                    address.setStreet(CastUtils.toString((Object)entry.getValue()));
                    continue block12;
                }
                case "zipCode": {
                    String oldValue = anonymized ? "-" : address.getZipCode();
                    logbooks.add(new EventDiffDto("Code postal", (Object)oldValue, (Object)newValue));
                    address.setZipCode(CastUtils.toString((Object)entry.getValue()));
                    continue block12;
                }
                case "city": {
                    String oldValue = anonymized ? "-" : address.getCity();
                    logbooks.add(new EventDiffDto("Ville", (Object)oldValue, (Object)newValue));
                    address.setCity(CastUtils.toString((Object)entry.getValue()));
                    continue block12;
                }
                case "country": {
                    String oldValue = anonymized ? "-" : address.getCountry();
                    logbooks.add(new EventDiffDto("Pays", (Object)oldValue, (Object)newValue));
                    address.setCountry(CastUtils.toString((Object)entry.getValue()));
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unable to patch address  key : " + entry.getKey() + " is not allowed");
        }
    }
}

