/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.cas.service;

import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.domain.UserInfoDto;
import fr.gouv.vitamui.commons.api.enums.UserStatusEnum;
import fr.gouv.vitamui.commons.api.enums.UserTypeEnum;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InvalidAuthenticationException;
import fr.gouv.vitamui.commons.api.exception.InvalidFormatException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.logbook.common.EventType;
import fr.gouv.vitamui.commons.rest.ApiErrorGenerator;
import fr.gouv.vitamui.commons.security.client.config.password.PasswordConfiguration;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.commons.security.client.password.PasswordValidator;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import fr.gouv.vitamui.iam.common.dto.ProvidedUserDto;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.internal.server.cas.service.CasInternalService;
import fr.gouv.vitamui.iam.internal.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.internal.server.customer.domain.Customer;
import fr.gouv.vitamui.iam.internal.server.customer.service.CustomerInternalService;
import fr.gouv.vitamui.iam.internal.server.group.service.GroupInternalService;
import fr.gouv.vitamui.iam.internal.server.idp.service.IdentityProviderInternalService;
import fr.gouv.vitamui.iam.internal.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.internal.server.provisioning.service.ProvisioningInternalService;
import fr.gouv.vitamui.iam.internal.server.subrogation.dao.SubrogationRepository;
import fr.gouv.vitamui.iam.internal.server.subrogation.domain.Subrogation;
import fr.gouv.vitamui.iam.internal.server.subrogation.service.SubrogationInternalService;
import fr.gouv.vitamui.iam.internal.server.tenant.service.TenantInternalService;
import fr.gouv.vitamui.iam.internal.server.token.dao.TokenRepository;
import fr.gouv.vitamui.iam.internal.server.token.domain.Token;
import fr.gouv.vitamui.iam.internal.server.user.dao.UserRepository;
import fr.gouv.vitamui.iam.internal.server.user.domain.User;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInfoInternalService;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInternalService;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class CasInternalService {
    private static final String USER_NOT_FOUND_MESSAGE = "User not found: ";
    private static final String USER_CONFLICT = "Could not select the right user: ";
    private static final String ID = "_id";
    private static final String NB_FAILED_ATTEMPTS = "nbFailedAttempts";
    private static final String STATUS = "status";
    private static final String LAST_CONNECTION = "lastConnection";
    private static final String TOKEN_PREFIX = "TOK";
    @Autowired
    private TokenRepository tokenRepository;
    @Autowired
    private UserInternalService internalUserService;
    @Autowired
    private UserInfoInternalService userInfoInternalService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private SubrogationInternalService internalSubrogationService;
    @Autowired
    private SubrogationRepository subrogationRepository;
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private CustomerInternalService customerInternalService;
    @Autowired
    private TenantInternalService internalTenantService;
    @Autowired
    private IamLogbookService iamLogbookService;
    @Autowired
    private IdentityProviderInternalService identityProviderInternalService;
    @Autowired
    private GroupInternalService groupInternalService;
    @Autowired
    private ProvisioningInternalService provisioningInternalService;
    @Value(value="${token.ttl}")
    @NotNull
    private Integer tokenTtl;
    @Value(value="${subrogaton.token.ttl}")
    @NotNull
    private Integer subrogationTokenTtl;
    @Value(value="${api.token.ttl}")
    @NotNull
    private Integer apiTokenTtl;
    @Value(value="${login.attempts.time.interval}")
    @NotNull
    private Integer timeIntervalForLoginAttempts;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private PasswordValidator passwordValidator;
    @Autowired
    private PasswordConfiguration passwordConfiguration;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(CasInternalService.class);
    private static final UniqueTicketIdGenerator TICKET_GENERATOR = new DefaultUniqueTicketIdGenerator();

    @Transactional
    public void updatePassword(String email, String rawPassword, String customerId) {
        Optional optCustomer = this.customerRepository.findById((Object)customerId);
        if (optCustomer.isEmpty()) {
            throw new ApplicationServerException("Unable to update password : customer not found");
        }
        User user = this.findUserByEmailAndCustomerId(email, customerId);
        if (UserTypeEnum.NOMINATIVE != user.getType()) {
            throw new InvalidAuthenticationException("User unavailable: " + email);
        }
        this.checkStatus(user.getStatus(), user.getEmail());
        Customer customer = (Customer)optCustomer.get();
        List oldPasswords = user.getOldPasswords();
        if (oldPasswords != null && !oldPasswords.isEmpty()) {
            for (String oldPassword : oldPasswords) {
                if (!this.passwordEncoder.matches((CharSequence)rawPassword, oldPassword)) continue;
                throw new ConflictException("The given password has already been used in the past");
            }
        }
        String encodedPassword = this.passwordEncoder.encode((CharSequence)rawPassword);
        this.internalUserService.saveCurrentPasswordInOldPasswords(user, encodedPassword, Integer.valueOf(this.passwordConfiguration != null && this.passwordConfiguration.getMaxOldPassword() != null ? this.passwordConfiguration.getMaxOldPassword() : 12));
        String existingPassword = user.getPassword();
        user.setPassword(encodedPassword);
        OffsetDateTime nowPlusPasswordRevocationDelay = OffsetDateTime.now().plusMonths(customer.getPasswordRevocationDelay().intValue());
        user.setPasswordExpirationDate(nowPlusPasswordRevocationDelay);
        this.userRepository.save((Object)user);
        if (StringUtils.isEmpty((CharSequence)existingPassword)) {
            this.iamLogbookService.createPasswordEvent(user);
        } else {
            this.iamLogbookService.updatePasswordEvent(user);
        }
    }

    @Transactional
    public void updateNbFailedAttempsPlusLastConnectionAndStatus(User user, int nbFailedAttempts, UserStatusEnum oldStatus) {
        UserStatusEnum newStatus = user.getStatus();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ID).is((Object)user.getId()));
        Update update = Update.update((String)NB_FAILED_ATTEMPTS, (Object)nbFailedAttempts).set(LAST_CONNECTION, (Object)OffsetDateTime.now()).set(STATUS, (Object)newStatus);
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, "users");
        if (newStatus == UserStatusEnum.BLOCKED) {
            this.iamLogbookService.blockUserEvent(user, oldStatus, Duration.ofMinutes(this.timeIntervalForLoginAttempts.intValue()));
        }
    }

    public User findUserByEmailAndCustomerId(String email, String customerId) {
        User user = this.userRepository.findByEmailIgnoreCaseAndCustomerId(email, customerId);
        if (user == null) {
            throw new NotFoundException(USER_NOT_FOUND_MESSAGE + email);
        }
        if (UserTypeEnum.NOMINATIVE != user.getType()) {
            throw new InvalidAuthenticationException("User unavailable: " + email);
        }
        this.checkStatus(user.getStatus(), user.getEmail());
        return user;
    }

    private void checkStatus(UserStatusEnum userStatus, String userEmail) {
        boolean badStatus;
        boolean bl = badStatus = UserStatusEnum.ENABLED != userStatus && UserStatusEnum.BLOCKED != userStatus;
        if (badStatus) {
            throw new InvalidFormatException("User unavailable: " + userEmail);
        }
    }

    @Transactional
    public List<UserDto> getUsersByEmail(String email, String optEmbedded) {
        boolean loadFullProfile = this.checkEmbeddedOption(optEmbedded, "authtoken");
        boolean isSubrogation = this.checkEmbeddedOption(optEmbedded, "surrogation");
        boolean isApi = this.checkEmbeddedOption(optEmbedded, "api");
        List usersDto = this.internalUserService.findUsersByEmail(email);
        return usersDto.stream().map(user -> this.loadFullUserProfileIfRequired(user, loadFullProfile, isSubrogation, isApi)).collect(Collectors.toList());
    }

    @Transactional
    public UserDto getUserByEmailAndCustomerId(String email, String customerId, String optEmbedded) {
        boolean loadFullProfile = this.checkEmbeddedOption(optEmbedded, "authtoken");
        boolean isSubrogation = this.checkEmbeddedOption(optEmbedded, "surrogation");
        boolean isApi = this.checkEmbeddedOption(optEmbedded, "api");
        UserDto userDto = this.internalUserService.findUserByEmailAndCustomerId(email, customerId);
        if (userDto == null) {
            throw new NotFoundException(USER_NOT_FOUND_MESSAGE + email);
        }
        this.checkStatus(userDto.getStatus(), userDto.getEmail());
        return this.loadFullUserProfileIfRequired(userDto, loadFullProfile, isSubrogation, isApi);
    }

    private boolean checkEmbeddedOption(String optEmbedded, String authTokenParameter) {
        if (optEmbedded == null) {
            return false;
        }
        Set values = this.splitIntoValues(optEmbedded);
        return values.contains(authTokenParameter);
    }

    private UserDto loadFullUserProfileIfRequired(UserDto user, boolean loadFullProfile, boolean subrogation, boolean api) {
        if (!loadFullProfile) {
            return user;
        }
        AuthUserDto authUserDto = this.internalUserService.loadGroupAndProfiles(user);
        this.internalUserService.addBasicCustomerAndProofTenantIdentifierInformation(authUserDto);
        this.internalUserService.addTenantsByAppInformation(authUserDto);
        this.generateAndAddAuthToken(authUserDto, subrogation, api);
        this.createEventsSubrogation(user, subrogation);
        return authUserDto;
    }

    @Transactional
    public UserDto getUser(String loginEmail, String loginCustomerId, String idp, String userIdentifier, String optEmbedded) {
        if (StringUtils.isNotBlank((CharSequence)idp)) {
            Optional providedUser = this.provisionUser(loginEmail, loginCustomerId, idp, userIdentifier);
            if (loginEmail.isBlank() && providedUser.isPresent()) {
                loginEmail = ((ProvidedUserDto)providedUser.get()).getEmail();
            }
        }
        return this.getUserByEmailAndCustomerId(loginEmail, loginCustomerId, optEmbedded);
    }

    public Optional<ProvidedUserDto> provisionUser(String loginEmail, String loginCustomerId, String idp, String userIdentifier) {
        boolean userExist;
        IdentityProviderDto identityProvider = (IdentityProviderDto)this.identityProviderInternalService.getOne(idp);
        Assert.isTrue((boolean)loginCustomerId.equals(identityProvider.getCustomerId()), (String)("CustomerId mismatch. LoginCustomerId : " + loginCustomerId + ", IDP customerId: " + identityProvider.getCustomerId()));
        if (!identityProvider.isAutoProvisioningEnabled()) {
            return Optional.empty();
        }
        Optional<Object> providedUser = Optional.empty();
        if (StringUtils.isBlank((CharSequence)loginEmail)) {
            providedUser = Optional.of(this.getProvidedUser(loginEmail, loginCustomerId, idp, userIdentifier, null));
            loginEmail = ((ProvidedUserDto)providedUser.get()).getEmail();
        }
        if (userExist = this.userRepository.existsByEmailIgnoreCaseAndCustomerId(loginEmail, loginCustomerId)) {
            UserDto user = this.internalUserService.findUserByEmailAndCustomerId(loginEmail, loginCustomerId);
            if (user.isAutoProvisioningEnabled()) {
                this.updateUser(user, this.getProvidedUser(loginEmail, loginCustomerId, idp, userIdentifier, user.getGroupId()));
            }
        } else {
            if (providedUser.isEmpty()) {
                providedUser = Optional.of(this.getProvidedUser(loginEmail, loginCustomerId, idp, userIdentifier, null));
            }
            this.createNewUser(loginEmail, (ProvidedUserDto)providedUser.get());
        }
        return providedUser;
    }

    private ProvidedUserDto getProvidedUser(String email, String loginCustomerId, String idp, String userIdentifier, String groupId) {
        ProvidedUserDto userProvidedInfo = this.provisioningInternalService.getUserInformation(idp, email, loginCustomerId, groupId, null, userIdentifier);
        if (Objects.isNull(userProvidedInfo)) {
            throw new NotFoundException(String.format("The following provided user does not exist: Email:%s, technicalId:%s, groupId:%s, idp:%s, customerId:%s", email, userIdentifier, groupId, idp, loginCustomerId));
        }
        return userProvidedInfo;
    }

    private void createNewUser(String email, ProvidedUserDto providedUserInfo) {
        UserDto user = new UserDto();
        user.setType(UserTypeEnum.NOMINATIVE);
        user.setSubrogeable(true);
        user.setAutoProvisioningEnabled(true);
        user.setFirstname(providedUserInfo.getFirstname());
        user.setLastname(providedUserInfo.getLastname());
        user.setEmail(email);
        user.setAddress(providedUserInfo.getAddress());
        user.setInternalCode(providedUserInfo.getInternalCode());
        user.setSiteCode(providedUserInfo.getSiteCode());
        GroupDto groupDto = this.getGroupByUnit(providedUserInfo.getUnit());
        user.setGroupId(groupDto.getId());
        user.setCustomerId(groupDto.getCustomerId());
        Customer customer = (Customer)this.customerRepository.findById((Object)user.getCustomerId()).orElseThrow(() -> new NotFoundException(String.format("Cannot find customer : %s", user.getCustomerId())));
        user.setUserInfoId(this.createUserInfo(customer.getLanguage()).getId());
        this.internalUserService.create(user);
    }

    private UserInfoDto createUserInfo(String language) {
        UserInfoDto userInfoDto = new UserInfoDto();
        userInfoDto.setLanguage(language);
        return this.userInfoInternalService.create(userInfoDto);
    }

    private GroupDto getGroupByUnit(String unit) {
        QueryDto criteria = QueryDto.criteria((String)"units", List.of(unit), (CriterionOperator)CriterionOperator.IN);
        List groups = this.groupInternalService.getAll(Optional.of(criteria.toJson()), Optional.empty());
        Assert.notEmpty((Collection)groups, (String)String.format("No group found for the given unit : %s", unit));
        return (GroupDto)groups.get(0);
    }

    private void updateUser(UserDto userDto, ProvidedUserDto userProvidedInfo) {
        HashMap<String, String> userUpdate = new HashMap<String, String>();
        this.updateUserMandatoryInformation(userDto, userProvidedInfo, userUpdate);
        this.updateUserOptionalInformation(userDto, userProvidedInfo, userUpdate);
        if (!userUpdate.isEmpty()) {
            userUpdate.put("id", userDto.getId());
            userUpdate.put("customerId", userDto.getCustomerId());
            this.internalUserService.patch(userUpdate);
        }
    }

    private void updateUserOptionalInformation(UserDto userDto, ProvidedUserDto userInfo, Map<String, Object> userUpdate) {
        if (userInfo.getInternalCode() != null && !StringUtils.equals((CharSequence)userInfo.getInternalCode(), (CharSequence)userDto.getInternalCode())) {
            userUpdate.put("internalCode", userInfo.getInternalCode());
        }
        if (userInfo.getSiteCode() != null && !StringUtils.equals((CharSequence)userInfo.getSiteCode(), (CharSequence)userDto.getSiteCode())) {
            userUpdate.put("siteCode", userInfo.getSiteCode());
        }
        this.updateUserAddress(userDto, userInfo, userUpdate);
    }

    private void updateUserMandatoryInformation(UserDto userDto, ProvidedUserDto userInfo, Map<String, Object> userUpdate) {
        if (!StringUtils.equals((CharSequence)userDto.getFirstname(), (CharSequence)userInfo.getFirstname())) {
            userUpdate.put("firstname", userInfo.getFirstname());
        }
        if (!StringUtils.equals((CharSequence)userDto.getLastname(), (CharSequence)userInfo.getLastname())) {
            userUpdate.put("lastname", userInfo.getLastname());
        }
        this.updateUserGroup(userDto, userInfo, userUpdate);
    }

    private void updateUserGroup(UserDto userDto, ProvidedUserDto userInfo, Map<String, Object> userUpdate) {
        QueryDto criteria = QueryDto.criteria((String)"units", List.of(userInfo.getUnit()), (CriterionOperator)CriterionOperator.IN);
        List groups = this.groupInternalService.getAll(Optional.of(criteria.toJson()), Optional.empty());
        Assert.notEmpty((Collection)groups, (String)String.format("No group found for the given unit : %s", userInfo.getUnit()));
        if (!StringUtils.equals((CharSequence)userDto.getGroupId(), (CharSequence)((GroupDto)groups.get(0)).getId())) {
            userUpdate.put("groupId", ((GroupDto)groups.get(0)).getId());
        }
    }

    private void updateUserAddress(UserDto userDto, ProvidedUserDto userInfo, Map<String, Object> userUpdate) {
        if (userInfo.getAddress() != null) {
            HashMap<String, String> updatedAddress = new HashMap<String, String>();
            if (!(userInfo.getAddress().getStreet() == null || userDto.getAddress() != null && StringUtils.equals((CharSequence)userInfo.getAddress().getStreet(), (CharSequence)userDto.getAddress().getStreet()))) {
                updatedAddress.put("street", userInfo.getAddress().getStreet());
            }
            if (!(userInfo.getAddress().getZipCode() == null || userDto.getAddress() != null && StringUtils.equals((CharSequence)userInfo.getAddress().getZipCode(), (CharSequence)userDto.getAddress().getZipCode()))) {
                updatedAddress.put("zipCode", userInfo.getAddress().getZipCode());
            }
            if (!(userInfo.getAddress().getCity() == null || userDto.getAddress() != null && StringUtils.equals((CharSequence)userInfo.getAddress().getCity(), (CharSequence)userDto.getAddress().getCity()))) {
                updatedAddress.put("city", userInfo.getAddress().getCity());
            }
            if (!(userInfo.getAddress().getCountry() == null || userDto.getAddress() != null && StringUtils.equals((CharSequence)userInfo.getAddress().getCountry(), (CharSequence)userDto.getAddress().getCountry()))) {
                updatedAddress.put("country", userInfo.getAddress().getCountry());
            }
            if (!updatedAddress.isEmpty()) {
                userUpdate.put("address", updatedAddress);
            }
        }
    }

    private void createEventsSubrogation(UserDto surrogate, boolean isSubrogation) {
        if (isSubrogation) {
            Subrogation subro = this.subrogationRepository.findOneBySurrogateAndSurrogateCustomerId(surrogate.getEmail(), surrogate.getCustomerId());
            EventType type = surrogate.getType().equals((Object)UserTypeEnum.GENERIC) ? EventType.EXT_VITAMUI_START_SURROGATE_GENERIC : EventType.EXT_VITAMUI_START_SURROGATE_USER;
            this.iamLogbookService.subrogation(subro, type);
        }
    }

    protected Set<String> splitIntoValues(String embedded) {
        HashSet<String> set = new HashSet<String>();
        if (embedded != null) {
            String[] pairs;
            for (String pair : pairs = embedded.split(",")) {
                set.add(pair);
            }
        }
        return set;
    }

    private void generateAndAddAuthToken(AuthUserDto user, boolean isSubrogation, boolean isApi) {
        Token token = new Token();
        token.setRefId(user.getId());
        int ttlInMinutes = isSubrogation && user.getType() == UserTypeEnum.GENERIC ? this.subrogationTokenTtl : (isApi ? this.apiTokenTtl.intValue() : this.tokenTtl.intValue());
        Date currentDate = new Date();
        token.setCreatedDate(currentDate);
        Date nowPlusXMinutes = DateUtils.addMinutes((Date)currentDate, (int)ttlInMinutes);
        token.setUpdatedDate(nowPlusXMinutes);
        token.setId(TICKET_GENERATOR.getNewTicketId(TOKEN_PREFIX));
        token.setSurrogation(isSubrogation);
        this.tokenRepository.save((Object)token);
        user.setLastConnection(OffsetDateTime.now());
        user.setAuthToken(token.getId());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ID).is((Object)user.getId()));
        Update update = Update.update((String)LAST_CONNECTION, (Object)user.getLastConnection());
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, "users");
    }

    public UserDto getUserProfileById(String id) {
        UserDto user = (UserDto)this.internalUserService.getOne(id, Optional.empty());
        if (user == null) {
            throw new NotFoundException(USER_NOT_FOUND_MESSAGE + id);
        }
        this.checkStatus(user.getStatus(), user.getEmail());
        return user;
    }

    public List<SubrogationDto> getSubrogationsBySuperUser(String superUser, String superUserCustomerId) {
        List subrogations = this.subrogationRepository.findBySuperUserAndSuperUserCustomerId(superUser, superUserCustomerId);
        ArrayList<SubrogationDto> dtos = new ArrayList<SubrogationDto>();
        subrogations.forEach(subrogation -> dtos.add(this.convertFromSubrogationToDto(subrogation)));
        return dtos;
    }

    protected final SubrogationDto convertFromSubrogationToDto(Subrogation entity) {
        if (entity != null) {
            return this.internalSubrogationService.internalConvertFromEntityToDto(entity);
        }
        return null;
    }

    @Transactional
    public void deleteSubrogationBySuperUserAndSurrogate(String superUser, String superUserCustomerId, String surrogate, String surrogateCustomerId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{superUser, superUserCustomerId, surrogate, surrogateCustomerId})) {
            throw ApiErrorGenerator.getBadRequestException((Object[])new Object[]{"superUser, superUserCustomerId, surrogate and surrogateCustomerId must be filled"});
        }
        Optional subro = this.subrogationRepository.findBySuperUserAndSuperUserCustomerIdAndSurrogateAndSurrogateCustomerId(superUser, superUserCustomerId, surrogate, surrogateCustomerId);
        if (subro.isPresent()) {
            Subrogation subrogation = (Subrogation)subro.get();
            this.iamLogbookService.subrogation(subrogation, EventType.EXT_VITAMUI_LOGOUT_SURROGATE);
            this.subrogationRepository.deleteById((Object)subrogation.getId());
        }
    }

    public PrincipalFromToken removeTokenAndGetPrincipal(String authToken) {
        Optional optToken = this.tokenRepository.findById((Object)authToken);
        if (optToken.isPresent()) {
            this.tokenRepository.deleteById((Object)authToken);
            Token token = (Token)optToken.get();
            String userId = token.getRefId();
            Optional optionalUser = this.userRepository.findById((Object)userId);
            if (optionalUser.isPresent()) {
                return new PrincipalFromToken(((User)optionalUser.get()).getEmail(), ((User)optionalUser.get()).getCustomerId());
            }
        }
        return null;
    }

    public List<CustomerDto> getCustomersByIds(List<String> customerIds) {
        return this.customerInternalService.getAllById(customerIds);
    }

    @Generated
    public TokenRepository getTokenRepository() {
        return this.tokenRepository;
    }

    @Generated
    public UserInternalService getInternalUserService() {
        return this.internalUserService;
    }

    @Generated
    public UserInfoInternalService getUserInfoInternalService() {
        return this.userInfoInternalService;
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    @Generated
    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Generated
    public SubrogationInternalService getInternalSubrogationService() {
        return this.internalSubrogationService;
    }

    @Generated
    public SubrogationRepository getSubrogationRepository() {
        return this.subrogationRepository;
    }

    @Generated
    public CustomerRepository getCustomerRepository() {
        return this.customerRepository;
    }

    @Generated
    public CustomerInternalService getCustomerInternalService() {
        return this.customerInternalService;
    }

    @Generated
    public TenantInternalService getInternalTenantService() {
        return this.internalTenantService;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }

    @Generated
    public IdentityProviderInternalService getIdentityProviderInternalService() {
        return this.identityProviderInternalService;
    }

    @Generated
    public GroupInternalService getGroupInternalService() {
        return this.groupInternalService;
    }

    @Generated
    public ProvisioningInternalService getProvisioningInternalService() {
        return this.provisioningInternalService;
    }

    @Generated
    public Integer getTokenTtl() {
        return this.tokenTtl;
    }

    @Generated
    public Integer getSubrogationTokenTtl() {
        return this.subrogationTokenTtl;
    }

    @Generated
    public Integer getApiTokenTtl() {
        return this.apiTokenTtl;
    }

    @Generated
    public Integer getTimeIntervalForLoginAttempts() {
        return this.timeIntervalForLoginAttempts;
    }

    @Generated
    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    @Generated
    public PasswordValidator getPasswordValidator() {
        return this.passwordValidator;
    }

    @Generated
    public PasswordConfiguration getPasswordConfiguration() {
        return this.passwordConfiguration;
    }

    @Generated
    public void setTokenRepository(TokenRepository tokenRepository) {
        this.tokenRepository = tokenRepository;
    }

    @Generated
    public void setInternalUserService(UserInternalService internalUserService) {
        this.internalUserService = internalUserService;
    }

    @Generated
    public void setUserInfoInternalService(UserInfoInternalService userInfoInternalService) {
        this.userInfoInternalService = userInfoInternalService;
    }

    @Generated
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Generated
    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    @Generated
    public void setInternalSubrogationService(SubrogationInternalService internalSubrogationService) {
        this.internalSubrogationService = internalSubrogationService;
    }

    @Generated
    public void setSubrogationRepository(SubrogationRepository subrogationRepository) {
        this.subrogationRepository = subrogationRepository;
    }

    @Generated
    public void setCustomerRepository(CustomerRepository customerRepository) {
        this.customerRepository = customerRepository;
    }

    @Generated
    public void setCustomerInternalService(CustomerInternalService customerInternalService) {
        this.customerInternalService = customerInternalService;
    }

    @Generated
    public void setInternalTenantService(TenantInternalService internalTenantService) {
        this.internalTenantService = internalTenantService;
    }

    @Generated
    public void setIamLogbookService(IamLogbookService iamLogbookService) {
        this.iamLogbookService = iamLogbookService;
    }

    @Generated
    public void setIdentityProviderInternalService(IdentityProviderInternalService identityProviderInternalService) {
        this.identityProviderInternalService = identityProviderInternalService;
    }

    @Generated
    public void setGroupInternalService(GroupInternalService groupInternalService) {
        this.groupInternalService = groupInternalService;
    }

    @Generated
    public void setProvisioningInternalService(ProvisioningInternalService provisioningInternalService) {
        this.provisioningInternalService = provisioningInternalService;
    }

    @Generated
    public void setTimeIntervalForLoginAttempts(Integer timeIntervalForLoginAttempts) {
        this.timeIntervalForLoginAttempts = timeIntervalForLoginAttempts;
    }

    @Generated
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Generated
    public void setPasswordValidator(PasswordValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }

    @Generated
    public void setPasswordConfiguration(PasswordConfiguration passwordConfiguration) {
        this.passwordConfiguration = passwordConfiguration;
    }

    @Generated
    public void setTokenTtl(Integer tokenTtl) {
        this.tokenTtl = tokenTtl;
    }

    @Generated
    public void setSubrogationTokenTtl(Integer subrogationTokenTtl) {
        this.subrogationTokenTtl = subrogationTokenTtl;
    }

    @Generated
    public void setApiTokenTtl(Integer apiTokenTtl) {
        this.apiTokenTtl = apiTokenTtl;
    }
}

