/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.application.service;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.ApplicationDto;
import fr.gouv.vitamui.commons.api.domain.Criterion;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.exception.UnAuthorizedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.CriteriaUtils;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.mongo.service.VitamUICrudService;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.internal.server.application.converter.ApplicationConverter;
import fr.gouv.vitamui.iam.internal.server.application.dao.ApplicationRepository;
import fr.gouv.vitamui.iam.internal.server.application.domain.Application;
import fr.gouv.vitamui.iam.internal.server.application.service.ExternalIdentifierConfiguration;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ApplicationInternalService
extends VitamUICrudService<ApplicationDto, Application> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ApplicationInternalService.class);
    private final ApplicationRepository applicationRepository;
    private final ApplicationConverter applicationConverter;
    private final InternalSecurityService internalSecurityService;
    private final ExternalIdentifierConfiguration externalIdentifierConfiguration;

    @Autowired
    public ApplicationInternalService(SequenceGeneratorService sequenceGeneratorService, ApplicationRepository applicationRepository, ApplicationConverter applicationConverter, InternalSecurityService internalSecurityService, ExternalIdentifierConfiguration externalIdentifierConfiguration) {
        super(sequenceGeneratorService);
        this.applicationRepository = applicationRepository;
        this.applicationConverter = applicationConverter;
        this.internalSecurityService = internalSecurityService;
        this.externalIdentifierConfiguration = externalIdentifierConfiguration;
    }

    public List<ApplicationDto> getAll(Optional<String> criteria, Optional<String> embedded) {
        QueryDto queryDto;
        List criterions;
        Optional<Criterion> findFilterApp;
        Boolean filterApp = true;
        if (criteria.isPresent() && (findFilterApp = (criterions = (queryDto = QueryDto.fromJson(criteria)).getCriterionList()).stream().filter(criterion -> "filterApp".equals(criterion.getKey())).findFirst()).isPresent()) {
            Criterion filterAppCriterion = findFilterApp.get();
            filterApp = (Boolean)filterAppCriterion.getValue();
            criterions.remove(filterAppCriterion);
            criteria = Optional.of(CriteriaUtils.toJson((QueryDto)queryDto));
        }
        List apps = super.getAll(criteria, embedded);
        if (filterApp.booleanValue()) {
            this.filterApp((Collection)apps);
        }
        return apps;
    }

    public boolean isApplicationExternalIdentifierEnabled(String applicationId) {
        String tenantId = this.internalSecurityService.getTenantIdentifier().toString();
        Map enabledApplicationsByTenant = this.externalIdentifierConfiguration.getTenants();
        List tenantEnabledApplications = enabledApplicationsByTenant.getOrDefault(tenantId, Collections.emptyList());
        return tenantEnabledApplications.contains(applicationId);
    }

    private void filterApp(Collection<ApplicationDto> apps) {
        AuthUserDto user = this.internalSecurityService.getUser();
        if (user == null) {
            throw new UnAuthorizedException("No authenticated user");
        }
        ArrayList tenantsByApp = user.getTenantsByApp();
        if (CollectionUtils.isEmpty((Collection)user.getTenantsByApp())) {
            tenantsByApp = new ArrayList();
        }
        Collection filter = tenantsByApp.stream().map(p -> p.getName()).collect(Collectors.toList());
        Predicate<ApplicationDto> predicate = a -> !filter.contains(a.getIdentifier());
        apps.removeIf(predicate);
    }

    protected ApplicationRepository getRepository() {
        return this.applicationRepository;
    }

    protected Class<Application> getEntityClass() {
        return Application.class;
    }

    protected Converter<ApplicationDto, Application> getConverter() {
        return this.applicationConverter;
    }

    public Map<String, String> findApplicationByIdentifier(List<String> identifiers) {
        List applications = this.applicationRepository.findAllByIdentifierIn(identifiers);
        return applications.stream().collect(Collectors.toMap(Application::getIdentifier, Application::getName));
    }

    @Generated
    public ApplicationRepository getApplicationRepository() {
        return this.applicationRepository;
    }

    @Generated
    public ApplicationConverter getApplicationConverter() {
        return this.applicationConverter;
    }

    @Generated
    public InternalSecurityService getInternalSecurityService() {
        return this.internalSecurityService;
    }

    @Generated
    public ExternalIdentifierConfiguration getExternalIdentifierConfiguration() {
        return this.externalIdentifierConfiguration;
    }
}

