/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.utils;

import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class ExportCSVUtils {
    public static final byte[] BOM = new byte[]{-17, -69, -65};
    private static final Pattern CSV_FIELD_ESCAPE_REGEX = Pattern.compile("^[-+=@\t\r].*");

    private ExportCSVUtils() {
    }

    public static Resource generateCSVFile(List<String[]> lines, char separator) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8.name());
            outputStream.write(BOM);
            ICSVWriter csvWriter = new CSVWriterBuilder((Writer)writer).withSeparator(separator).withQuoteChar('\"').withEscapeChar('\"').withLineEnd("\n").build();
            lines.forEach(line -> csvWriter.writeNext(ExportCSVUtils.escapeCSVFields(line)));
            csvWriter.close();
            ((Writer)writer).close();
            return new ByteArrayResource(outputStream.toByteArray());
        }
        catch (IOException e) {
            throw new BadRequestException("Unable to generate csv file ", (Throwable)e);
        }
    }

    static String[] escapeCSVFields(String[] fields) {
        return (String[])Arrays.stream(fields).map(field -> field != null && CSV_FIELD_ESCAPE_REGEX.matcher((CharSequence)field).matches() ? "\t" + field : field).toArray(String[]::new);
    }
}

