/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.unit;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.CompareQuery;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.access.UnitService;
import fr.gouv.vitamui.commons.vitam.api.model.UnitTypeEnum;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnitInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UnitInternalService.class);
    private final UnitService unitService;
    private static final String[] FILING_PLAN_PROJECTION = new String[]{"#id", "Title", "DescriptionLevel", "#unitType", "#unitups", "#allunitups", "#opi", "Keyword", "Vtag", "#object", "Title_"};

    @Autowired
    public UnitInternalService(UnitService unitService) {
        this.unitService = unitService;
    }

    public JsonNode searchUnits(JsonNode dslQuery, VitamContext vitamContext) throws VitamClientException {
        LOGGER.info("Unit EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.unitService.searchUnits(dslQuery, vitamContext);
        return response.toJsonNode();
    }

    public JsonNode searchUnitsWithErrors(Optional<String> id, JsonNode dslQuery, VitamContext vitamContext) throws VitamClientException {
        LOGGER.info("Unit EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.unitService.searchUnitsWithErrors(id, dslQuery, vitamContext);
        return response.toJsonNode();
    }

    public JsonNode findUnitById(String unitId, VitamContext vitamContext) throws VitamClientException {
        LOGGER.info("Unit EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        RequestResponse response = this.unitService.findUnitById(unitId, vitamContext);
        return response.toJsonNode();
    }

    public JsonNode findObjectMetadataById(String unitId, JsonNode dslQuery, VitamContext vitamContext) throws VitamClientException {
        RequestResponse response = this.unitService.findObjectMetadataById(unitId, dslQuery, vitamContext);
        return response.toJsonNode();
    }

    public JsonNode createQueryForFillingOrHoldingUnit() {
        try {
            SelectMultiQuery select = new SelectMultiQuery();
            InQuery query = QueryHelper.in((String)VitamFieldsHelper.unitType(), (String[])new String[]{UnitTypeEnum.HOLDING_UNIT.getValue(), UnitTypeEnum.FILING_UNIT.getValue()});
            select.addQueries(new Query[]{query});
            select.addUsedProjection(FILING_PLAN_PROJECTION);
            LOGGER.debug("query =", (Object)select.getFinalSelect().toPrettyString());
            return select.getFinalSelect();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new UnexpectedDataException("Unexpected error occured while building holding dsl query : " + e.getMessage());
        }
    }

    public JsonNode createQueryForUnitById(String unitId) {
        try {
            SelectMultiQuery select = new SelectMultiQuery();
            CompareQuery query = QueryHelper.eq((String)VitamFieldsHelper.id(), (String)unitId);
            select.addQueries(new Query[]{query});
            LOGGER.debug("query =", (Object)select.getFinalSelect().toPrettyString());
            return select.getFinalSelect();
        }
        catch (InvalidCreateOperationException e) {
            throw new UnexpectedDataException("Unexpected error occured while building dsl query : " + e.getMessage());
        }
    }
}

