/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.service;

import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.ParameterDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.internal.client.ExternalParametersInternalRestClient;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalParametersService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ExternalParametersService.class);
    public static final String PARAM_BULK_OPERATIONS_THRESHOLD_NAME = "PARAM_BULK_OPERATIONS_THRESHOLD";
    public static final String PARAM_ACCESS_CONTRACT_NAME = "PARAM_ACCESS_CONTRACT";
    private final ExternalParametersInternalRestClient externalParametersInternalRestClient;
    private final InternalSecurityService securityService;

    @Autowired
    public ExternalParametersService(ExternalParametersInternalRestClient externalParametersInternalRestClient, InternalSecurityService securityService) {
        this.externalParametersInternalRestClient = externalParametersInternalRestClient;
        this.securityService = securityService;
    }

    public String retrieveAccessContractFromExternalParam() {
        ExternalParametersDto myExternalParameter = this.externalParametersInternalRestClient.getMyExternalParameters(this.securityService.getHttpContext());
        if (myExternalParameter == null || CollectionUtils.isEmpty((Collection)myExternalParameter.getParameters())) {
            throw new IllegalArgumentException("No external profile defined for access contract defined");
        }
        ParameterDto parameterAccessContract = myExternalParameter.getParameters().stream().filter(parameter -> PARAM_ACCESS_CONTRACT_NAME.equals(parameter.getKey())).findFirst().orElse(null);
        if (Objects.isNull(parameterAccessContract) || Objects.isNull(parameterAccessContract.getValue())) {
            throw new IllegalArgumentException("No access contract defined");
        }
        return parameterAccessContract.getValue();
    }

    public VitamContext buildVitamContextFromExternalParam() {
        return new VitamContext(this.securityService.getTenantIdentifier()).setAccessContract(this.retrieveAccessContractFromExternalParam()).setApplicationSessionId(this.securityService.getApplicationId());
    }

    public Optional<Long> retrieveProfilThreshold() {
        ParameterDto parameterThreshold;
        Optional<Long> thresholdOpt = Optional.empty();
        ExternalParametersDto myExternalParameter = this.externalParametersInternalRestClient.getMyExternalParameters(this.securityService.getHttpContext());
        if (CollectionUtils.isNotEmpty((Collection)myExternalParameter.getParameters()) && (parameterThreshold = (ParameterDto)myExternalParameter.getParameters().stream().filter(parameter -> PARAM_BULK_OPERATIONS_THRESHOLD_NAME.equals(parameter.getKey())).findFirst().orElse(null)) != null && parameterThreshold.getValue() != null) {
            try {
                Long thresholdValue = Long.valueOf(parameterThreshold.getValue());
                thresholdOpt = Optional.of(thresholdValue);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("external parameter of bulk threshold contains wrong integer value {}, it will not be used ", (Object)parameterThreshold.getValue());
                throw new IllegalArgumentException("external parameter of bulk threshold contains wrong integer value " + parameterThreshold.getValue() + ", it will not be used ");
            }
        }
        return thresholdOpt;
    }
}

