/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.schema;

import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.SchemaDto;
import fr.gouv.vitamui.referential.internal.server.schema.SchemaLoadingException;
import fr.gouv.vitamui.referential.internal.server.schema.SchemaModelToSchemaElementDtoConverter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SchemaService {
    private static final VitamUILogger log = VitamUILoggerFactory.getInstance(SchemaService.class);
    private final InternalSecurityService internalSecurityService;
    private final AdminExternalClient adminExternalClient;

    @Autowired
    public SchemaService(InternalSecurityService internalSecurityService, AdminExternalClient adminExternalClient) {
        this.internalSecurityService = internalSecurityService;
        this.adminExternalClient = adminExternalClient;
    }

    public Optional<SchemaDto> getSchema(fr.gouv.vitamui.referential.common.model.Collection collection) {
        try {
            RequestResponse<SchemaResponse> payload = this.getSchemaModels(collection).orElseThrow();
            List schemaModels = ((RequestResponseOK)payload).getResults();
            SchemaModelToSchemaElementDtoConverter converter = new SchemaModelToSchemaElementDtoConverter();
            SchemaDto schemaDto = new SchemaDto();
            schemaDto.addAll((Collection)schemaModels.stream().map(converter::convert).collect(Collectors.toList()));
            return Optional.of(schemaDto);
        }
        catch (VitamClientException e) {
            throw new SchemaLoadingException(e);
        }
    }

    public List<SchemaDto> getSchemas(Set<fr.gouv.vitamui.referential.common.model.Collection> collections) {
        return collections.stream().map(this::getSchema).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<RequestResponse<SchemaResponse>> getSchemaModels(fr.gouv.vitamui.referential.common.model.Collection collection) throws VitamClientException {
        VitamContext vitamContext = this.internalSecurityService.getVitamContext();
        if (Objects.equals(collection, fr.gouv.vitamui.referential.common.model.Collection.ARCHIVE_UNIT)) {
            return Optional.of(this.adminExternalClient.getUnitSchema(vitamContext));
        }
        if (Objects.equals(collection, fr.gouv.vitamui.referential.common.model.Collection.OBJECT_GROUP)) {
            return Optional.of(this.adminExternalClient.getObjectGroupSchema(vitamContext));
        }
        return Optional.empty();
    }
}

