/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.schema;

import fr.gouv.vitamui.referential.common.dto.SchemaDto;
import fr.gouv.vitamui.referential.common.exception.NoCollectionException;
import fr.gouv.vitamui.referential.common.model.Collection;
import fr.gouv.vitamui.referential.internal.server.schema.SchemaService;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/schemas"})
public class SchemaController {
    private final SchemaService schemaService;

    @Autowired
    public SchemaController(SchemaService schemaService) {
        this.schemaService = schemaService;
    }

    @GetMapping
    @Produces(value={"application/json"})
    public ResponseEntity<List<SchemaDto>> getSchemas(@RequestParam Set<Collection> collections) throws NoCollectionException {
        if (CollectionUtils.isEmpty(collections)) {
            throw new NoCollectionException();
        }
        return ResponseEntity.ok(this.schemaService.getSchemas(collections));
    }
}

