/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalNotFoundException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.ProfileDto;
import fr.gouv.vitamui.referential.internal.server.profile.ProfileInternalService;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import javax.validation.Valid;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/profile"})
public class ProfileInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProfileInternalController.class);
    @Autowired
    private ProfileInternalService profileInternalService;
    @Autowired
    private InternalSecurityService securityService;

    @GetMapping
    public Collection<ProfileDto> getAll(@RequestParam Optional<String> criteria) {
        LOGGER.debug("get all archive profiles criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.profileInternalService.getAll(vitamContext);
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<ProfileDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.profileInternalService.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    @GetMapping(path={"/{identifier:.+}"})
    public ProfileDto getOne(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException {
        LOGGER.debug("get profile identifier={} / {}", (Object)identifier, (Object)URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.profileInternalService.getOne(vitamContext, URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
    }

    @GetMapping(value={"/download/{id}"})
    public ResponseEntity<Resource> downloadByMetadataIdentifier(@PathVariable(value="id") String id) throws AccessExternalNotFoundException, AccessExternalClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.debug("download profile with id :{}", (Object)id);
        Response response = this.profileInternalService.download(vitamContext, id);
        Object entity = response.getEntity();
        if (entity instanceof InputStream) {
            InputStreamResource resource = new InputStreamResource((InputStream)entity);
            return new ResponseEntity((Object)resource, HttpStatus.OK);
        }
        return null;
    }

    @PutMapping(value={"/updateProfileFile/{id}"})
    public JsonNode updateProfileFile(@PathVariable(value="id") String id, @RequestParam(value="file") MultipartFile file) throws AccessExternalClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"profileFile stream is a mandatory parameter: ", (Object[])new Object[]{file});
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Update {}  profile file with id :{}", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.profileInternalService.updateProfileFile(vitamContext, id, file);
    }

    @PutMapping(value={"/{id}"})
    public JsonNode updateProfile(@PathVariable(value="id") String id, @Valid @RequestBody ProfileDto dto) throws PreconditionFailedException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.debug("context={}", (Object)vitamContext);
        return this.profileInternalService.updateProfile(dto, vitamContext);
    }

    @PostMapping
    public ProfileDto create(@Valid @RequestBody ProfileDto archivalProfile, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException {
        SanityChecker.sanitizeCriteria((Object)archivalProfile);
        LOGGER.debug("create profile={}", (Object)archivalProfile);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        archivalProfile.setTenant(vitamContext.getTenantId());
        return this.profileInternalService.create(vitamContext, archivalProfile);
    }

    @PostMapping(value={"/import"})
    public ResponseEntity<JsonNode> importProfile(@RequestParam(value="fileName") String fileName, @RequestParam(value="file") MultipartFile file) {
        LOGGER.debug("import profile by a file {}", (Object)fileName);
        SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.profileInternalService.importProfile(vitamContext, fileName, file);
    }

    @Secured(value={"ROLE_GET_PASTIS"})
    @PostMapping(value={"/check"})
    public ResponseEntity<Void> checkProfileIdExist(@RequestBody ProfileDto profileDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException {
        SanityChecker.sanitizeCriteria((Object)profileDto);
        LOGGER.debug("check if profile exist with id : {}", (Object)profileDto.getIdentifier());
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        boolean exist = this.profileInternalService.checkProfileIdExist(vitamContext, profileDto.getIdentifier());
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @Generated
    public ProfileInternalService getProfileInternalService() {
        return this.profileInternalService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public void setProfileInternalService(ProfileInternalService profileInternalService) {
        this.profileInternalService = profileInternalService;
    }

    @Generated
    public void setSecurityService(InternalSecurityService securityService) {
        this.securityService = securityService;
    }
}

