/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.OntologyDto;
import fr.gouv.vitamui.referential.internal.server.ontology.OntologyInternalService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/ontology"})
public class OntologyInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OntologyInternalController.class);
    @Autowired
    private OntologyInternalService ontologyInternalService;
    @Autowired
    private InternalSecurityService securityService;

    @GetMapping
    public Collection<OntologyDto> getAll(@RequestParam Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("get all ontology criteria={}", criteria);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.ontologyInternalService.getAll(vitamContext);
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<OntologyDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.ontologyInternalService.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    @PostMapping
    public OntologyDto create(@Valid @RequestBody OntologyDto ontologyDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)ontologyDto);
        LOGGER.debug("create ontology={}", (Object)ontologyDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        ontologyDto.setTenant(tenant);
        return this.ontologyInternalService.create(vitamContext, ontologyDto);
    }

    @GetMapping(path={"/{identifier:.+}"})
    public OntologyDto getOne(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{identifier});
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("get ontology identifier={} / {}", (Object)identifier, (Object)URLDecoder.decode(identifier, StandardCharsets.UTF_8));
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.ontologyInternalService.getOne(vitamContext, URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
    }

    @PostMapping(value={"/check"})
    public ResponseEntity<Void> checkExist(@RequestBody OntologyDto ontologyDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException {
        SanityChecker.sanitizeCriteria((Object)ontologyDto);
        LOGGER.debug("check exist accessContract={}", (Object)ontologyDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        ontologyDto.setTenant(tenant);
        boolean exist = this.ontologyInternalService.check(vitamContext, ontologyDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PatchMapping(value={"/{id}"})
    public OntologyDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.ontologyInternalService.patch(vitamContext, partialDto);
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Delete {}", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        this.ontologyInternalService.delete(vitamContext, id);
    }

    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.debug("get logbook for ontology with id :{}", (Object)id);
        return this.ontologyInternalService.findHistoryByIdentifier(vitamContext, id);
    }

    @PostMapping(value={"/import"})
    public JsonNode importOntology(@RequestParam(value="fileName") String fileName, @RequestParam(value="file") MultipartFile file) throws PreconditionFailedException {
        SanityChecker.isValidFileName((String)fileName);
        LOGGER.debug("import ontology file {}", (Object)fileName);
        SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.ontologyInternalService.importOntologies(vitamContext, fileName, file);
    }

    @GetMapping(value={"/internal-ontologies"})
    public List<VitamUiOntologyDto> getInternalOntologyList() throws IOException {
        LOGGER.debug("[INTERNAL] : Get all default internal ontology fields");
        return this.ontologyInternalService.readInternalOntologyFromFile();
    }

    @Generated
    public OntologyInternalService getOntologyInternalService() {
        return this.ontologyInternalService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public void setOntologyInternalService(OntologyInternalService ontologyInternalService) {
        this.ontologyInternalService = ontologyInternalService;
    }

    @Generated
    public void setSecurityService(InternalSecurityService securityService) {
        this.securityService = securityService;
    }
}

