/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.IngestContractDto;
import fr.gouv.vitamui.referential.internal.server.ingestcontract.IngestContractInternalService;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/ingestcontract"})
public class IngestContractInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IngestContractInternalController.class);
    @Autowired
    private IngestContractInternalService ingestContractInternalService;
    @Autowired
    private InternalSecurityService securityService;

    @GetMapping
    public Collection<IngestContractDto> getAll(@RequestParam Optional<String> criteria) {
        LOGGER.debug("get all ingestContract criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.ingestContractInternalService.getAll(vitamContext);
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<IngestContractDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        LOGGER.debug("getPaginateEntities ingestContract page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.ingestContractInternalService.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    @GetMapping(path={"/{identifier:.+}"})
    public IngestContractDto getOne(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException {
        LOGGER.debug("get ingestContract identifier={} / {}", (Object)identifier, (Object)URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{identifier});
        return this.ingestContractInternalService.getOne(vitamContext, URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
    }

    @PostMapping(value={"/check"})
    public ResponseEntity<Void> checkExist(@RequestBody IngestContractDto ingestContractDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        LOGGER.debug("check exist ingestContract={}", (Object)ingestContractDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        ingestContractDto.setTenant(tenant);
        boolean exist = this.ingestContractInternalService.check(vitamContext, ingestContractDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PostMapping
    public IngestContractDto create(@Valid @RequestBody IngestContractDto ingestContractDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        LOGGER.debug("create ingestContract={}", (Object)ingestContractDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        ingestContractDto.setTenant(tenant);
        return this.ingestContractInternalService.create(vitamContext, ingestContractDto);
    }

    @PutMapping(value={"/{id}"})
    public IngestContractDto update(@PathVariable(value="id") String id, @Valid @RequestBody IngestContractDto dto) {
        return null;
    }

    @PatchMapping(value={"/{id}"})
    public IngestContractDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) {
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.ingestContractInternalService.patch(vitamContext, partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.debug("get logbook for ingestContract with id :{}", (Object)id);
        return this.ingestContractInternalService.findHistoryByIdentifier(vitamContext, id);
    }

    @PostMapping(value={"/import"})
    public ResponseEntity<Void> importIngestContracts(@RequestParam(value="fileName") String fileName, @RequestParam(value="file") MultipartFile file) {
        LOGGER.debug("importing ingest contracts file {}", (Object)fileName);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.ingestContractInternalService.importIngestContracts(vitamContext, file);
    }

    @ApiOperation(value="Export ingest contracts to a csv file")
    @GetMapping(path={"/export-csv"})
    public ResponseEntity<Resource> exportIngestContracts() throws IOException {
        LOGGER.debug("export all ingest contracts to csv file");
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        Resource exportedResult = this.ingestContractInternalService.exportIngestContracts(vitamContext);
        return new ResponseEntity((Object)exportedResult, HttpStatus.OK);
    }

    @Generated
    public IngestContractInternalService getIngestContractInternalService() {
        return this.ingestContractInternalService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public void setIngestContractInternalService(IngestContractInternalService ingestContractInternalService) {
        this.ingestContractInternalService = ingestContractInternalService;
    }

    @Generated
    public void setSecurityService(InternalSecurityService securityService) {
        this.securityService = securityService;
    }
}

