/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.ArchivalProfileUnitDto;
import fr.gouv.vitamui.referential.internal.server.archivalprofileunit.ArchivalProfileUnitInternalService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/archival-profile"})
public class ArchivalProfileUnitInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchivalProfileUnitInternalController.class);
    @Autowired
    private ArchivalProfileUnitInternalService archivalProfileUnitInternalService;
    @Autowired
    private InternalSecurityService securityService;

    @GetMapping
    public Collection<ArchivalProfileUnitDto> getAll(@RequestParam Optional<String> criteria) {
        LOGGER.debug("get all archival unit profiles criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.debug("context={}", (Object)vitamContext);
        return this.archivalProfileUnitInternalService.getAll(vitamContext);
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<ArchivalProfileUnitDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.archivalProfileUnitInternalService.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    @GetMapping(path={"/{identifier:.+}"})
    public ArchivalProfileUnitDto getOne(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{identifier});
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("get archival unit profile identifier={} / {}", (Object)identifier, (Object)URLDecoder.decode(identifier, StandardCharsets.UTF_8));
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.archivalProfileUnitInternalService.getOne(vitamContext, URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
    }

    @PutMapping(value={"/{id}"})
    public ArchivalProfileUnitDto update(@PathVariable(value="id") String id, @RequestBody ArchivalProfileUnitDto dto) throws InvalidParseOperationException, AccessExternalClientException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.debug("context={}", (Object)vitamContext);
        return this.archivalProfileUnitInternalService.update(dto, vitamContext);
    }

    @PostMapping
    public ArchivalProfileUnitDto create(@Valid @RequestBody ArchivalProfileUnitDto archivalUnitProfile, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)archivalUnitProfile);
        LOGGER.debug("create archival unit profile={}", (Object)archivalUnitProfile);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        archivalUnitProfile.setTenant(Integer.valueOf(0));
        return this.archivalProfileUnitInternalService.create(vitamContext, archivalUnitProfile);
    }

    @PostMapping(value={"/import"})
    public ResponseEntity<JsonNode> importArchivalUnitProfile(@RequestParam(value="fileName") String fileName, @RequestParam(value="file") MultipartFile file) throws PreconditionFailedException {
        SanityChecker.isValidFileName((String)fileName);
        LOGGER.debug("import Archival Unit Profile by a file {}", (Object)fileName);
        SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.archivalProfileUnitInternalService.importProfile(vitamContext, fileName, file);
    }

    @PostMapping(value={"/check"})
    public ResponseEntity<Void> checkExist(@RequestBody ArchivalProfileUnitDto archivalProfile, @RequestHeader(value="X-Tenant-Id") Integer tenant) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)archivalProfile);
        LOGGER.debug("check exist file format={}", (Object)archivalProfile);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        boolean exist = this.archivalProfileUnitInternalService.check(vitamContext, archivalProfile);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @Generated
    public ArchivalProfileUnitInternalService getArchivalProfileUnitInternalService() {
        return this.archivalProfileUnitInternalService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public void setArchivalProfileUnitInternalService(ArchivalProfileUnitInternalService archivalProfileUnitInternalService) {
        this.archivalProfileUnitInternalService = archivalProfileUnitInternalService;
    }

    @Generated
    public void setSecurityService(InternalSecurityService securityService) {
        this.securityService = securityService;
    }
}

