/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.rest;

import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.AccessionRegisterSearchDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterDetailDto;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterSummaryDto;
import fr.gouv.vitamui.referential.internal.server.accessionregister.AccessionRegisterInternalService;
import java.util.Collection;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referential/v1/accession-register"})
public class AccessionRegisterInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessionRegisterInternalController.class);
    private final AccessionRegisterInternalService detailInternalService;
    private final InternalSecurityService securityService;

    public AccessionRegisterInternalController(AccessionRegisterInternalService accessionRegisterInternalService, InternalSecurityService securityService) {
        this.detailInternalService = accessionRegisterInternalService;
        this.securityService = securityService;
    }

    @GetMapping(value={"/summary"})
    public Collection<AccessionRegisterSummaryDto> getAll(@RequestParam Optional<String> criteria, @RequestHeader(value="X-Access-Contract-Id") String accessContractId) {
        LOGGER.debug("get all customer criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier(), accessContractId);
        return this.detailInternalService.getAll(vitamContext);
    }

    @GetMapping(value={"/details"}, params={"page", "size"})
    public PaginatedValuesDto<AccessionRegisterDetailDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        LOGGER.debug("getPaginateEntities accession registers page={}, size={}, orderBy={}, direction={}, criteria={}", new Object[]{page, size, orderBy, direction, criteria});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.detailInternalService.getAllPaginated(criteria, page, size, orderBy.orElse(null), direction.orElse(null), vitamContext);
    }

    @PostMapping(value={"/details/export-csv"})
    public ResponseEntity<Resource> exportCsvArchiveUnitsByCriteria(@RequestHeader(value="X-Tenant-Id") Integer tenantId, @RequestHeader(value="X-Access-Contract-Id") String accessContractId, @RequestBody AccessionRegisterSearchDto searchQuery) {
        LOGGER.info("Export to CSV of accession register details {}", (Object)searchQuery);
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantId, accessContractId);
        Resource exportedResult = this.detailInternalService.exportToCsvAccessionRegister(searchQuery, vitamContext);
        return new ResponseEntity((Object)exportedResult, HttpStatus.OK);
    }
}

