/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.AccessContractDto;
import fr.gouv.vitamui.referential.internal.server.accesscontract.AccessContractInternalService;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/accesscontracts"})
public class AccessContractInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessContractInternalController.class);
    @Autowired
    private AccessContractInternalService accessContractInternalService;
    @Autowired
    private InternalSecurityService securityService;

    @GetMapping
    public Collection<AccessContractDto> getAll(@RequestParam Optional<String> criteria) {
        LOGGER.debug("get all accessContract criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.accessContractInternalService.getAll(vitamContext);
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<AccessContractDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        LOGGER.debug("getPaginateEntities accessContract page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.accessContractInternalService.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    @GetMapping(path={"/{identifier:.+}"})
    public AccessContractDto getOne(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException {
        LOGGER.debug("get accessContract identifier={} / {}", (Object)identifier, (Object)URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.accessContractInternalService.getOne(vitamContext, URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
    }

    @PostMapping(value={"/check"})
    public ResponseEntity<Void> checkExist(@RequestBody AccessContractDto accessContractDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        LOGGER.debug("check exist accessContract={}", (Object)accessContractDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        accessContractDto.setTenant(tenant);
        boolean exist = this.accessContractInternalService.check(vitamContext, accessContractDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PostMapping
    public AccessContractDto create(@Valid @RequestBody AccessContractDto accessContractDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        LOGGER.debug("create accessContract={}", (Object)accessContractDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        accessContractDto.setTenant(tenant);
        return this.accessContractInternalService.create(vitamContext, accessContractDto);
    }

    @PatchMapping(value={"/{id}"})
    public AccessContractDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) {
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.accessContractInternalService.patch(vitamContext, partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException {
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.debug("get logbook for accessContract with id :{}", (Object)id);
        return this.accessContractInternalService.findHistoryByIdentifier(vitamContext, id);
    }

    @PostMapping(value={"/import"})
    public ResponseEntity<Void> importAccessContracts(@RequestParam(value="fileName") String fileName, @RequestParam(value="file") MultipartFile file) {
        LOGGER.debug("importing access contracts file {}", (Object)fileName);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.accessContractInternalService.importAccessContracts(vitamContext, file);
    }

    @ApiOperation(value="Export access contract to a csv file")
    @GetMapping(path={"/export-csv"})
    public ResponseEntity<Resource> exportAccessContracts() throws IOException {
        LOGGER.debug("export all access contract to csv file");
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        Resource exportedResult = this.accessContractInternalService.exportAccessContracts(vitamContext);
        return new ResponseEntity((Object)exportedResult, HttpStatus.OK);
    }

    @Generated
    public AccessContractInternalService getAccessContractInternalService() {
        return this.accessContractInternalService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public void setAccessContractInternalService(AccessContractInternalService accessContractInternalService) {
        this.accessContractInternalService = accessContractInternalService;
    }

    @Generated
    public void setSecurityService(InternalSecurityService securityService) {
        this.securityService = securityService;
    }
}

