/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.profile;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientServerException;
import fr.gouv.vitam.access.external.common.exception.AccessExternalNotFoundException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.ProfileModel;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.ProfileDto;
import fr.gouv.vitamui.referential.common.dto.ProfileResponseDto;
import fr.gouv.vitamui.referential.common.service.VitamProfileService;
import fr.gouv.vitamui.referential.internal.server.profile.ProfileConverter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProfileInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProfileInternalService.class);
    private ObjectMapper objectMapper;
    private ProfileConverter converter;
    private VitamProfileService vitamProfileService;
    private InternalSecurityService internalSecurityService;

    @Autowired
    public ProfileInternalService(ObjectMapper objectMapper, ProfileConverter converter, VitamProfileService vitamProfileService) {
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.vitamProfileService = vitamProfileService;
    }

    public List<ProfileDto> getAll(VitamContext vitamContext) {
        try {
            LOGGER.info("All Profiles EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamProfileService.findArchivalProfiles(vitamContext, (JsonNode)new Select().getFinalSelect());
            ProfileResponseDto profileResponseDto = (ProfileResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ProfileResponseDto.class);
            return this.converter.convertVitamsToDtos(profileResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find Profiles", e);
        }
    }

    public ProfileDto getOne(VitamContext vitamContext, String identifier) {
        try {
            LOGGER.info("Archival Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamProfileService.findArchivalProfileById(vitamContext, identifier);
            ProfileResponseDto profileResponseDto = (ProfileResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ProfileResponseDto.class);
            if (profileResponseDto.getResults().size() == 0) {
                return null;
            }
            return this.converter.convertVitamToDto((ProfileModel)profileResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get ArchivalProfile", e);
        }
    }

    public PaginatedValuesDto<ProfileDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        LOGGER.info("All Archival Profiles EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        Map vitamCriteria = new HashMap();
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find archivalProfiles with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        ProfileResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<ProfileDto> valuesDto = this.converter.convertVitamsToDtos(results.getResults());
        LOGGER.debug("Profiles in page: {}", valuesDto);
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    public Response download(VitamContext context, String id) throws AccessExternalNotFoundException, AccessExternalClientException {
        try {
            LOGGER.info("Download EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
            return this.vitamProfileService.downloadProfile(context, id);
        }
        catch (AccessExternalClientServerException | VitamClientException e) {
            throw new InternalServerException("Unable to download Profile operation report", e);
        }
    }

    public JsonNode updateProfileFile(VitamContext context, String id, MultipartFile file) throws AccessExternalClientException {
        try {
            LOGGER.info("Upload Profile File EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
            return this.vitamProfileService.updateProfileFile(context, id, file).toJsonNode();
        }
        catch (AccessExternalClientServerException | InvalidParseOperationException | IOException e) {
            throw new InternalServerException("Unable to Upload profile file", e);
        }
    }

    public JsonNode updateProfile(ProfileDto dto, VitamContext vitamContext) {
        String id = dto.getIdentifier();
        if (id == null) {
            throw new BadRequestException("id must be one the update criteria");
        }
        LOGGER.info("Update Archival Profile EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        JsonNode fieldsUpdated = this.convertMapDtoToUpperCaseVitamFields(dto);
        ObjectNode action = JsonHandler.createObjectNode();
        action.set("$set", fieldsUpdated);
        ArrayNode actions = JsonHandler.createArrayNode();
        actions.add((JsonNode)action);
        ObjectNode query = JsonHandler.createObjectNode();
        query.set("$action", (JsonNode)actions);
        try {
            Object firstResult;
            RequestResponse requestResponse = this.vitamProfileService.updateProfile(vitamContext, id, (JsonNode)query);
            List results = ((RequestResponseOK)requestResponse).getResults();
            if (CollectionUtils.isNotEmpty((Collection)results) && Objects.nonNull(firstResult = results.get(0))) {
                return ((JsonNode)firstResult).get("diffs");
            }
            return null;
        }
        catch (AccessExternalClientException e) {
            throw new InternalServerException("Can't update Archival Profile", (Throwable)e);
        }
    }

    private JsonNode convertMapDtoToUpperCaseVitamFields(ProfileDto dto) {
        ObjectNode propertiesToUpdate = JsonHandler.createObjectNode();
        if (dto.getName() != null) {
            propertiesToUpdate.put("Name", dto.getName());
        }
        if (dto.getDescription() != null) {
            propertiesToUpdate.put("Description", dto.getDescription());
        }
        if (dto.getStatus() != null) {
            propertiesToUpdate.put("Status", dto.getStatus().toString());
        }
        if (dto.getFormat() != null) {
            propertiesToUpdate.put("Format", dto.getFormat().toString());
        }
        if (dto.getPath() != null) {
            propertiesToUpdate.put("Path", dto.getPath());
        }
        if (dto.getCreationDate() != null) {
            propertiesToUpdate.put("CreationDate", dto.getCreationDate());
        }
        if (dto.getLastUpdate() != null) {
            propertiesToUpdate.put("LastUpdate", dto.getLastUpdate());
        }
        if (dto.getActivationDate() != null) {
            propertiesToUpdate.put("ActivationDate", dto.getActivationDate());
        }
        if (dto.getDeactivationDate() != null) {
            propertiesToUpdate.put("DeactivationDate", dto.getDeactivationDate());
        }
        return propertiesToUpdate;
    }

    public ProfileDto create(VitamContext context, ProfileDto archivalProfileDto) {
        LOGGER.debug("Try to create profile {} {}", (Object)archivalProfileDto, (Object)context);
        try {
            LOGGER.info("Create Profile EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamProfileService.create(context, this.converter.convertDtoToVitam(archivalProfileDto));
            if (requestResponse.isOk()) {
                ProfileModel archivalProfileVitamDto = (ProfileModel)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode().get("$results").get(0), ProfileModel.class);
                return this.converter.convertVitamToDto(archivalProfileVitamDto);
            }
            return null;
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException | JAXBException exception) {
            LOGGER.error("Error while creating archive Profile", exception);
            return null;
        }
    }

    public ResponseEntity<JsonNode> importProfile(VitamContext vitamContext, String fileName, MultipartFile file) {
        try {
            RequestResponse response = this.vitamProfileService.importProfileByFile(vitamContext, fileName, file);
            if (response.isOk()) {
                return ResponseEntity.ok((Object)response.toJsonNode());
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            LOGGER.error("Unable to import archival profile by file {}: {}", (Object)fileName, (Object)e.getMessage());
            throw new InternalServerException("Unable to import archival profile by file " + fileName + " : ", e);
        }
    }

    private ProfileResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            LOGGER.info("All Archival Profiles EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamProfileService.findArchivalProfiles(vitamContext, query);
            ProfileResponseDto archivalProfileResponseDto = (ProfileResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ProfileResponseDto.class);
            LOGGER.debug("Profiles: {}", (Object)archivalProfileResponseDto);
            return archivalProfileResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find archivalProfiles", e);
        }
    }

    public boolean checkProfileIdExist(VitamContext vitamContext, String identifier) {
        try {
            return Objects.nonNull(this.getOne(vitamContext, identifier));
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }
}

