/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.ontology;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.OntologyOrigin;
import fr.gouv.vitam.common.model.administration.OntologyType;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.OntologyServiceReader;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.OntologyDto;
import fr.gouv.vitamui.referential.common.dto.OntologyResponseDto;
import fr.gouv.vitamui.referential.common.service.OntologyService;
import fr.gouv.vitamui.referential.internal.server.ontology.OntologyConverter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OntologyInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OntologyInternalService.class);
    private OntologyService ontologyService;
    private ObjectMapper objectMapper;
    private OntologyConverter converter;
    private LogbookService logbookService;
    @Value(value="${internal_ontology_file_path}")
    private String internalOntologieFilePath;

    @Autowired
    public OntologyInternalService(OntologyService ontologyService, ObjectMapper objectMapper, OntologyConverter converter, LogbookService logbookService) {
        this.ontologyService = ontologyService;
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.logbookService = logbookService;
    }

    public OntologyDto getOne(VitamContext vitamContext, String identifier) {
        try {
            RequestResponse requestResponse = this.ontologyService.findOntologyById(vitamContext, identifier);
            OntologyResponseDto accessContractResponseDto = (OntologyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), OntologyResponseDto.class);
            if (accessContractResponseDto.getResults().size() == 0) {
                return null;
            }
            return this.converter.convertVitamToDto((OntologyModel)accessContractResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Ontology", e);
        }
    }

    public List<OntologyDto> getAll(VitamContext vitamContext) {
        try {
            RequestResponse requestResponse = this.ontologyService.findOntologies(vitamContext, (JsonNode)new Select().getFinalSelect());
            OntologyResponseDto ontologyResponseDto = (OntologyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), OntologyResponseDto.class);
            return this.converter.convertVitamsToDtos(ontologyResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find ontologies", e);
        }
    }

    public PaginatedValuesDto<OntologyDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        Map vitamCriteria = new HashMap();
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find ontologies with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        OntologyResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<OntologyDto> valuesDto = this.converter.convertVitamsToDtos(results.getResults());
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    private OntologyResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            RequestResponse requestResponse = this.ontologyService.findOntologies(vitamContext, query);
            OntologyResponseDto ontologyResponseDto = (OntologyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), OntologyResponseDto.class);
            return ontologyResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find ontologies", e);
        }
    }

    public Boolean check(VitamContext vitamContext, OntologyDto ontologyDto) {
        try {
            return !this.ontologyService.checkAbilityToCreateOntologyInVitam(this.converter.convertDtosToVitams(Arrays.asList(ontologyDto)), vitamContext);
        }
        catch (ConflictException e) {
            return true;
        }
    }

    public OntologyDto create(VitamContext context, OntologyDto ontologyDto) {
        List<OntologyDto> ontologies = this.getAll(context);
        ontologyDto.setOrigin(OntologyOrigin.EXTERNAL);
        ontologies.add(ontologyDto);
        try {
            RequestResponse requestResponse = this.ontologyService.importOntologies(context, this.converter.convertDtosToVitams(ontologies));
            VitamRestUtils.checkResponse((RequestResponse)requestResponse, (Integer[])new Integer[0]);
            OntologyResponseDto ontologyResponseDto = (OntologyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), OntologyResponseDto.class);
            List<OntologyDto> ontologyDtos = this.converter.convertVitamsToDtos(ontologyResponseDto.getResults());
            return ontologyDtos == null || ontologyDtos.isEmpty() ? ontologyDto : ontologyDtos.get(0);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            throw new InternalServerException("Unable to create ontology", e);
        }
    }

    public void delete(VitamContext context, String identifier) {
        List<OntologyDto> ontologies = this.getAll(context);
        try {
            RequestResponse requestResponse = this.ontologyService.importOntologies(context, this.converter.convertDtosToVitams(ontologies.stream().filter(ontologyDto -> !ontologyDto.getId().equals(identifier) || !OntologyOrigin.EXTERNAL.equals((Object)ontologyDto.getOrigin())).collect(Collectors.toList())));
            VitamRestUtils.checkResponse((RequestResponse)requestResponse, (Integer[])new Integer[0]);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            throw new InternalServerException("Unable to delete ontology", e);
        }
    }

    public OntologyDto patch(VitamContext vitamContext, Map<String, Object> partialDto) {
        OntologyDto ontologyDto = this.getOne(vitamContext, (String)partialDto.get("identifier"));
        partialDto.forEach((key, value) -> {
            if ("type".equals(key)) {
                ontologyDto.setType(OntologyType.valueOf((String)((String)value)));
            } else if (!"id".equals(key)) {
                try {
                    BeanUtilsBean.getInstance().copyProperty((Object)ontologyDto, key, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new InternalServerException("Unable to copy properties to DTO", (Throwable)e);
                }
            }
        });
        try {
            this.updateOntology(vitamContext, (String)partialDto.get("id"), ontologyDto);
            return ontologyDto;
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            throw new InternalServerException("Unable to patch agency", e);
        }
    }

    private RequestResponse<?> updateOntology(VitamContext vitamContext, String id, OntologyDto patchOntology) throws InvalidParseOperationException, AccessExternalClientException, IOException {
        if (vitamContext != null) {
            LOGGER.info("Update Ontology EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        }
        List<OntologyDto> ontologies = this.getAll(vitamContext);
        ontologies.stream().filter(ontology -> id.equals(ontology.getId())).forEach(ontology -> this.patchFields((OntologyDto)ontology, patchOntology));
        return this.ontologyService.importOntologies(vitamContext, this.converter.convertDtosToVitams(ontologies));
    }

    private void patchFields(OntologyDto ontologyToPatch, OntologyDto fieldsToApply) {
        if (fieldsToApply.getShortName() != null) {
            ontologyToPatch.setShortName(fieldsToApply.getShortName());
        }
        if (fieldsToApply.getDescription() != null) {
            ontologyToPatch.setDescription(fieldsToApply.getDescription());
        }
        if (fieldsToApply.getType() != null) {
            ontologyToPatch.setType(fieldsToApply.getType());
        }
        if (fieldsToApply.getCollections() != null) {
            ontologyToPatch.setCollections(fieldsToApply.getCollections());
        }
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String id) throws VitamClientException {
        try {
            return this.logbookService.selectOperations(VitamQueryHelper.buildOperationQuery((String)id), vitamContext).toJsonNode();
        }
        catch (InvalidCreateOperationException e) {
            throw new InternalServerException("Unable to fetch history", (Throwable)e);
        }
    }

    public JsonNode importOntologies(VitamContext context, String fileName, MultipartFile file) {
        try {
            RequestResponse requestResponse = this.ontologyService.importOntologies(context, fileName, file);
            VitamRestUtils.checkResponse((RequestResponse)requestResponse, (Integer[])new Integer[]{200, 204});
            return requestResponse.toJsonNode();
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            throw new InternalServerException("Unable to import ontology file " + fileName + " : ", e);
        }
    }

    public List<VitamUiOntologyDto> readInternalOntologyFromFile() throws IOException {
        LOGGER.debug("get default internal ontologie file from path : {} ", (Object)this.internalOntologieFilePath);
        return OntologyServiceReader.readInternalOntologyFromFile((String)this.internalOntologieFilePath);
    }
}

