/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.managementcontract.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.ManagementContractDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.administration.ManagementContractService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.ManagementContractResponseDto;
import fr.gouv.vitamui.referential.common.dto.ManagementContractVitamDto;
import fr.gouv.vitamui.referential.common.service.VitamUIManagementContractService;
import fr.gouv.vitamui.referential.internal.server.managementcontract.ManagementContractDtoToModelConverter;
import fr.gouv.vitamui.referential.internal.server.managementcontract.ManagementContractModelToDtoConverter;
import fr.gouv.vitamui.referential.internal.server.managementcontract.PatchManagementContractModel;
import fr.gouv.vitamui.referential.internal.server.managementcontract.converter.ManagementContractConverter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagementContractInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ManagementContractInternalService.class);
    private static final String MANAGEMENT_CONTRACT_NOT_FOUND = "Unable to find Management Contracts";
    private static final String MANAGEMENT_CONTRACT_EVENT_ID_APP_SESSION = "Management Contracts EvIdAppSession : {} ";
    private static final String MANAGEMENT_CONTRACT_NOT_PATCH = "Can't patch management contract";
    private final ObjectMapper objectMapper;
    private final ManagementContractConverter converter;
    private final ManagementContractService managementContractService;
    private final VitamUIManagementContractService vitamUIManagementContractService;
    private final LogbookService logbookService;
    private ManagementContractDtoToModelConverter managementContractDtoToModelConverter;
    private ManagementContractModelToDtoConverter managementContractModelToDtoConverter;

    @Autowired
    public ManagementContractInternalService(ManagementContractService managementContractService, VitamUIManagementContractService vitamUIManagementContractService, ObjectMapper objectMapper, ManagementContractConverter converter, LogbookService logbookService) {
        this.managementContractService = managementContractService;
        this.vitamUIManagementContractService = vitamUIManagementContractService;
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.logbookService = logbookService;
    }

    public List<ManagementContractDto> getAll(VitamContext vitamContext) {
        try {
            LOGGER.debug(MANAGEMENT_CONTRACT_EVENT_ID_APP_SESSION, (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.managementContractService.findManagementContracts(vitamContext, (JsonNode)new Select().getFinalSelect());
            ManagementContractResponseDto managementContractResponseDto = (ManagementContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ManagementContractResponseDto.class);
            return this.converter.convertVitamListMgtContractToVitamUIMgtContractDtos(managementContractResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            LOGGER.error(MANAGEMENT_CONTRACT_NOT_FOUND + e.getMessage());
            throw new InternalServerException(MANAGEMENT_CONTRACT_NOT_FOUND, e);
        }
    }

    public ManagementContractDto getOne(VitamContext vitamContext, String identifier) {
        try {
            LOGGER.debug(MANAGEMENT_CONTRACT_EVENT_ID_APP_SESSION, (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.managementContractService.findManagementContractById(vitamContext, identifier);
            ManagementContractResponseDto managementContractResponseDto = (ManagementContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ManagementContractResponseDto.class);
            return managementContractResponseDto.getResults().isEmpty() ? null : this.converter.convertVitamMgtContractToVitamUiDto((ManagementContractVitamDto)managementContractResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException exception) {
            LOGGER.error("Unable to get Management Contract");
            throw new InternalServerException("Unable to get Management Contract", exception);
        }
    }

    public PaginatedValuesDto<ManagementContractDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        Map vitamCriteria = new HashMap();
        LOGGER.debug(MANAGEMENT_CONTRACT_EVENT_ID_APP_SESSION, (Object)vitamContext.getApplicationSessionId());
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            LOGGER.error("Can't create dsl query to get paginated management contracts");
            throw new InternalServerException("Can't create dsl query to get paginated management contracts", ioe);
        }
        catch (IOException e) {
            LOGGER.error("Can't parse criteria as Vitam query");
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        ManagementContractResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<ManagementContractDto> valuesDto = this.converter.convertVitamListMgtContractToVitamUIMgtContractDtos(results.getResults());
        LOGGER.debug("Vitam UI DTO: {}", valuesDto);
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    public ManagementContractResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            LOGGER.debug(MANAGEMENT_CONTRACT_EVENT_ID_APP_SESSION, (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.managementContractService.findManagementContracts(vitamContext, query);
            ManagementContractResponseDto managementContractResponseDto = (ManagementContractResponseDto)this.objectMapper.convertValue((Object)requestResponse.toJsonNode(), ManagementContractResponseDto.class);
            LOGGER.debug("VITAM DTO: {}", (Object)managementContractResponseDto);
            return managementContractResponseDto;
        }
        catch (VitamClientException exception) {
            LOGGER.error(MANAGEMENT_CONTRACT_NOT_FOUND + exception);
            throw new InternalServerException(MANAGEMENT_CONTRACT_NOT_FOUND, (Throwable)exception);
        }
    }

    public Boolean check(VitamContext vitamContext, ManagementContractDto managementContractDto) {
        try {
            LOGGER.debug(MANAGEMENT_CONTRACT_EVENT_ID_APP_SESSION, (Object)vitamContext.getApplicationSessionId());
            Integer managementContractCheckedTenant = this.managementContractService.checkAbilityToCreateManagementContractInVitam(this.converter.convertVitamUiListMgtContractToVitamListMgtContract(Collections.singletonList(managementContractDto)), vitamContext.getApplicationSessionId());
            return !vitamContext.getTenantId().equals(managementContractCheckedTenant);
        }
        catch (ConflictException e) {
            LOGGER.error("Error while checking management Contract", (Object)e.getMessage());
            return true;
        }
    }

    public ManagementContractDto create(VitamContext vitamContext, ManagementContractDto managementContractDto) {
        try {
            LOGGER.debug(MANAGEMENT_CONTRACT_EVENT_ID_APP_SESSION, (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.managementContractService.createManagementContracts(vitamContext, Collections.singletonList(this.converter.convertVitamUiManagementContractToVitamMgt(managementContractDto)));
            ManagementContractVitamDto managementContractModelDto = (ManagementContractVitamDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), ManagementContractVitamDto.class);
            return this.converter.convertVitamMgtContractToVitamUiDto(managementContractModelDto);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            LOGGER.error("Can't create management contract");
            throw new InternalServerException("Can't create management contract", e);
        }
    }

    public ManagementContractDto patch(VitamContext vitamContext, ManagementContractDto managementContractDto) throws AccessExternalClientException, InvalidParseOperationException, JsonProcessingException {
        String identifier = managementContractDto.getIdentifier();
        ManagementContractModel managementContractModel = this.managementContractDtoToModelConverter.convert(managementContractDto);
        String serializedManagementContractModel = this.objectMapper.writeValueAsString((Object)managementContractModel);
        PatchManagementContractModel patchManagementContractModel = (PatchManagementContractModel)this.objectMapper.readValue(serializedManagementContractModel, PatchManagementContractModel.class);
        JsonNode patchQuery = this.buildPatchQuery(patchManagementContractModel);
        RequestResponse requestResponse = this.vitamUIManagementContractService.patchManagementContract(vitamContext, identifier, patchQuery);
        if (Response.Status.OK.getStatusCode() != requestResponse.getHttpCode()) {
            throw new AccessExternalClientException(MANAGEMENT_CONTRACT_NOT_PATCH);
        }
        return this.getOne(vitamContext, identifier);
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String id) throws VitamClientException {
        try {
            LOGGER.debug(MANAGEMENT_CONTRACT_EVENT_ID_APP_SESSION, (Object)vitamContext.getApplicationSessionId());
            return this.logbookService.selectOperations(VitamQueryHelper.buildOperationQuery((String)id), vitamContext).toJsonNode();
        }
        catch (InvalidCreateOperationException e) {
            LOGGER.error("Unable to fetch history");
            throw new InternalServerException("Unable to fetch history", (Throwable)e);
        }
    }

    @Autowired
    public void setManagementContractDtoToModelConverter(ManagementContractDtoToModelConverter managementContractDtoToModelConverter) {
        this.managementContractDtoToModelConverter = managementContractDtoToModelConverter;
    }

    @Autowired
    public void setManagementContractModelToDtoConverter(ManagementContractModelToDtoConverter managementContractModelToDtoConverter) {
        this.managementContractModelToDtoConverter = managementContractModelToDtoConverter;
    }

    private JsonNode buildPatchQuery(PatchManagementContractModel patchManagementContractModel) {
        JsonNode jsonNode = this.objectMapper.valueToTree((Object)patchManagementContractModel);
        ObjectNode action = JsonHandler.createObjectNode();
        action.set("$set", jsonNode);
        ArrayNode actions = JsonHandler.createArrayNode();
        actions.add((JsonNode)action);
        ObjectNode query = JsonHandler.createObjectNode();
        query.set("$action", (JsonNode)actions);
        return query;
    }
}

