/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.managementcontract;

import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.PersistentIdentifierPolicy;
import fr.gouv.vitam.common.model.administration.PersistentIdentifierUsage;
import fr.gouv.vitam.common.model.administration.StorageDetailModel;
import fr.gouv.vitam.common.model.administration.VersionRetentionPolicyModel;
import fr.gouv.vitam.common.model.administration.VersionUsageModel;
import fr.gouv.vitamui.commons.api.domain.ManagementContractDto;
import fr.gouv.vitamui.commons.api.domain.PersistentIdentifierPolicyMgtContractDto;
import fr.gouv.vitamui.commons.api.domain.PersistentIdentifierUsageMgtContractDto;
import fr.gouv.vitamui.commons.api.domain.StorageManagementContractDto;
import fr.gouv.vitamui.commons.api.domain.VersionRetentionPolicyMgtContractDto;
import fr.gouv.vitamui.commons.api.domain.VersionUsageMgtContractDto;
import fr.gouv.vitamui.commons.api.enums.IntermediaryVersionEnum;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class ManagementContractModelToDtoConverter
implements Converter<ManagementContractModel, ManagementContractDto> {
    public ManagementContractDto convert(@NotNull ManagementContractModel source) {
        ManagementContractDto managementContractDto = new ManagementContractDto();
        this.copyBasicProperties(source, managementContractDto);
        managementContractDto.setStorage(this.convertStorage(source.getStorage()));
        managementContractDto.setVersionRetentionPolicy(this.convertVersionRetentionPolicy(source.getVersionRetentionPolicy()));
        managementContractDto.setPersistentIdentifierPolicyList(this.convertPersistentIdentifierPolicies(source.getPersistentIdentifierPolicyList()));
        return managementContractDto;
    }

    private void copyBasicProperties(ManagementContractModel source, ManagementContractDto target) {
        if (source != null && target != null) {
            target.setTenant(source.getTenant());
            target.setVersion(source.getVersion());
            target.setName(source.getName());
            target.setIdentifier(source.getIdentifier());
            target.setDescription(source.getDescription());
            target.setStatus(source.getStatus() != null ? source.getStatus().name() : null);
            target.setCreationDate(source.getCreationdate());
            target.setLastUpdate(source.getLastupdate());
            target.setDeactivationDate(source.getDeactivationdate());
            target.setActivationDate(source.getActivationdate());
        }
    }

    private StorageManagementContractDto convertStorage(StorageDetailModel storage) {
        if (storage == null) {
            return null;
        }
        StorageManagementContractDto storageDto = new StorageManagementContractDto();
        storageDto.setUnitStrategy(storage.getUnitStrategy());
        storageDto.setObjectGroupStrategy(storage.getObjectGroupStrategy());
        storageDto.setObjectStrategy(storage.getObjectStrategy());
        return storageDto;
    }

    private VersionRetentionPolicyMgtContractDto convertVersionRetentionPolicy(VersionRetentionPolicyModel versionRetentionPolicy) {
        if (versionRetentionPolicy == null) {
            return null;
        }
        VersionRetentionPolicyMgtContractDto dto = new VersionRetentionPolicyMgtContractDto();
        dto.setInitialVersion(versionRetentionPolicy.getInitialVersion());
        dto.setIntermediaryVersion(versionRetentionPolicy.getIntermediaryVersion() != null ? IntermediaryVersionEnum.valueOf((String)versionRetentionPolicy.getIntermediaryVersion().name()) : null);
        dto.setUsages(this.convertVersionUsages(versionRetentionPolicy.getUsages()));
        return dto;
    }

    private Set<VersionUsageMgtContractDto> convertVersionUsages(Set<VersionUsageModel> versionUsages) {
        if (versionUsages == null) {
            return null;
        }
        return versionUsages.stream().map(this::convertVersionUsage).collect(Collectors.toSet());
    }

    private VersionUsageMgtContractDto convertVersionUsage(VersionUsageModel versionUsageModel) {
        if (versionUsageModel == null) {
            return null;
        }
        VersionUsageMgtContractDto dto = new VersionUsageMgtContractDto();
        dto.setUsageName(versionUsageModel.getUsageName());
        dto.setInitialVersion(versionUsageModel.getInitialVersion());
        dto.setIntermediaryVersion(versionUsageModel.getIntermediaryVersion() != null ? IntermediaryVersionEnum.valueOf((String)versionUsageModel.getIntermediaryVersion().name()) : null);
        return dto;
    }

    private List<PersistentIdentifierPolicyMgtContractDto> convertPersistentIdentifierPolicies(List<PersistentIdentifierPolicy> policies) {
        if (policies == null) {
            return null;
        }
        return policies.stream().map(this::convertPersistentIdentifierPolicy).collect(Collectors.toList());
    }

    private PersistentIdentifierPolicyMgtContractDto convertPersistentIdentifierPolicy(PersistentIdentifierPolicy policy) {
        if (policy == null) {
            return null;
        }
        PersistentIdentifierPolicyMgtContractDto dto = new PersistentIdentifierPolicyMgtContractDto();
        dto.setPersistentIdentifierAuthority(policy.getPersistentIdentifierAuthority());
        dto.setPersistentIdentifierUnit(policy.isPersistentIdentifierUnit());
        dto.setPersistentIdentifierPolicyType(policy.getPersistentIdentifierPolicyType() != null ? policy.getPersistentIdentifierPolicyType().name() : null);
        dto.setPersistentIdentifierUsages(this.convertPersistentIdentifierUsages(policy.getPersistentIdentifierUsages()));
        return dto;
    }

    private List<PersistentIdentifierUsageMgtContractDto> convertPersistentIdentifierUsages(List<PersistentIdentifierUsage> usages) {
        if (usages == null) {
            return null;
        }
        return usages.stream().map(this::convertPersistentIdentifierUsage).collect(Collectors.toList());
    }

    private PersistentIdentifierUsageMgtContractDto convertPersistentIdentifierUsage(PersistentIdentifierUsage usage) {
        if (usage == null) {
            return null;
        }
        PersistentIdentifierUsageMgtContractDto dto = new PersistentIdentifierUsageMgtContractDto();
        dto.setUsageName(usage.getUsageName() != null ? usage.getUsageName().getName() : null);
        dto.setInitialVersion(usage.isInitialVersion());
        dto.setIntermediaryVersion(usage.getIntermediaryVersion() != null ? IntermediaryVersionEnum.valueOf((String)usage.getIntermediaryVersion().name()) : null);
        return dto;
    }
}

