/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.ingestcontract;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.dtos.ErrorImportFile;
import fr.gouv.vitamui.commons.api.enums.ErrorImportFileMessage;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.iam.internal.client.ApplicationInternalRestClient;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.IngestContractDto;
import fr.gouv.vitamui.referential.common.dto.IngestContractResponseDto;
import fr.gouv.vitamui.referential.common.service.IngestContractService;
import fr.gouv.vitamui.referential.internal.server.ingestcontract.ExportIngestContracts;
import fr.gouv.vitamui.referential.internal.server.ingestcontract.IngestContractCSVUtils;
import fr.gouv.vitamui.referential.internal.server.ingestcontract.IngestContractConverter;
import fr.gouv.vitamui.referential.internal.server.utils.ExportCSVUtils;
import fr.gouv.vitamui.referential.internal.server.utils.ImportCSVUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class IngestContractInternalService {
    private static final String INGEST_CONTRACT = "INGEST_CONTRACT";
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IngestContractInternalService.class);
    private final IngestContractService ingestContractService;
    private final ObjectMapper objectMapper;
    private final IngestContractConverter converter;
    private final LogbookService logbookService;
    private final ApplicationInternalRestClient applicationInternalRestClient;
    private final InternalSecurityService internalSecurityService;

    @Autowired
    public IngestContractInternalService(IngestContractService ingestContractService, ObjectMapper objectMapper, IngestContractConverter converter, LogbookService logbookService, ApplicationInternalRestClient applicationInternalRestClient, InternalSecurityService internalSecurityService) {
        this.ingestContractService = ingestContractService;
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.logbookService = logbookService;
        this.applicationInternalRestClient = applicationInternalRestClient;
        this.internalSecurityService = internalSecurityService;
    }

    public IngestContractDto getOne(VitamContext vitamContext, String identifier) {
        try {
            LOGGER.info("Ingest Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.ingestContractService.findIngestContractById(vitamContext, identifier);
            IngestContractResponseDto ingestContractResponseDto = (IngestContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), IngestContractResponseDto.class);
            if (ingestContractResponseDto.getResults().isEmpty()) {
                return null;
            }
            return this.converter.convertVitamToDto((IngestContractModel)ingestContractResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Ingest Contrat", e);
        }
    }

    public List<IngestContractDto> getAll(VitamContext vitamContext) {
        try {
            LOGGER.debug("All Ingest Contracts EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.ingestContractService.findIngestContracts(vitamContext, (JsonNode)new Select().getFinalSelect());
            IngestContractResponseDto ingestContractResponseDto = (IngestContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), IngestContractResponseDto.class);
            return this.converter.convertVitamsToDtos(ingestContractResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Ingest Contrats", e);
        }
    }

    public PaginatedValuesDto<IngestContractDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        Map vitamCriteria = new HashMap();
        LOGGER.debug("All Ingest Contracts EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            JsonNode query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
            IngestContractResponseDto results = this.findAll(vitamContext, query);
            boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
            List<IngestContractDto> valuesDto = this.converter.convertVitamsToDtos(results.getResults());
            LOGGER.debug("Vitam UI DTO: {}", valuesDto);
            return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Can't create dsl query to get paginated ingest contracts", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
    }

    public IngestContractResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            LOGGER.info("All Ingest Contracts EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.ingestContractService.findIngestContracts(vitamContext, query);
            LOGGER.debug("VITAM Response: {}", (Object)requestResponse.toJsonNode().toPrettyString());
            IngestContractResponseDto ingestContractResponseDto = (IngestContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), IngestContractResponseDto.class);
            LOGGER.debug("VITAM DTO: {}", (Object)ingestContractResponseDto);
            return ingestContractResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find Ingest Contrats", e);
        }
    }

    public Boolean check(VitamContext vitamContext, IngestContractDto ingestContractDto) {
        try {
            LOGGER.debug("Ingest Contract Check EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            Integer ingestContractCheckedTenant = this.ingestContractService.checkAbilityToCreateIngestContractInVitam(this.converter.convertDtosToVitams(Arrays.asList(ingestContractDto)), vitamContext.getApplicationSessionId());
            return !vitamContext.getTenantId().equals(ingestContractCheckedTenant);
        }
        catch (ConflictException e) {
            return true;
        }
    }

    public IngestContractDto create(VitamContext vitamContext, IngestContractDto ingestContractDto) {
        this.ingestContractService.checkAbilityToCreateIngestContractInVitam(this.converter.convertDtosToVitams(Arrays.asList(ingestContractDto)), vitamContext.getApplicationSessionId());
        try {
            LOGGER.debug("Create Ingest Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.ingestContractService.createIngestContracts(vitamContext, this.converter.convertDtosToVitams(Arrays.asList(ingestContractDto)));
            IngestContractModel ingestContractVitamDto = (IngestContractModel)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), IngestContractModel.class);
            return this.converter.convertVitamToDto(ingestContractVitamDto);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            throw new InternalServerException("Can't create ingest contract", e);
        }
    }

    private JsonNode convertMapPartialDtoToUpperCaseVitamFields(Map<String, Object> partialDto) {
        ArrayNode array;
        ObjectNode propertiesToUpdate = JsonHandler.createObjectNode();
        if (partialDto.get("name") != null) {
            propertiesToUpdate.put("Name", (String)partialDto.get("name"));
        }
        if (partialDto.get("description") != null) {
            propertiesToUpdate.put("Description", (String)partialDto.get("description"));
        }
        if (partialDto.get("checkParentLink") != null) {
            propertiesToUpdate.put("CheckParentLink", (String)partialDto.get("checkParentLink"));
        }
        if (partialDto.get("linkParentId") != null) {
            propertiesToUpdate.put("LinkParentId", (String)partialDto.get("linkParentId"));
        }
        if (partialDto.get("managementContractId") != null) {
            propertiesToUpdate.put("ManagementContractId", (String)partialDto.get("managementContractId"));
        }
        if (partialDto.get("status") != null) {
            propertiesToUpdate.put("Status", (String)partialDto.get("status"));
        }
        if (partialDto.get("activationDate") != null) {
            propertiesToUpdate.put("ActivationDate", (String)partialDto.get("activationDate"));
        }
        if (partialDto.get("deactivationDate") != null) {
            propertiesToUpdate.put("DeactivationDate", (String)partialDto.get("deactivationDate"));
        }
        if (partialDto.get("lastUpdate") != null) {
            propertiesToUpdate.put("LastUpdate", (String)partialDto.get("lastUpdate"));
        }
        if (partialDto.get("creationDate") != null) {
            propertiesToUpdate.put("CreationDate", (String)partialDto.get("creationDate"));
        }
        if (partialDto.get("masterMandatory") != null) {
            propertiesToUpdate.put("MasterMandatory", ((Boolean)partialDto.get("masterMandatory")).booleanValue());
        }
        if (partialDto.get("formatUnidentifiedAuthorized") != null) {
            propertiesToUpdate.put("FormatUnidentifiedAuthorized", ((Boolean)partialDto.get("formatUnidentifiedAuthorized")).booleanValue());
        }
        if (partialDto.get("everyFormatType") != null) {
            propertiesToUpdate.put("EveryFormatType", ((Boolean)partialDto.get("everyFormatType")).booleanValue());
        }
        if (partialDto.get("everyDataObjectVersion") != null) {
            propertiesToUpdate.put("EveryDataObjectVersion", ((Boolean)partialDto.get("everyDataObjectVersion")).booleanValue());
        }
        if (partialDto.get("checkParentId") != null) {
            array = JsonHandler.createArrayNode();
            for (String value : (List)partialDto.get("checkParentId")) {
                array.add(value);
            }
            propertiesToUpdate.set("CheckParentId", (JsonNode)array);
        }
        if (partialDto.get("formatType") != null) {
            array = JsonHandler.createArrayNode();
            for (String value : (List)partialDto.get("formatType")) {
                array.add(value);
            }
            propertiesToUpdate.set("FormatType", (JsonNode)array);
        }
        if (partialDto.get("archiveProfiles") != null) {
            array = JsonHandler.createArrayNode();
            for (String value : (List)partialDto.get("archiveProfiles")) {
                array.add(value);
            }
            propertiesToUpdate.set("ArchiveProfiles", (JsonNode)array);
        }
        if (partialDto.get("dataObjectVersion") != null) {
            array = JsonHandler.createArrayNode();
            for (String value : (List)partialDto.get("dataObjectVersion")) {
                array.add(value);
            }
            propertiesToUpdate.set("DataObjectVersion", (JsonNode)array);
        }
        if (partialDto.get("computeInheritedRulesAtIngest") != null) {
            propertiesToUpdate.put("ComputeInheritedRulesAtIngest", ((Boolean)partialDto.get("computeInheritedRulesAtIngest")).booleanValue());
        }
        if (partialDto.get("signaturePolicy") != null) {
            Map<String, Object> map = (Map<String, Object>)partialDto.get("signaturePolicy");
            map = map.entrySet().stream().collect(Collectors.toMap(entry -> StringUtils.capitalize((String)((String)entry.getKey())), Map.Entry::getValue));
            JsonNode signaturePolicy = this.objectMapper.valueToTree(map);
            propertiesToUpdate.set("SignaturePolicy", signaturePolicy);
        }
        return propertiesToUpdate;
    }

    public IngestContractDto patch(VitamContext vitamContext, Map<String, Object> partialDto) {
        String id = (String)partialDto.get("identifier");
        if (id == null) {
            throw new BadRequestException("id must be one the the update criteria");
        }
        partialDto.remove("id");
        partialDto.remove("identifier");
        try {
            LOGGER.debug("Patch Ingest Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            JsonNode fieldsUpdated = this.convertMapPartialDtoToUpperCaseVitamFields(partialDto);
            ArrayNode actions = JsonHandler.createArrayNode();
            if (partialDto.containsKey("managementContractId") && partialDto.get("managementContractId") == null) {
                ObjectNode unsetAction = JsonNodeFactory.instance.objectNode();
                ArrayNode unsetArray = JsonNodeFactory.instance.arrayNode();
                unsetArray.add("ManagementContractId");
                unsetAction.set("$unset", (JsonNode)unsetArray);
                actions.add((JsonNode)unsetAction);
            }
            if (!fieldsUpdated.isEmpty()) {
                ObjectNode action = JsonHandler.createObjectNode();
                action.set("$set", fieldsUpdated);
                actions.add((JsonNode)action);
            }
            ObjectNode query = JsonHandler.createObjectNode();
            query.set("$action", (JsonNode)actions);
            LOGGER.debug("Send IngestContract update request: {}", (Object)query);
            RequestResponse requestResponse = this.ingestContractService.patchIngestContract(vitamContext, id, query);
            if (Response.Status.OK.getStatusCode() != requestResponse.getHttpCode()) {
                throw new AccessExternalClientException("Can't patch ingest contract");
            }
            return this.getOne(vitamContext, id);
        }
        catch (AccessExternalClientException | InvalidParseOperationException e) {
            throw new InternalServerException("Can't patch ingest contract", e);
        }
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String id) throws VitamClientException {
        try {
            LOGGER.info("Ingest Contract History EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            return this.logbookService.selectOperations(VitamQueryHelper.buildOperationQuery((String)id), vitamContext).toJsonNode();
        }
        catch (InvalidCreateOperationException e) {
            throw new InternalServerException("Unable to fetch history", (Throwable)e);
        }
    }

    public ResponseEntity<Void> importIngestContracts(VitamContext vitamContext, MultipartFile file) {
        RequestResponse result;
        Boolean isIdentifierMandatory = (Boolean)this.applicationInternalRestClient.isApplicationExternalIdentifierEnabled(this.internalSecurityService.getHttpContext(), INGEST_CONTRACT).getBody();
        if (isIdentifierMandatory == null) {
            throw new InternalServerException("The result of the API call should not be null");
        }
        IngestContractCSVUtils.checkImportFile(file, isIdentifierMandatory);
        LOGGER.debug("ingest contracts file {} has been validated before parsing it", (Object)file.getOriginalFilename());
        List<IngestContractDto> ingestContractDtos = this.convertCsvFileToIngestContractsDto(file);
        LOGGER.debug("ingest contracts file {} has been parsed in accessContract List", (Object)file.getOriginalFilename());
        try {
            result = this.ingestContractService.createIngestContracts(vitamContext, this.converter.convertDtosToVitams(ingestContractDtos));
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IOException e) {
            throw new InternalServerException("Can't create ingest contracts", e);
        }
        if (HttpStatus.OK.value() == result.getHttpCode()) {
            LOGGER.debug("ingest contracts file {} has been successfully import to VITAM", (Object)file.getOriginalFilename());
            return new ResponseEntity(HttpStatus.CREATED);
        }
        throw new BadRequestException("The CSV file has been rejected by vitam", null, List.of(ImportCSVUtils.errorToJson(ErrorImportFile.builder().error(ErrorImportFileMessage.REJECT_BY_VITAM_CHECK_LOGBOOK_OPERATION_APP).build())));
    }

    private List<IngestContractDto> convertCsvFileToIngestContractsDto(MultipartFile file) {
        List list;
        InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(file.getInputStream()), StandardCharsets.UTF_8);
        try {
            CsvToBean csvToBean = new CsvToBeanBuilder((Reader)reader).withType(IngestContractDto.class).withIgnoreLeadingWhiteSpace(true).withFieldAsNull(CSVReaderNullFieldIndicator.BOTH).withSeparator(';').build();
            list = csvToBean.parse();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException e) {
                throw new BadRequestException("Unable to read access contracts CSV file ", (Throwable)e);
            }
        }
        ((Reader)reader).close();
        return list;
    }

    public Resource exportIngestContracts(VitamContext vitamContext) {
        List<IngestContractDto> ingestContracts = this.getAll(vitamContext);
        ExportIngestContracts exporter = new ExportIngestContracts();
        ArrayList<String[]> csvLines = new ArrayList<String[]>();
        csvLines.add(exporter.getHeaders().toArray(new String[exporter.getSize()]));
        SimpleDateFormat dateFormat = new SimpleDateFormat(exporter.getPatternDate());
        ingestContracts.forEach(ingestContract -> {
            try {
                csvLines.add(this.buildIngestContractExportValues((IngestContractDto)ingestContract, exporter.getArrayJoinStr(), dateFormat));
            }
            catch (ParseException e) {
                throw new BadRequestException("Unable to parse ingest contract to a csv line", (Throwable)e);
            }
        });
        return ExportCSVUtils.generateCSVFile(csvLines, exporter.getSeparator());
    }

    private String[] buildIngestContractExportValues(IngestContractDto ingestContract, String arrayJoinStr, DateFormat df) throws ParseException {
        String archiveProfiles = ingestContract.getArchiveProfiles() == null ? null : String.join((CharSequence)arrayJoinStr, ingestContract.getArchiveProfiles());
        String checkParentId = ingestContract.getCheckParentId() == null ? null : String.join((CharSequence)arrayJoinStr, ingestContract.getCheckParentId());
        String dataObjectVersion = ingestContract.getDataObjectVersion() == null ? null : String.join((CharSequence)arrayJoinStr, ingestContract.getDataObjectVersion());
        String formatType = ingestContract.getFormatType() == null ? null : String.join((CharSequence)arrayJoinStr, ingestContract.getFormatType());
        String activationDate = ingestContract.getActivationDate() == null ? null : df.format(LocalDateUtil.getDate((String)ingestContract.getActivationDate()));
        String deactivationDate = ingestContract.getDeactivationDate() == null ? null : df.format(LocalDateUtil.getDate((String)ingestContract.getDeactivationDate()));
        return new String[]{ingestContract.getIdentifier(), ingestContract.getName(), ingestContract.getDescription(), String.valueOf(ingestContract.getStatus()), archiveProfiles, ingestContract.getCheckParentLink(), checkParentId, ingestContract.getLinkParentId(), String.valueOf(ingestContract.isFormatUnidentifiedAuthorized()), String.valueOf(ingestContract.isEveryFormatType()), formatType, ingestContract.getManagementContractId(), String.valueOf(ingestContract.isComputeInheritedRulesAtIngest()), String.valueOf(ingestContract.isMasterMandatory()), String.valueOf(ingestContract.isEveryDataObjectVersion()), dataObjectVersion, activationDate, deactivationDate};
    }
}

