/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.fileformat;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.api.AdminCollections;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.FileFormatModel;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.NotImplementedException;
import fr.gouv.vitamui.commons.api.exception.VitamUIException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.FileFormatDto;
import fr.gouv.vitamui.referential.common.dto.FileFormatResponseDto;
import fr.gouv.vitamui.referential.common.service.VitamFileFormatService;
import fr.gouv.vitamui.referential.internal.server.fileformat.FileFormatConverter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileFormatInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(FileFormatInternalService.class);
    private ObjectMapper objectMapper;
    private FileFormatConverter converter;
    private LogbookService logbookService;
    private VitamFileFormatService vitamFileFormatService;

    @Autowired
    public FileFormatInternalService(ObjectMapper objectMapper, FileFormatConverter converter, LogbookService logbookService, VitamFileFormatService vitamFileFormatService) {
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.logbookService = logbookService;
        this.vitamFileFormatService = vitamFileFormatService;
    }

    public FileFormatDto getOne(VitamContext vitamContext, String identifier) {
        try {
            LOGGER.info("File Format EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamFileFormatService.findFileFormatById(vitamContext, identifier);
            FileFormatResponseDto fileFormatResponseDto = (FileFormatResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatResponseDto.class);
            if (fileFormatResponseDto.getResults().size() == 0) {
                return null;
            }
            return this.converter.convertVitamToDto((FileFormatModel)fileFormatResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get FileFormat", e);
        }
    }

    public List<FileFormatDto> getAll(VitamContext vitamContext) {
        LOGGER.debug("Get ALL File Formats !");
        try {
            LOGGER.info("All File Formats EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamFileFormatService.findFileFormats(vitamContext, (JsonNode)new Select().getFinalSelect());
            LOGGER.debug("Response: {}", (Object)requestResponse);
            FileFormatResponseDto fileFormatResponseDto = (FileFormatResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatResponseDto.class);
            return this.converter.convertVitamsToDtos(fileFormatResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find fileFormats", e);
        }
    }

    public PaginatedValuesDto<FileFormatDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        LOGGER.info("All File Formats EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        Map vitamCriteria = new HashMap();
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find fileFormats with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        FileFormatResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<FileFormatDto> valuesDto = this.converter.convertVitamsToDtos(results.getResults());
        LOGGER.debug("Formats in page: {}", valuesDto);
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    private FileFormatResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            LOGGER.info("All File Formats EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamFileFormatService.findFileFormats(vitamContext, query);
            FileFormatResponseDto fileFormatResponseDto = (FileFormatResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatResponseDto.class);
            LOGGER.debug("Formats: {}", (Object)fileFormatResponseDto);
            return fileFormatResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find fileFormats", e);
        }
    }

    public Boolean check(VitamContext vitamContext, FileFormatDto accessContractDto) {
        ArrayList<FileFormatDto> fileFormatDtoList = new ArrayList<FileFormatDto>();
        fileFormatDtoList.add(accessContractDto);
        LOGGER.info("File Format Check EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        try {
            return !this.vitamFileFormatService.checkAbilityToCreateFileFormatInVitam(this.converter.convertDtosToVitams(fileFormatDtoList), vitamContext);
        }
        catch (ConflictException e) {
            return true;
        }
        catch (VitamUIException e) {
            throw new InternalServerException("Unable to check fileFormat", (Throwable)e);
        }
    }

    public FileFormatDto create(VitamContext vitamContext, FileFormatDto fileformatDto) {
        LOGGER.debug("Try to create File Format {} {}", (Object)fileformatDto, (Object)vitamContext);
        try {
            LOGGER.info("Create File Format EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.vitamFileFormatService.create(vitamContext, this.converter.convertDtoToVitam(fileformatDto));
            FileFormatModel fileFormatVitamDto = (FileFormatModel)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatModel.class);
            return this.converter.convertVitamToDto(fileFormatVitamDto);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException | JAXBException e) {
            throw new InternalServerException("Unable to create fileFormat", e);
        }
    }

    public FileFormatDto patch(VitamContext vitamContext, Map<String, Object> partialDto) {
        LOGGER.debug("Try to patch File Format {} {}", partialDto, (Object)vitamContext);
        LOGGER.info("Patch File Format EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        FileFormatDto fileFormat = this.getOne(vitamContext, (String)partialDto.get("puid"));
        partialDto.forEach((key, value) -> {
            if (!"id".equals(key)) {
                try {
                    BeanUtilsBean.getInstance().copyProperty((Object)fileFormat, key, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.warn(e.getMessage());
                }
            }
        });
        FileFormatModel fileFormatVitam = this.converter.convertDtoToVitam(fileFormat);
        try {
            String puid = (String)partialDto.get("puid");
            if (!puid.startsWith("EXTERNAL_")) {
                throw new InternalServerException("Unable to patch fileFormat: Not an external format");
            }
            RequestResponse requestResponse = this.vitamFileFormatService.patchFileFormat(vitamContext, puid, fileFormatVitam);
            FileFormatModel fileFormatVitamDto = (FileFormatModel)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), FileFormatModel.class);
            return this.converter.convertVitamToDto(fileFormatVitamDto);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException | JAXBException e) {
            throw new InternalServerException("Unable to patch fileFormat", e);
        }
    }

    public void delete(VitamContext context, String id) {
        LOGGER.debug("Try to delete File Format {} {}", (Object)id, (Object)context);
        LOGGER.debug("Delete File Format EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
        if (!id.startsWith("EXTERNAL_")) {
            throw new InternalServerException("Unable to patch fileFormat: Not an external format");
        }
        try {
            this.vitamFileFormatService.deleteFileFormat(context, id);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException | JAXBException e) {
            throw new InternalServerException("Unable to delete fileFormat", e);
        }
    }

    public Response export(VitamContext context) {
        throw new NotImplementedException("Can not export file format");
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String identifier) throws VitamClientException {
        LOGGER.debug("findHistoryById for identifier" + identifier);
        LOGGER.debug("File Format History EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        return this.logbookService.findEventsByIdentifierAndCollectionNames(identifier, AdminCollections.AGENCIES.getName(), vitamContext).toJsonNode();
    }

    public JsonNode importFileFormats(VitamContext context, String fileName, MultipartFile file) {
        try {
            return this.vitamFileFormatService.importFileFormats(context, fileName, file).toJsonNode();
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            LOGGER.error("Unable to file format file {}: {}", (Object)fileName, (Object)e.getMessage());
            throw new InternalServerException("Unable to import file format file " + fileName + " : ", e);
        }
    }
}

