/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.accessionregister;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.QueryProjection;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitamui.commons.api.domain.AccessionRegisterSearchDto;
import fr.gouv.vitamui.commons.api.domain.AgencyModelDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.commons.vitam.api.administration.AgencyService;
import fr.gouv.vitamui.commons.vitam.api.model.HitsDto;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterCsv;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterDetailDto;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterDetailResponseDto;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterStatsDto;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterSummaryDto;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterSummaryResponseDto;
import fr.gouv.vitamui.referential.common.dto.AgencyResponseDto;
import fr.gouv.vitamui.referential.common.dto.ExportAccessionRegisterResultParam;
import fr.gouv.vitamui.referential.common.service.AccessionRegisterService;
import fr.gouv.vitamui.referential.internal.server.accessionregister.AccessRegisterStatsHelper;
import fr.gouv.vitamui.referential.internal.server.accessionregister.AccessRegisterVitamQueryHelper;
import fr.gouv.vitamui.referential.internal.server.accessionregister.AccessionRegisterConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class AccessionRegisterInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessionRegisterInternalService.class);
    private final ObjectMapper objectMapper;
    private final AgencyService agencyService;
    private final AdminExternalClient adminExternalClient;
    private final AccessionRegisterService accessionRegisterService;

    @Autowired
    public AccessionRegisterInternalService(ObjectMapper objectMapper, AdminExternalClient adminExternalClient, AgencyService agencyService, AccessionRegisterService accessionRegisterService) {
        this.objectMapper = objectMapper;
        this.agencyService = agencyService;
        this.adminExternalClient = adminExternalClient;
        this.accessionRegisterService = accessionRegisterService;
    }

    public List<AccessionRegisterSummaryDto> getAll(VitamContext context) {
        try {
            LOGGER.debug("List of Accession Register EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
            RequestResponse requestResponse = this.accessionRegisterService.findAccessionRegisterSummary(context);
            AccessionRegisterSummaryResponseDto accessionRegisterSymbolicResponseDto = (AccessionRegisterSummaryResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AccessionRegisterSummaryResponseDto.class);
            return AccessionRegisterConverter.toSummaryDtos(accessionRegisterSymbolicResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find accessionRegisterSymbolic", e);
        }
    }

    public PaginatedValuesDto<AccessionRegisterDetailDto> getAllPaginated(Optional<String> criteria, Integer pageNumber, Integer pageSize, String orderBy, DirectionDto direction, VitamContext vitamContext) {
        JsonNode query;
        AccessionRegisterSearchDto accessionRegisterSearchDto;
        LOGGER.debug("List of Accession Registers EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        try {
            accessionRegisterSearchDto = criteria.isPresent() ? (AccessionRegisterSearchDto)this.objectMapper.readValue(criteria.get(), AccessionRegisterSearchDto.class) : new AccessionRegisterSearchDto();
            query = AccessRegisterVitamQueryHelper.createQueryDSL(accessionRegisterSearchDto, pageNumber, pageSize, orderBy, direction);
        }
        catch (JsonProcessingException | InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Can't create dsl query to get paginated accession registers", ioe);
        }
        AccessionRegisterDetailResponseDto results = this.fetchingAllPaginatedDataFromVitam(vitamContext, query);
        LOGGER.debug("Fetched accession register data : {} ", (Object)results);
        Map<String, String> agenciesMap = this.findAgencies(vitamContext, results);
        HitsDto hits = results.getHits();
        Integer resultSize = 0;
        Integer resultTotal = 0;
        if (hits != null) {
            resultSize = hits.getSize();
            resultTotal = hits.getTotal();
        }
        boolean hasMoreData = pageNumber * pageSize + resultSize < resultTotal;
        List<AccessionRegisterDetailDto> valuesDto = AccessionRegisterConverter.toDetailsDtos(results.getResults());
        valuesDto.forEach(value -> {
            value.setOriginatingAgencyLabel((String)agenciesMap.get(value.getOriginatingAgency()));
            value.setSubmissionAgencyLabel((String)agenciesMap.get(value.getSubmissionAgency()));
        });
        AccessionRegisterStatsDto statsDto = resultSize > resultTotal ? this.buildStatisticData(accessionRegisterSearchDto, vitamContext) : AccessRegisterStatsHelper.fetchStats(results.getResults());
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), pageSize.intValue(), resultTotal.intValue(), hasMoreData, Map.of("stats", statsDto));
    }

    private AccessionRegisterStatsDto buildStatisticData(AccessionRegisterSearchDto accessionRegisterSearchDto, VitamContext vitamContext) {
        try {
            JsonNode bigStatisticQuery = AccessRegisterVitamQueryHelper.createQueryDSL(accessionRegisterSearchDto, 0, 10000, null, null);
            AccessionRegisterDetailResponseDto statisticResults = this.fetchingAllPaginatedDataFromVitam(vitamContext, bigStatisticQuery);
            return AccessRegisterStatsHelper.fetchStats(statisticResults.getResults());
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new InternalServerException("Can't create dsl query to get paginated accession registers", e);
        }
    }

    public Resource exportToCsvAccessionRegister(AccessionRegisterSearchDto searchQuery, VitamContext vitamContext) {
        LOGGER.debug("Calling exportToCsvAccessionRegister with query {} ", (Object)searchQuery);
        Locale locale = Locale.FRENCH;
        ExportAccessionRegisterResultParam exportSearchResultParam = new ExportAccessionRegisterResultParam(locale);
        return this.exportAccessionRegistersByCriteriaAndParams(searchQuery, exportSearchResultParam, vitamContext);
    }

    private Resource exportAccessionRegistersByCriteriaAndParams(AccessionRegisterSearchDto searchQuery, ExportAccessionRegisterResultParam exportAccessionRegisterResultParam, VitamContext vitamContext) {
        try {
            List<AccessionRegisterCsv> accessionRegisterCsvList = this.exportAccessionRegisterToCsvFile(searchQuery, vitamContext);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8.name());
            String[] headerRecordFr = exportAccessionRegisterResultParam.getHeaders().toArray(new String[exportAccessionRegisterResultParam.getHeaders().size()]);
            SimpleDateFormat dateFormat = new SimpleDateFormat(exportAccessionRegisterResultParam.getPatternDate());
            ICSVWriter csvWriter = new CSVWriterBuilder((Writer)writer).withSeparator(exportAccessionRegisterResultParam.getSeparator()).withQuoteChar('\"').withEscapeChar('\"').withLineEnd("\n").build();
            csvWriter.writeNext(headerRecordFr);
            accessionRegisterCsvList.stream().forEach(accessionRegisterCsv -> {
                String startDateFormated = null;
                if (accessionRegisterCsv.getStartDate() != null) {
                    try {
                        startDateFormated = dateFormat.format(LocalDateUtil.getDate((String)accessionRegisterCsv.getStartDate()));
                    }
                    catch (ParseException e) {
                        LOGGER.error("Error parsing starting date {} ", (Object)accessionRegisterCsv.getStartDate());
                    }
                }
                csvWriter.writeNext(new String[]{accessionRegisterCsv.getOpi(), startDateFormated, accessionRegisterCsv.getOriginatingAgency(), accessionRegisterCsv.getSubmissionAgency(), accessionRegisterCsv.getArchivalAgreement(), accessionRegisterCsv.getAcquisitionInformation(), accessionRegisterCsv.getLegalStatus(), String.valueOf(accessionRegisterCsv.getTotalUnits().getIngested()), String.valueOf(accessionRegisterCsv.getTotalObjectsGroups().getIngested()), String.valueOf(accessionRegisterCsv.getTotalObjects().getIngested()), VitamUIUtils.humanReadableByteCountBin((long)accessionRegisterCsv.getObjectSize().getIngested()), accessionRegisterCsv.getStatus().value()});
            });
            csvWriter.close();
            ((Writer)writer).close();
            return new ByteArrayResource(outputStream.toByteArray());
        }
        catch (IOException ex) {
            throw new BadRequestException("Unable to export csv file ", (Throwable)ex);
        }
    }

    private List<AccessionRegisterCsv> exportAccessionRegisterToCsvFile(AccessionRegisterSearchDto searchQuery, VitamContext vitamContext) {
        try {
            JsonNode query = AccessRegisterVitamQueryHelper.createQueryDSL(searchQuery);
            LOGGER.debug("Final query details: {}", (Object)query.toPrettyString());
            AccessionRegisterDetailResponseDto accessionRegisterDetailResponseDto = this.fetchingAllPaginatedDataFromVitam(vitamContext, query);
            LOGGER.debug("Fetched accession register data : {} ", (Object)accessionRegisterDetailResponseDto);
            List<Object> accessionRegisterList = new ArrayList<AccessionRegisterCsv>();
            if (accessionRegisterDetailResponseDto != null) {
                accessionRegisterList = accessionRegisterDetailResponseDto.getResults().stream().map(this::fillOriginatingAgencyName).collect(Collectors.toList());
            }
            return accessionRegisterList;
        }
        catch (InvalidCreateOperationException e) {
            throw new BadRequestException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        catch (InvalidParseOperationException ioe) {
            throw new InternalServerException("Can't create dsl query to get ordered accession registers", (Throwable)ioe);
        }
    }

    private AccessionRegisterCsv fillOriginatingAgencyName(AccessionRegisterDetailModel accessionRegister) {
        AccessionRegisterCsv accessionRegisterCsv = new AccessionRegisterCsv();
        BeanUtils.copyProperties((Object)accessionRegister, (Object)accessionRegisterCsv);
        return accessionRegisterCsv;
    }

    private AccessionRegisterDetailResponseDto fetchingAllPaginatedDataFromVitam(VitamContext vitamContext, JsonNode query) {
        AccessionRegisterDetailResponseDto results;
        try {
            RequestResponse accessionRegisterDetails = this.adminExternalClient.findAccessionRegisterDetails(vitamContext, query);
            results = (AccessionRegisterDetailResponseDto)this.objectMapper.treeToValue((TreeNode)accessionRegisterDetails.toJsonNode(), AccessionRegisterDetailResponseDto.class);
        }
        catch (VitamClientException e) {
            throw new InternalServerException("Can't fetch data from VITAM", (Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Can't process Json Parsing", (Throwable)e);
        }
        return results;
    }

    private Map<String, String> findAgencies(VitamContext vitamContext, AccessionRegisterDetailResponseDto results) {
        List agencies;
        try {
            JsonNode agencyQuery = this.buildAgencyProjectionQuery(results);
            RequestResponse requestResponse = this.agencyService.findAgencies(vitamContext, agencyQuery);
            agencies = ((AgencyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class)).getResults();
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error parsing query", (Throwable)e);
        }
        catch (VitamClientException e) {
            throw new InternalServerException("Error fetching agencies from vitam", (Throwable)e);
        }
        catch (InvalidCreateOperationException e) {
            throw new InternalServerException("Invalid Select vitam query", (Throwable)e);
        }
        return agencies.stream().collect(Collectors.toMap(AgencyModelDto::getIdentifier, AgencyModelDto::getName));
    }

    private JsonNode buildAgencyProjectionQuery(AccessionRegisterDetailResponseDto results) throws InvalidCreateOperationException {
        List<Object> distinctOriginatingAgencies = new ArrayList();
        if (results != null) {
            distinctOriginatingAgencies = results.getResults().stream().map(AccessionRegisterDetailModel::getOriginatingAgency).filter(Objects::nonNull).filter(originatingAgency -> ConcurrentHashMap.newKeySet().add((String)originatingAgency)).collect(Collectors.toList());
            distinctOriginatingAgencies.addAll(results.getResults().stream().map(AccessionRegisterDetailModel::getSubmissionAgency).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        Select select = new Select();
        select.setQuery((Query)QueryHelper.in((String)"Identifier", (String[])distinctOriginatingAgencies.toArray(new String[0])));
        HashMap<String, Integer> projection = new HashMap<String, Integer>();
        projection.put("Identifier", 1);
        projection.put("Name", 1);
        QueryProjection queryProjection = new QueryProjection();
        queryProjection.setFields(projection);
        try {
            select.setProjection(JsonHandler.toJsonNode((Object)queryProjection));
        }
        catch (InvalidParseOperationException e) {
            throw new InvalidCreateOperationException("Invalid vitam query", (Throwable)e);
        }
        LOGGER.debug("agencies query: {}", (Object)select.getFinalSelect());
        return select.getFinalSelect();
    }
}

